#if !defined SHADOW_DISTORTION_LIB
#define SHADOW_DISTORTION_LIB
    #define SHADOW_DISTANCE_EFFECTIVE 16 //[8 16 32 64]
    #define SHADOW_DISTORTION_AMOUNT_INVERSE (SHADOW_DISTANCE_EFFECTIVE * shadowProjection[0].x)
    #define SHADOW_DEPTH_RADIUS 1536.0
    #define SHADOW_DEPTH_SCALE (SHADOW_DEPTH_RADIUS / 128.0)

    float shadowDistortionFactor(in vec2 position) {
        return 1.0 / (SHADOW_DISTORTION_AMOUNT_INVERSE + length(position));
    }

    vec2 shadowDistortion(in vec2 position) {
        return position * shadowDistortionFactor(position);
    }

    vec3 shadowDistortion(in vec3 position) {
        position.xy = position.xy * shadowDistortionFactor(position.xy);
        position.z /= SHADOW_DEPTH_SCALE;
        return position;
    }
#endif