#if !defined HARD_SHADOW_LIB
#define HARD_SHADOW_LIB
    vec3 calculateHardShadows(in vec3 position) {
        position = shadowDistortion(position);
        vec3 shadows = vec3(0.0);
        float shadowDepth = texture(shadowtex0, position.xy * 0.5 + 0.5).r * 2.0 - 1.0;
        shadowDepth = step(position.z - 0.0001, shadowDepth);
        float shadowTranslucent = texture(shadowtex1, position.xy * 0.5 + 0.5).r * 2.0 - 1.0;
        shadowTranslucent = step(position.z - 0.0001, shadowTranslucent);
        vec4 shadowColor = texture(shadowcolor0, position.xy * 0.5 + 0.5);
        shadowColor.rgb = srgbToLinear(shadowColor.rgb);
        shadowColor.rgb = mix(vec3(1.0) * mix(vec3(1.0), shadowColor.rgb, shadowColor.a), shadowColor.rgb, shadowColor.a);

        shadows += mix(vec3(shadowDepth), shadowColor.rgb, float(shadowDepth < shadowTranslucent));

        return shadows;
    }
#endif