uniform int heldBlockLightValue;
uniform int heldBlockLightValue2;

float calculateHandLighting() {
	vec3[2] lightPos = vec3[2](
		vec3(-0.2, 0.1, 0.2) * 0.8,
		vec3( 0.2, 0.1, 0.2) * 0.8
	);

	vec3[2] lightRelativePos = vec3[2](
		-pd.viewPosition[0] - lightPos[0],
		-pd.viewPosition[0] - lightPos[1]
	);

	vec2 lightDistance = vec2(length(lightRelativePos[0]), length(lightRelativePos[1]));

	vec3[2] lightVector = vec3[](
		normalize(lightRelativePos[0]),
		normalize(lightRelativePos[1])
	);

    vec3 hitPosition[2];
    bool hit1 = raytraceIntersection(depthtex0, pd.screenPosition[0], lightVector[0], hitPosition[0], 32u, 16.0, true);
    bool hit2 = raytraceIntersection(depthtex0, pd.screenPosition[0], lightVector[1], hitPosition[1], 32u, 16.0, true);

    if(lightDistance.x > 6.0) hit1 = false;
    if(lightDistance.y > 6.0) hit2 = false;

	vec2 handLight  = vec2(!hit1, !hit2);
		 //handLight *= exp(-lightDistance * 0.8);
		 handLight *= vec2(heldBlockLightValue, heldBlockLightValue2) / 16.0;

	return dot(handLight, vec2(1.0));
}