#if !defined RAYSHAPE_LIB
#define RAYSHAPE_LIB
    vec2 RSI(vec3 pos, vec3 dir, float radius) {
        radius = square(radius);
        float posDotDir = dot(pos, dir);
        float endDist = posDotDir*posDotDir + radius - dot(pos, pos);

        if(endDist < 0.0) return vec2(-1.0);

        endDist = sqrt(endDist);
        vec2 ret = -posDotDir + vec2(-endDist, endDist);

        return ret;
    }

    vec2 RBI(in vec3 boundsMin, in vec3 boundsMax, in vec3 rayOrigin, in vec3 rayDirection) {
        vec3 t0 = (boundsMin - rayOrigin) / rayDirection;
        vec3 t1 = (boundsMin - rayOrigin) / rayDirection;
        vec3 tMin = min(t0, t1);
        vec3 tMax = max(t0, t1);

        float distA = max(max(tMin.x, tMin.y), tMin.z);
        float distB = min(tMax.x, min(tMax.y, tMax.z));

        if(distB < 0.0) return vec2(-1.0);

        float distToBox = max(0.0, distA);
        float distInBox = max(0.0, distB - distToBox);
        return vec2(distToBox, distInBox);
    }
#endif