#if !defined SKY_PROJECTION_LIB
#define SKY_PROJECTION_LIB
    #define SKY_RENDER_LOD 3

    vec2 projectSky(vec3 dir) {
        vec2 lonlat = vec2(atan(-dir.x, -dir.z), acos(dir.y));
        vec2 coord = vec2(lonlat.x / tau + 0.5, lonlat.y / pi);
        return coord * (exp2(-SKY_RENDER_LOD) - viewPixelSize) + viewPixelSize * 0.5;
    }

    vec3 unprojectSky(vec2 coord) {
        coord = (coord - viewPixelSize * 0.5) / (exp2(-SKY_RENDER_LOD) - viewPixelSize);
        coord *= vec2(tau, pi);
        return vec3(sincos(coord.x) * sin(coord.y), cos(coord.y)).xzy;
    }
#endif