//Fragment Output
layout(location = 0) out uvec4 outColor;
layout(location = 1) out uvec4 outData0;
layout(location = 2) out uvec4 outData1;

//Samplers
uniform sampler2D tex;
uniform sampler2D normals;
uniform sampler2D specular;

uniform sampler2D noisetex;

//Uniforms
uniform mat4 gbufferModelViewInverse;

uniform ivec2 atlasSize;

uniform float frameTimeCounter;

uniform int frameCounter, isEyeInWater;

//Fragment Inputs
in mat3 tbn;
in mat2 tileInfo;
in vec3 tint;
in vec3 worldPosition;
in vec3 viewPosition;
in vec3 tangentSpaceViewPosition;
flat in vec3 vertexNormal;
in vec2 textureCoordinate;
in vec2 lightmapCoordinate;
in float ao;
in float id;
in float top;

#include "/lib/universal/universal.glsl"
#include "/lib/fragment/dither/bayer.glsl"
#include "/lib/fragment/dither/hash.glsl"

vec2 textureWrap(in vec2 coord, in mat2 tileInfo) {
    vec2 wrappedCoord = round((tileInfo[1] - coord) / tileInfo[0]) * tileInfo[0] + coord;
    return wrappedCoord;
}

vec2 parallaxMapping(vec2 texCoords, vec3 viewDir, in mat2 tileInfo, in mat2 texD) {
    float numLayers = 16 / (abs(viewDir.z) * length(viewPosition) * 0.2 + 0.2);
    float layerDepth = 1.0 / numLayers;
    float currentLayerDepth = 1.0;
    vec2 pos = viewDir.xy / viewDir.z * (1.0 / 250.0); 
    vec2 deltaTextureCoordinates = pos / numLayers;//inversesqrt(numLayers) * pos / abs(viewDir.y);
    deltaTextureCoordinates.y *= atlasSize.x / atlasSize.y;

    vec2  currentTextureCoordinate = texCoords;
    float currentDepthMapValue = textureGrad(normals, textureWrap(texCoords, tileInfo), texD[0], texD[1]).a;

    for(float i = 0.0; i < numLayers && currentLayerDepth > currentDepthMapValue; ++i) {
        currentTextureCoordinate -= deltaTextureCoordinates;
        currentDepthMapValue = textureGrad(normals, textureWrap(currentTextureCoordinate, tileInfo), texD[0], texD[1]).a; 
        currentLayerDepth -= layerDepth;  
    }

    return textureWrap(currentTextureCoordinate, tileInfo);
}

float getRainPuddles(in vec2 coord) {
    float puddle  = texture(noisetex, fract(coord / 512.0)).r * 3.00;
          puddle += texture(noisetex, fract(coord / 128.0)).r * 4.00;
          puddle += texture(noisetex, fract(coord / 64.0)).r * 6.00;
    return puddle / 2.0;
}

/* DRAWBUFFERS:023 */
void main() {
    mat2 texD = mat2(dFdx(textureCoordinate), dFdy(textureCoordinate));
    vec2 coordinate = textureCoordinate;//parallaxMapping(textureCoordinate, fNormalize(viewPosition * tbn), tileInfo, texD);
    #ifdef ENTITIES
        coordinate = textureCoordinate;
    #endif
    vec4 texSpecular = textureGrad(specular, coordinate, texD[0], texD[1]);
    vec4 texNormal = textureGrad(normals, coordinate, texD[0], texD[1]) * 2.0 - 1.0;
    vec4 texColor = textureGrad(tex, coordinate, texD[0], texD[1]);
    outColor = uvec4(1u, 1u, 1u, 1u);

    float dither = fract(fract(frameCounter * (1.0 / phi)) + bayer128(gl_FragCoord.st)) / 128.0;

    float puddle  = getRainPuddles(worldPosition.xz);
          puddle *= top * (pow(lightmapCoordinate.y, 16.0) * 2.0);
          puddle  = saturate(puddle);
    float puddles = mix(0.0, puddle, wetness);

    vec4 rainData = vec4(0.99, 0.02, 0.0, 0.0);
    if(isEyeInWater < 1) texSpecular = texSpecular.g > 0.9 ? texSpecular : mix(texSpecular, rainData, puddles);

    vec3 viewDirection = fNormalize(-tangentSpaceViewPosition);

    vec3 normals    = vec3(0.0);
         normals.xy = texNormal.xy;
         normals    = vec3(normals.xy, sqrt(saturate(1.0 - dot(normals.xy, normals.xy))));
         //normals    = clampNormal(normals, viewDirection);
         normals    = tbn * normals;
         normals    = mat3(gbufferModelViewInverse) * normals;
         normals    = texSpecular.g > 0.9 ? normals : mix(normals, vertexNormal, puddles);
         #ifdef ENTITIES
            normals = vertexNormal;
         #endif
         normals = fNormalize(normals);

    outData0.r = packUnorm4x8(vec4(texColor.rgb * tint, id / 255.0));
    outData0.g = packSnorm2x16(EncodeUnitVector(normals));
    outData0.b = packSnorm4x8(vec4(lightmapCoordinate + dither, EncodeUnitVector(vertexNormal)));
    outData0.a = packSnorm4x8(vec4(1.0, ao * texNormal.z, puddles, 0.0));

    outData1.r = packUnorm2x16(texSpecular.rg);
    outData1.g = packUnorm2x16(texSpecular.ba);
    outData1.b = 1u;
    outData1.a = 1u;

    if(texColor.a < 0.106) discard;
}