//Fragment Output
layout(location = 0) out vec4 outColor;
layout(location = 1) out uvec4 outData0;
layout(location = 2) out uvec4 outData1;

//Samplers
uniform sampler2D tex;
uniform sampler2D specular;

//Uniforms
uniform int frameCounter;

//Fragment Inputs
in vec3 tint;
in vec3 metalTint;
flat in vec3 vertexNormal;
in vec2 textureCoordinate;
in vec2 lightmapCoordinate;
in float ao;
in float id;

#include "/lib/universal/universal.glsl"
#include "/lib/fragment/dither/bayer.glsl"

/* DRAWBUFFERS:123 */
void main() {
    vec4 texSpecular = texture(specular, textureCoordinate);
    vec4 texColor = texture(tex, textureCoordinate);
    outColor.rgb = texColor.rgb * tint;
    outColor.a = texColor.a;

    float dither = fract(fract(frameCounter * (1.0 / phi)) + bayer128(gl_FragCoord.st)) / 128.0;

    outData0.r = packUnorm4x8(vec4(texColor.rgb * tint, id / 255.0));
    outData0.g = packSnorm2x16(EncodeUnitVector(vertexNormal));
    outData0.b = packSnorm4x8(vec4(lightmapCoordinate, EncodeUnitVector(vertexNormal)));
    outData0.a = packSnorm4x8(vec4(0.2, 1.0, 0.0, 0.0));

    outData1.r = packUnorm2x16(texSpecular.rg);
    outData1.g = packUnorm2x16(texSpecular.ba);
    outData1.b = 1u;
    outData1.a = 1u;

    if(!bool(texColor.a)) discard;
}