//Fragment Output
layout(location = 0) out vec4 inverseDFT;

//Samplers
uniform sampler2D colortex7;

//Uniforms
uniform vec2 viewSize, viewPixelSize;

uniform float frameTimeCounter;

//Fragment Inputs
in vec2 textureCoordinate;

#include "/lib/universal/universal.glsl"

#include "/lib/shared/surface/water/constants.glsl"
#include "/lib/fragment/fft.glsl"

/* DRAWBUFFERS:7 */
void main() {
    if(gl_FragCoord.x > SIZE || gl_FragCoord.y > SIZE) {
        discard;
    }

    for(float n = 0.0; n < SIZE; n++) {
        float m = W(n);
        complexFloat horizontalSum = complexFloat(texelFetch(colortex7, ivec2(m+0.5, gl_FragCoord.y), 0).x, texelFetch(colortex7, ivec2(m+0.5, gl_FragCoord.y), 0).y);
        float a = tau * (gl_FragCoord.x-0.5) * n/SIZE;

        inverseDFT.xy += complexToVector(complexMul(horizontalSum, complexExp(complexFloat(0.0, a))));
    }
    inverseDFT.zw = texelFetch(colortex7, ivec2(gl_FragCoord.st+1.0), 0).zw;
}