//Fragment Output
layout(location = 0) out vec4 fourierCoefficients;

//Samplers
uniform sampler2D colortex7;

//Uniforms
uniform vec2 viewSize, viewPixelSize;

uniform float frameTimeCounter;

//Fragment Inputs
in vec2 textureCoordinate;

#include "/lib/universal/universal.glsl"

#include "/lib/shared/surface/water/constants.glsl"

/* DRAWBUFFERS:7 */
void main() {
    if(gl_FragCoord.x > SIZE || gl_FragCoord.y > SIZE) {
        discard;
    }

    vec4 h0 = texelFetch(colortex7, ivec2(gl_FragCoord.xy+1.0), 0);
    complexFloat h0_k = complexFloat(h0.x, h0.y);
    complexFloat h0_minus_k = complexFloat(h0.z, h0.w);

    vec2 k = tau * ((gl_FragCoord.xy-1.5) - SIZE/2.0) / SIDELENGTH;

    float dispersion = sqrt(g * length(k)) * frameTimeCounter;

    complexFloat hkt = complexAdd(complexMul(h0_k, complexExp(complexFloat(0.0, dispersion))), complexConjugate(complexMul(h0_minus_k, complexExp(complexFloat(0.0, -dispersion)))));

    fourierCoefficients.rg = complexToVector(hkt);
    fourierCoefficients.zw = complexToVector(hkt);
}