//Fragment Output
layout(location = 0) out vec3 outSky;

//Samplers
uniform sampler2D colortex0;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D depthtex0;

uniform sampler2D noisetex;

uniform sampler2D shadowtex0;
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor0;

//Sky Textures
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;

//Uniforms
uniform mat4 gbufferProjection, gbufferModelView;
uniform mat4 gbufferProjectionInverse, gbufferModelViewInverse;

uniform mat4 shadowProjection, shadowModelView;
uniform mat4 shadowProjectionInverse, shadowModelViewInverse;

uniform vec3 sunVector, moonVector, shadowLightVector, upVector;
uniform vec3 sunVectorView, moonVectorView, shadowLightVectorView;
uniform vec3 cameraPosition;

uniform vec2 viewSize, viewPixelSize;

uniform float eyeAltitude, frameTimeCounter;

uniform int frameCounter;

//Fragment Inputs
in vec2 textureCoordinate;

const bool colortex0Clear = false;
const bool colortex1Clear = false;
const bool colortex2Clear = false;
const bool colortex3Clear = false;
const bool colortex4Clear = false;
const bool colortex5Clear = false;
const bool colortex6Clear = false;
const bool colortex7Clear = false;

#include "/lib/universal/universal.glsl"

#include "/lib/shared/sky/celestial/constants.glsl"

#include "/lib/shared/sky/constants.glsl"
#include "/lib/shared/sky/phase.glsl"
#include "/lib/shared/sky/atmosphere/lookup.glsl"
#include "/lib/shared/sky/atmosphere/scattering.glsl"
#include "/lib/shared/sky/atmosphere/transmittance.glsl"
#include "/lib/shared/sky/projection.glsl"

/* DRAWBUFFERS:5 */
void main() {
    if(textureCoordinate.x > exp2(-SKY_RENDER_LOD) || textureCoordinate.y > exp2(-SKY_RENDER_LOD)) discard;

    outSky = atmosphericScattering(vec3(0.0, planetRadius, 0.0), unprojectSky(textureCoordinate));
}