#version 450 compatibility

//Vertex Inputs/Attributes
vec4 inPosition = gl_Vertex;
vec3 inNormal = gl_Normal;
vec4 inColor = gl_Color;
vec2 inTexCoord = gl_MultiTexCoord0.st;
vec2 inLmCoord = gl_MultiTexCoord1.st;

attribute vec4 mc_Entity;
attribute vec4 at_tangent;
attribute vec2 mc_midTexCoord;

//Uniforms
uniform mat4 gbufferModelViewInverse;

uniform vec3 cameraPosition;

//Vertex Outputs
flat out vec3 tint;
out vec2 lightmapping;

#include "/lib/universal/universal.glsl"

//Functions
vec4 projectVertex(vec3 position) {
	return vec4(gl_ProjectionMatrix[0].x, gl_ProjectionMatrix[1].y, gl_ProjectionMatrix[2].zw) * position.xyzz + gl_ProjectionMatrix[3] + vec4(gl_ProjectionMatrix[2].xy * position.z, 0.0, 0.0);
}

//Main function
void main() {
    tint = inColor.rgb;

    lightmapping = inLmCoord.st/255.0;
    lightmapping = square(lightmapping);

    gl_Position.xyz = mat3(gl_ModelViewMatrix) * inPosition.xyz + gl_ModelViewMatrix[3].xyz;
    gl_Position = projectVertex(gl_Position.xyz);
    gl_Position.xy += taaOffset * gl_Position.w;
}