#version 450 compatibility

//Vertex Inputs/Attributes
vec4 inPosition = gl_Vertex;
vec3 inNormal = gl_Normal;
vec4 inColor = gl_Color;
vec2 inTexCoord = gl_MultiTexCoord0.st;
vec2 inLmCoord = gl_MultiTexCoord1.st;

attribute vec4 mc_Entity;

//Uniforms
uniform mat4 shadowProjection;

//Vertex Outputs
out vec3 tint;
out vec3 vertexNormal;
out vec2 textureCoordinate;
out float id;

#include "/lib/universal/universal.glsl"

#include "/lib/fragment/lighting/direct/distortion.glsl"

//Functions
vec4 projectVertex(vec3 position) {
	return vec4(gl_ProjectionMatrix[0].x, gl_ProjectionMatrix[1].y, gl_ProjectionMatrix[2].zw) * position.xyzz + gl_ProjectionMatrix[3] + vec4(gl_ProjectionMatrix[2].xy * position.z, 0.0, 0.0);
}

//Main function
void main() {
    tint = inColor.rgb;

    textureCoordinate = inTexCoord;

    id = mc_Entity.x;

    #ifdef SHADOW_BACKFACE_CULL
        if((gl_NormalMatrix * inNormal).z < 0.0) {
            gl_Position = vec4(-1.0);
            return;
        }
    #endif

    gl_Position.xyz = mat3(gl_ModelViewMatrix) * inPosition.xyz + gl_ModelViewMatrix[3].xyz;
    gl_Position = projectVertex(gl_Position.xyz);
    gl_Position.xyz = shadowDistortion(gl_Position.xyz);
}