//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

//Settings//
#include "/lib/settings.glsl"

//Varyings//
varying vec2 texCoord;
varying vec3 sunVec, upVec, eastVec;
varying vec3 normal;
varying mat3 moonRotMatrix;

#define DEFERRED1

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Uniforms//
uniform sampler2D noisetex;

uniform int frameCounter;
uniform int isEyeInWater;

uniform float blindFactor, nightVision;
uniform float far, near;
uniform float frameTimeCounter;
uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float shadowFade;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight, aspectRatio;
uniform float eyeAltitude;
uniform int worldTime;
uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;

uniform mat4 gbufferProjection, gbufferPreviousProjection, gbufferProjectionInverse;
uniform mat4 gbufferModelView, gbufferPreviousModelView, gbufferModelViewInverse;

uniform vec3 moonPosition;
uniform vec3 skyColor;
uniform vec3 fogColor;

uniform sampler2D colortex0;
uniform sampler2D colortex3;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

#ifdef AO
uniform sampler2D colortex4;
#endif

#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
uniform vec3 previousCameraPosition;

uniform sampler2D colortex5;
uniform sampler2D colortex6;
uniform sampler2D colortex7;
#endif

//Optifine Constants//
#ifdef AO
const bool colortex4MipmapEnabled = true;
#endif

#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
const bool colortex0MipmapEnabled = true;
const bool colortex5MipmapEnabled = true;
const bool colortex6MipmapEnabled = true;
#endif

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float moonVisibility = clamp(dot( -sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float screenBrightness2 = clamp(screenBrightness, 0.0, 1.0);

vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);

vec2 aoOffsets[4] = vec2[4](
	vec2( 1.0,  0.0),
	vec2( 0.0,  1.0),
	vec2(-1.0,  0.0),
	vec2( 0.0, -1.0)
);

vec2 glowOffsets[16] = vec2[16](
	vec2( 0.0, -1.0),
	vec2(-1.0,  0.0),
	vec2( 1.0,  0.0),
	vec2( 0.0,  1.0),
	vec2(-1.0, -2.0),
	vec2( 0.0, -2.0),
	vec2( 1.0, -2.0),
	vec2(-2.0, -1.0),
	vec2( 2.0, -1.0),
	vec2(-2.0,  0.0),
	vec2( 2.0,  0.0),
	vec2(-2.0,  1.0),
	vec2( 2.0,  1.0),
	vec2(-1.0,  2.0),
	vec2( 0.0,  2.0),
	vec2( 1.0,  2.0)
);

//Common Functions//
float GetLuminance(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float GetLinearDepth(float depth) {
	return (2.0 * near) / (far + near - depth * (far - near));
}

float InterleavedGradientNoise(){
	float n = 52.9829189 * fract(0.06711056 * gl_FragCoord.x + 0.00583715 * gl_FragCoord.y);
	return fract(n + frameCounter / 8.0);
}

void GlowOutline(inout vec3 color){
	for(int i = 0; i < 16; i++){
		vec2 glowOffset = glowOffsets[i] / vec2(viewWidth, viewHeight);
		float glowSample = texture2D(colortex3, texCoord.xy + glowOffset).b;
		if(glowSample < 0.5){
			if(i < 4) color.rgb = vec3(0.0);
			else color.rgb = vec3(0.5);
			break;
		}
	}
}

#ifdef AO
float GetAmbientOcclusion(float z) {
	float ao = 0.0;
	float tw = 0.0;
	float lz = GetLinearDepth(z);
	
	#if AO_QUALITY == 1 && AA > 1
	vec2 halfView = vec2(viewWidth, viewHeight) / 2.0;
	vec2 coord1 = (floor(texCoord * halfView + 1.0)) / halfView;
	vec2 coord2 = texCoord * 0.5;
	#else
	vec2 coord1 = texCoord;
	vec2 coord2 = texCoord;
	#endif
	
	
	for(int i = 0; i < 4; i++) {
		vec2 offset = aoOffsets[i] / vec2(viewWidth, viewHeight);
		float samplez = GetLinearDepth(texture2D(depthtex0, coord1 + offset * 2.0).r);
		float wg = max(1.0 - 2.0 * far * abs(lz - samplez), 0.0);
		ao += texture2D(colortex4, texCoord + offset).r * wg;
		tw += wg;
	}
	ao /= tw;
	if(tw < 0.0001) ao = texture2D(colortex4, coord2).r;
	
	float aoStrength = AO_STRENGTH;
	
	#if AO_QUALITY == 2 || (AO_QUALITY == 1 && AA <= 1)
	aoStrength *= 0.75;
	#endif
	
	return pow(ao, aoStrength);
}
#endif

//Includes//
#include "/lib/color/dimensionColor.glsl"
#include "/lib/color/skyColor.glsl"
#include "/lib/color/blocklightColor.glsl"
#include "/lib/color/waterColor.glsl"
#include "/lib/util/dither.glsl"

#ifdef OVERWORLD
#include "/lib/atmospherics/sky.glsl"
#endif

#include "/lib/atmospherics/fog.glsl"
#include "/lib/outline/outlineOffset.glsl"
#include "/lib/atmospherics/waterFog.glsl"

#ifdef FULL_BORDER
#include "/lib/outline/fullBorder.glsl"
#endif

#ifdef BLACK_OUTLINE
#include "/lib/outline/blackOutline.glsl"
#endif

#ifdef PROMO_OUTLINE
#include "/lib/outline/promoOutline.glsl"
#endif

#if AURORA_COLOR == 5
#include "/lib/color/hue.glsl"
#endif

#ifdef AURORA
#include "/lib/atmospherics/aurora.glsl"
#endif

#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
#include "/lib/util/encode.glsl"
#include "/lib/reflections/raytrace.glsl"
#include "/lib/reflections/complexFresnel.glsl"
#include "/lib/surface/materialDeferred.glsl"
#include "/lib/reflections/roughReflections.glsl"
#endif

#ifdef OVERWORLD
#ifdef CLOUDS
#include "/lib/atmospherics/ovclouds.glsl"
#endif
#endif

//Program//
void main() {
	vec4 color      = texture2D(colortex0, texCoord);
	float z         = texture2D(depthtex0, texCoord).r;
	float isGlowing = texture2D(colortex3, texCoord).b;
	float dither = Bayer64(gl_FragCoord.xy);

	vec4 screenPos = vec4(texCoord, z, 1.0);
	vec4 viewPos = gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
	viewPos /= viewPos.w;
	
	
	if (z < 1.0) {

		float lViewPos = length(viewPos.xyz);

		#ifdef UNDERWATER_SKY_OPACITY
		vec3 nViewPos = normalize(viewPos.xyz);
		float NoUS = dot(nViewPos, upVec);
		#endif
		
		#ifdef AO
		float ao = clamp(GetAmbientOcclusion(z), 0.0, 1.0);
		float ambientOcclusion = ao;
		#endif

		#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
		float smoothness = 0.0, skyOcclusion = 0.0;
		vec3 normal = vec3(0.0), fresnel3 = vec3(0.0);
		GetMaterials(smoothness, skyOcclusion, normal, fresnel3, texCoord);
		smoothness *= smoothness;

	if (smoothness > 0.0) {
			vec4 reflection = vec4(0.0);
			vec3 skyReflection = vec3(0.0);

			float ssrMask = clamp(length(fresnel3) * 400.0 - 1.0, 0.0, 1.0);
			if(ssrMask > 0.0) reflection = RoughReflection(viewPos.xyz, normal, dither, smoothness);
			reflection.a *= ssrMask;
			
			if (reflection.a < 1.0) {
				#ifdef OVERWORLD
				vec3 skyRefPos = reflect(normalize(viewPos.xyz), normal);
				skyReflection = GetSkyColor(skyRefPos, true);

				#ifdef REFLECTION_ROUGH
				float cloudMixRate = smoothness * smoothness * (3.0 - 2.0 * smoothness);
				#else
				float cloudMixRate = 1.0;
				#endif
				
				#ifdef METAL_AURORA_REFLECTION
				#ifdef AURORA
				skyReflection += DrawAurora(skyRefPos * 100.0, dither, 12) * cloudMixRate;
				#endif
				#endif
				
				#ifdef METAL_CLOUDS_REFLECTION
				#ifdef CLOUDS
				vec4 cloud = DrawCloud(skyRefPos * 100.0, dither, lightCol, ambientCol);
				skyReflection = mix(skyReflection, cloud.rgb, cloud.a * cloudMixRate);
				#endif
				#endif
				
				float NoU = clamp(dot(normal, upVec), -1.0, 1.0);
				float NoE = clamp(dot(normal, eastVec), -1.0, 1.0);
				float vanillaDiffuse =  (0.25 * NoU + 0.75) + 
										(0.5 - abs(NoE)) * (1.0 - abs(NoU)) * 0.1;
				vanillaDiffuse *= vanillaDiffuse;
				
				skyReflection = mix(
					vanillaDiffuse * vec3(0.001),
					skyReflection * (4.0 - 3.0 * eBS),
					skyOcclusion
				);
				#endif

				#ifdef NETHER
				skyReflection = netherCol.rgb * 0.04;
				#endif

				#ifdef END
				skyReflection = endCol.rgb * 0.025;
				#endif
			}
			
			reflection.rgb = max(mix(skyReflection, reflection.rgb, reflection.a), vec3(0.0));
			
			color.rgb += reflection.rgb * (fresnel3 * FRESNEL_REFLECTION_STRENGHT);
		}

		#endif
		
		#ifdef AO
		color.rgb *= ambientOcclusion;
		#endif

		#ifdef PROMO_OUTLINE
		PromoOutline(color.rgb, depthtex0);
		#endif
		
		#ifdef FULL_BORDER
		color.rgb = fullborder(color.rgb);
		#endif
		
		Fog(color.rgb, viewPos.xyz);

	}else{
		#ifdef NETHER
		color.rgb = netherCol.rgb * 0.04;
		#endif
		#if defined END && !defined LIGHT_SHAFT
		color.rgb+= endCol.rgb * 0.025;
		#endif
		
		
		#ifdef UNDERWATER_SKY_OPACITY
			if (isEyeInWater == 1) {
				float NoUS = 0.0;
				NoUS = max(dot(normalize(viewPos.xyz), upVec), 0.0);
				color.rgb = mix(color.rgb, 0.8 * pow(rawWaterColor.rgb * (1.0 - blindFactor), vec3(2.0)), 1 - NoUS * NoUS);
			}
		#endif

		if (isEyeInWater == 2){
			#ifdef EMISSIVE_RECOLOR
			color.rgb = pow(blocklightCol / BLOCKLIGHT_I, vec3(4.0)) * 2.0;
			#else
			color.rgb = vec3(1.0, 0.3, 0.01);
			#endif
		}
		
		if (blindFactor > 0.0) color.rgb *= 1.0 - blindFactor;
	}
	
	#ifdef BLACK_OUTLINE
	float wFogMult = 1.0 + eBS;
	BlackOutline(color.rgb, depthtex0, depthtex1, wFogMult);
	#endif
	
	
	if (isGlowing > 0.5) GlowOutline(color.rgb);
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0] = color;
	#ifndef REFLECTION_PREVIOUS
	/*DRAWBUFFERS:05*/
	gl_FragData[1]=vec4(pow(color.rgb,vec3(.125))*.5,float(z<1.));
	#endif
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Uniforms//
uniform float timeAngle;
uniform mat4 gbufferModelView;

#include "/lib/util/moonrot.glsl"

//Program//
void main(){
	texCoord=gl_MultiTexCoord0.xy;

	gl_Position=ftransform();
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	vec3 usunvec = vec3(-sin(ang),cos(ang)*sunRotationData);
	sunVec=normalize((gbufferModelView*vec4(usunvec*2000.,1.)).xyz);
	
    moonRotMatrix = getMoonRotMatrix(usunvec);

	upVec=normalize(gbufferModelView[1].xyz);
	eastVec=normalize(gbufferModelView[0].xyz);
}

#endif
