/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _EXIT_
#define _EXIT_

/**************************************************************************

INCLUDE INSTRUCTIONS:
This file depends on Debug.glsl and must be included after Debug.glsl.
See Debug.glsl for its own include instructions.

Exit.glsl only needs to be included in the fragment shader. But you must
follow these instructions:
- include AFTER the layout qualifier and the DRAWBUFFERS comment
- Make sure you #define LAYOUT_0 so that exit() can write to layout 0



This file dynamically changes which buffer the fragment writes to. It does
this so that the program we're trying to show() can route itself to
colortex0 (which is an RGB8+ buffer suitable to get the show() data to
final.fsh). It also re-routes any subsequent programs so that they
don't overwrite our show() information (In this case it routes subsequent
programs to colortex4, however this is arbitrary).

If you have multiple DRAWBUFFERS comments in a single file, the last one
is the one that is recognized. DRAWBUFFERS comments are not recognized if
they're inside an inactive #ifdef, so we can use this mechanism to force a
shader to write to colortex0 based on our DEBUG_VIEW.

**************************************************************************/

#if defined DEBUG && defined Shadow_glsl

	// Don't need to re-route anything in shadow.

#elif defined DEBUG && (!defined final)
	
	#if DynamicShaderStage == DEBUG_VIEW
		/* DRAWBUFFERS:7 */
	#elif DynamicShaderStage > DEBUG_VIEW
		// Redirect, get the stage out of the way
		/* DRAWBUFFERS:4 */
	#endif
	
#elif defined DEBUG && defined final
	
	#if DEBUG_VIEW == Shadow_glsl
	// Declare this sampler in final.fsh if we're showing the shadow map.
	uniform sampler2D shadowcolor0;
	#elif DEBUG_VIEW < 50
	// Declare this sampler in final.fsh if we're showing a previous program.
	uniform sampler2D colortex7;
	#endif
	
#endif

void exit() {
#ifdef DEBUG
	
	#ifdef Shadow_glsl
		#define LAYOUT_0 gl_FragData[0]
	#endif
	
	#if !defined final
		#if (DEBUG_VIEW < DynamicShaderStage)
			discard;
		#elif (DEBUG_VIEW == DynamicShaderStage)
			LAYOUT_0 = vec4(Debug, 1.0);
		#endif
	#else
		#if DEBUG_VIEW == Shadow_glsl
			LAYOUT_0 = vec4(texture2D(shadowcolor0, texcoord).rgb, 1.0);
		#elif DEBUG_VIEW == Final_glsl
			LAYOUT_0 = vec4(Debug, 1.0);
		#else
			LAYOUT_0 = vec4(texture2D(colortex7, texcoord).rgb , 1.0);
		#endif
	#endif
#endif
}


#endif
