/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _SYNTAX_
#define _SYNTAX_

// This file will contain any custom syntax rules like io for in out.

#if defined vsh
    #define varying out
#elif defined fsh
    #define varying in
#endif

// Constants
const float PI = radians(180.0);
const float TAU = radians(360.0);
const float HPI = PI * 0.5;
const float rPI = 1.0 / PI;
const float rTAU = 1.0 / TAU;
const float PHI = sqrt(5.0) * 0.5 + 0.5;

const float goldenAngle = TAU / PHI / PHI;

const float LOG2 = log(2.0);
const float rLOG2 = 1.0 / LOG2;

const float LOG10  = log(10.0);
const float rLOG10 = 1.0 / LOG10;

#include "../UserLib/SettingsManager.glsl"

#endif
