/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _TEMPORALJITTER_
#define _TEMPORALJITTER_

vec2 TemporalJitter() {
	#ifndef TAA
		return vec2(0.0);
	#endif

	const vec2 SAMPLE_LOCS_16[16] = vec2[16](
		vec2(  0,  -3) / 16.0,
		vec2( -8,  11) / 16.0,
		vec2(  2,   1) / 16.0,
		vec2(-10,  -9) / 16.0,
		vec2( 12, -15) / 16.0,
		vec2( -4,   7) / 16.0,
		vec2( 14,  13) / 16.0,
		vec2( -6,  -5) / 16.0,
		vec2( -3,   0) / 16.0,
		vec2( 11,  -8) / 16.0,
		vec2( -1,  -2) / 16.0,
		vec2(  9,  10) / 16.0,
		vec2(-15,  12) / 16.0,
		vec2(  7,  -4) / 16.0,
		vec2(-13, -14) / 16.0,
		vec2(  5,   6) / 16.0
	);

	return ( (SAMPLE_LOCS_16[int(frameCounter % 16)]) * pixelSize );
}

#endif
