/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _NOISE_
    #define _NOISE_

    //Hashes
    vec3 hash33(vec3 p) {
        p = fract(p * vec3(443.8975, 397.2973, 491.1871));
        p += dot(p.zxy, p.yxz + 19.27);
        return fract(vec3(p.x * p.y, p.z * p.x, p.y * p.z));
    }

    float hash13(vec3 p3) {
        p3  = fract(p3 * 443.8975);
        p3 += dot(p3, p3.yzx + 19.19);
        return fract((p3.x + p3.y) * p3.z);
    }

    float hash12(vec2 p) {
        p  = fract(p * vec2(5.3983, 5.4427));
        p += dot(p.yx, p.xy + vec2(21.5351, 14.3137));
        return fract(p.x * p.y * 95.4337);
    }

    //Circular Distrobution
    vec2 sincos(float x) {
        return vec2(sin(x), cos(x));
    }

    vec2 circlemap(float i, float n){
        return sincos(i * n * goldenAngle) * sqrt(i);
    }

    // Circlemap but with a squared distribution
    vec2 circlemapSq(float i, float n){
        return sincos(i * n * goldenAngle) * i;
    }

    vec3 circlemapL(float i, float n){
        return vec3(sincos(i * n * goldenAngle), sqrt(i));
    }

    //Odered Bayar Dithers

    float bayer2(vec2 a) {
        a = floor(a);

        return fract(dot(a, vec2(0.5, a.y * 0.75)));
    }

    float bayer4(const vec2 a)   { return bayer2 (0.5   * a) * 0.25     + bayer2(a); }
    float bayer8(const vec2 a)   { return bayer4 (0.5   * a) * 0.25     + bayer2(a); }
    float bayer16(const vec2 a)  { return bayer4 (0.25  * a) * 0.0625   + bayer4(a); }
    float bayer32(const vec2 a)  { return bayer8 (0.25  * a) * 0.0625   + bayer4(a); }
    float bayer64(const vec2 a)  { return bayer8 (0.125 * a) * 0.015625 + bayer8(a); }
    float bayer128(const vec2 a) { return bayer16(0.125 * a) * 0.015625 + bayer8(a); }

    #define dither2(p)   (bayer2(  p) - 0.375      )
    #define dither4(p)   (bayer4(  p) - 0.46875    )
    #define dither8(p)   (bayer8(  p) - 0.4921875  )
    #define dither16(p)  (bayer16( p) - 0.498046875)
    #define dither32(p)  (bayer32( p) - 0.499511719)
    #define dither64(p)  (bayer64( p) - 0.49987793 )
    #define dither128(p) (bayer128(p) - 0.499969482)

#endif
