/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#include "/../ContinuumLib/Syntax.glsl"

#define DynamicShaderStage ShaderStage


varying vec2 texcoord;


/***********************************************************************/
#if defined vsh


void main() {
    texcoord = gl_Vertex.xy;

    gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
}
#endif
/***********************************************************************/



/***********************************************************************/
#if defined fsh

#include "/../ContinuumLib/Debug.glsl"

uniform sampler2D colortex2;

/* DRAWBUFFERS:2 */
layout(location = 0) out vec4 Buffer2;
#define LAYOUT_0 Buffer2
#include "/../ContinuumLib/Exit.glsl"

void main() {
    Buffer2 = texture(colortex2, texcoord); // Copy A to B
    
    if (Buffer2.r + Buffer2.g + Buffer2.b + Buffer2.a <= 0.0)
        discard;
    
    exit();
}

#endif
/***********************************************************************/
