/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.momirealms.customfishing.api.CustomFishingAPI;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractSubCommand {
    private final String command;
    private Map<String, AbstractSubCommand> subCommandMap;

    public AbstractSubCommand(String command) {
        this.command = command;
    }

    public boolean onCommand(CommandSender sender, List<String> args) {
        if (this.subCommandMap == null || args.size() < 1) {
            return true;
        }
        AbstractSubCommand subCommand = this.subCommandMap.get(args.get(0));
        if (subCommand == null) {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.unavailableArgs);
        } else {
            subCommand.onCommand(sender, args.subList(1, args.size()));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, List<String> args) {
        if (this.subCommandMap == null) {
            return Collections.singletonList("");
        }
        if (args.size() <= 1) {
            ArrayList<String> returnList = new ArrayList<String>(this.subCommandMap.keySet());
            returnList.removeIf(str -> !str.startsWith((String)args.get(0)));
            return returnList;
        }
        AbstractSubCommand subCmd = this.subCommandMap.get(args.get(0));
        if (subCmd != null) {
            return this.subCommandMap.get(args.get(0)).onTabComplete(sender, args.subList(1, args.size()));
        }
        return Collections.singletonList("");
    }

    public String getSubCommand() {
        return this.command;
    }

    public Map<String, AbstractSubCommand> getSubCommands() {
        return Collections.unmodifiableMap(this.subCommandMap);
    }

    public void regSubCommand(AbstractSubCommand command) {
        if (this.subCommandMap == null) {
            this.subCommandMap = new ConcurrentHashMap<String, AbstractSubCommand>();
        }
        this.subCommandMap.put(command.getSubCommand(), command);
    }

    protected boolean noConsoleExecute(CommandSender commandSender) {
        if (!(commandSender instanceof Player)) {
            AdventureUtils.consoleMessage(MessageManager.prefix + MessageManager.noConsole);
            return true;
        }
        return false;
    }

    protected boolean itemNotExist(CommandSender commandSender, String type, String key) {
        if (!CustomFishingAPI.doesItemExist(type, key)) {
            AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.itemNotExist);
            return true;
        }
        return false;
    }

    protected boolean playerNotOnline(CommandSender commandSender, String player) {
        if (Bukkit.getPlayer((String)player) == null) {
            AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.notOnline.replace("{Player}", player));
            return true;
        }
        return false;
    }

    protected boolean lackArgs(CommandSender commandSender, int required, int current) {
        if (required > current) {
            AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.lackArgs);
            return true;
        }
        return false;
    }

    protected void giveItemMsg(CommandSender sender, String name, String item, int amount) {
        AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.giveItem.replace("{Amount}", String.valueOf(amount)).replace("{Player}", name).replace("{Item}", item));
    }

    protected void getItemMsg(CommandSender sender, String item, int amount) {
        AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.getItem.replace("{Amount}", String.valueOf(amount)).replace("{Item}", item));
    }

    protected List<String> online_players() {
        ArrayList<String> online = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> online.add(player.getName()));
        return online;
    }

    protected List<String> filterStartingWith(List<String> list, String prefix) {
        return list.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
    }
}

