/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.commands;

import java.util.List;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.commands.AbstractMainCommand;
import net.momirealms.customfishing.commands.AbstractSubCommand;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FishingBagCommand
extends AbstractMainCommand {
    public FishingBagCommand() {
        this.regSubCommand(OpenCommand.INSTANCE);
    }

    public static class OpenCommand
    extends AbstractSubCommand {
        public static final OpenCommand INSTANCE = new OpenCommand();

        private OpenCommand() {
            super("open");
        }

        @Override
        public boolean onCommand(CommandSender sender, List<String> args) {
            if (super.noConsoleExecute(sender)) {
                return true;
            }
            Player player = (Player)sender;
            if (args.size() == 0) {
                if (!sender.hasPermission("fishingbag.open")) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.noPerm);
                    return true;
                }
                player.closeInventory();
                CustomFishing.getInstance().getBagDataManager().openFishingBag(player, (OfflinePlayer)player, false);
            }
            if (args.size() >= 1) {
                if (!sender.hasPermission("customfishing.admin")) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.noPerm);
                    return true;
                }
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayerIfCached((String)args.get(0));
                if (offlinePlayer == null) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.playerNotExist);
                    return true;
                }
                player.closeInventory();
                CustomFishing.getInstance().getBagDataManager().openFishingBag(player, offlinePlayer, args.size() >= 2 && args.get(1).equals("--force"));
            }
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, List<String> args) {
            if (ConfigManager.enableFishingBag && sender.hasPermission("customfishing.admin") && args.size() == 1) {
                return this.filterStartingWith(this.online_players(), args.get(0));
            }
            return null;
        }
    }
}

