/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.commands.subcmd;

import java.util.ArrayList;
import java.util.List;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.commands.AbstractSubCommand;
import net.momirealms.customfishing.fishing.competition.CompetitionSchedule;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.command.CommandSender;

public class CompetitionCommand
extends AbstractSubCommand {
    public static final CompetitionCommand INSTANCE = new CompetitionCommand();

    public CompetitionCommand() {
        super("competition");
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        if (!ConfigManager.enableCompetition || super.lackArgs(sender, 1, args.size())) {
            return true;
        }
        switch (args.get(0)) {
            case "start": {
                if (args.size() < 2) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.lackArgs);
                    return true;
                }
                if (CompetitionSchedule.startCompetition(args.get(1))) {
                    AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.forceSuccess);
                    break;
                }
                AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.forceFailure);
                break;
            }
            case "end": {
                CompetitionSchedule.endCompetition();
                AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.forceEnd);
                break;
            }
            case "cancel": {
                CompetitionSchedule.cancelCompetition();
                AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.forceCancel);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, List<String> args) {
        ArrayList<String> completions;
        block3: {
            block2: {
                completions = new ArrayList<String>();
                if (args.size() != 1) break block2;
                for (String cmd : List.of("start", "end", "cancel")) {
                    if (!cmd.startsWith(args.get(0))) continue;
                    completions.add(cmd);
                }
                break block3;
            }
            if (args.size() != 2 || !args.get(0).equals("start")) break block3;
            for (String cmd : this.competitions()) {
                if (!cmd.startsWith(args.get(1))) continue;
                completions.add(cmd);
            }
        }
        return completions.isEmpty() ? null : completions;
    }

    private List<String> competitions() {
        return new ArrayList<String>(CustomFishing.getInstance().getCompetitionManager().getCompetitionsC().keySet());
    }
}

