/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.data.storage;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.data.PlayerSellData;
import net.momirealms.customfishing.data.PlayerStatisticsData;
import net.momirealms.customfishing.data.storage.DataStorageInterface;
import net.momirealms.customfishing.data.storage.StorageType;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.util.ConfigUtils;
import net.momirealms.customfishing.util.InventoryUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class FileStorageImpl
implements DataStorageInterface {
    private final CustomFishing plugin;

    public FileStorageImpl(CustomFishing plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void disable() {
    }

    @Override
    public Inventory loadBagData(UUID uuid, boolean force) {
        YamlConfiguration config = ConfigUtils.readData(new File(this.plugin.getDataFolder(), "fishingbag_data" + File.separator + uuid + ".yml"));
        String contents = config.getString("contents");
        int size = config.getInt("size", 9);
        ItemStack[] itemStacks = InventoryUtils.getInventoryItems(contents);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        Inventory inventory = InventoryUtils.createInventory(null, size, this.plugin.getIntegrationManager().getPlaceholderManager().parse(offlinePlayer, ConfigManager.fishingBagTitle));
        if (itemStacks != null) {
            inventory.setContents(itemStacks);
        }
        return inventory;
    }

    @Override
    public void saveBagData(UUID uuid, Inventory inventory, boolean unlock) {
        YamlConfiguration data = new YamlConfiguration();
        String contents = InventoryUtils.toBase64(inventory.getContents());
        data.set("contents", (Object)contents);
        data.set("size", (Object)inventory.getSize());
        try {
            data.save(new File(this.plugin.getDataFolder(), "fishingbag_data" + File.separator + uuid + ".yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveBagData(Set<Map.Entry<UUID, Inventory>> set, boolean unlock) {
        for (Map.Entry<UUID, Inventory> entry : set) {
            this.saveBagData(entry.getKey(), entry.getValue(), unlock);
        }
    }

    @Override
    public PlayerSellData loadSellData(UUID uuid, boolean force) {
        YamlConfiguration data = ConfigUtils.readData(new File(this.plugin.getDataFolder(), "sell_data" + File.separator + uuid + ".yml"));
        int date = data.getInt("date");
        double money = data.getDouble("earnings");
        return new PlayerSellData(money, date);
    }

    @Override
    public void saveSellData(UUID uuid, PlayerSellData playerSellData, boolean unlock) {
        YamlConfiguration data = new YamlConfiguration();
        data.set("date", (Object)playerSellData.getDate());
        data.set("earnings", (Object)playerSellData.getMoney());
        try {
            data.save(new File(this.plugin.getDataFolder(), "sell_data" + File.separator + uuid + ".yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveSellData(Set<Map.Entry<UUID, PlayerSellData>> set, boolean unlock) {
        for (Map.Entry<UUID, PlayerSellData> entry : set) {
            this.saveSellData(entry.getKey(), entry.getValue(), unlock);
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.YAML;
    }

    @Override
    public void saveStatistics(UUID uuid, PlayerStatisticsData statisticsData, boolean unlock) {
        YamlConfiguration data = new YamlConfiguration();
        for (Map.Entry<String, Integer> entry : statisticsData.getAmountMap().entrySet()) {
            data.set(entry.getKey(), (Object)entry.getValue());
        }
        try {
            data.save(new File(this.plugin.getDataFolder(), "statistics_data" + File.separator + uuid + ".yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveStatistics(Set<Map.Entry<UUID, PlayerStatisticsData>> set, boolean unlock) {
        for (Map.Entry<UUID, PlayerStatisticsData> entry : set) {
            this.saveStatistics(entry.getKey(), entry.getValue(), unlock);
        }
    }

    @Override
    public PlayerStatisticsData loadStatistics(UUID uuid, boolean force) {
        YamlConfiguration data = ConfigUtils.readData(new File(this.plugin.getDataFolder(), "statistics_data" + File.separator + uuid + ".yml"));
        return new PlayerStatisticsData((ConfigurationSection)data);
    }
}

