/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.data.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.data.PlayerSellData;
import net.momirealms.customfishing.data.PlayerStatisticsData;
import net.momirealms.customfishing.data.storage.DataStorageInterface;
import net.momirealms.customfishing.data.storage.SqlConnection;
import net.momirealms.customfishing.data.storage.StorageType;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.InventoryUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MySQLStorageImpl
implements DataStorageInterface {
    private final SqlConnection sqlConnection;
    private final CustomFishing plugin;

    public MySQLStorageImpl(CustomFishing plugin) {
        this.plugin = plugin;
        this.sqlConnection = new SqlConnection(this);
    }

    @Override
    public void initialize() {
        this.sqlConnection.createNewHikariConfiguration();
        this.createTableIfNotExist(this.sqlConnection.getTablePrefix() + "_fishingbag", "CREATE TABLE IF NOT EXISTS `%s` ( `uuid` VARCHAR(36) NOT NULL, `version` INT NOT NULL, `size` INT NOT NULL, `contents` LONGTEXT NOT NULL, PRIMARY KEY (`uuid`) )");
        this.createTableIfNotExist(this.sqlConnection.getTablePrefix() + "_selldata", "CREATE TABLE IF NOT EXISTS `%s` ( `uuid` VARCHAR(36) NOT NULL, `version` INT NOT NULL, `date` INT NOT NULL, `money` INT NOT NULL, PRIMARY KEY (`uuid`) )");
        this.createTableIfNotExist(this.sqlConnection.getTablePrefix() + "_statistics", "CREATE TABLE IF NOT EXISTS `%s` ( `uuid` VARCHAR(36) NOT NULL, `version` INT NOT NULL, `stats` LONGTEXT NOT NULL, PRIMARY KEY (`uuid`) )");
    }

    @Override
    public void disable() {
        this.sqlConnection.close();
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.SQL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Inventory loadBagData(UUID uuid, boolean force) {
        Inventory inventory = null;
        String sql = String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_fishingbag");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int version = rs.getInt(2);
                if (!force && version != 0) {
                    statement.close();
                    connection.close();
                    Inventory inventory2 = null;
                    return inventory2;
                }
                int size = rs.getInt(3);
                String contents = rs.getString(4);
                ItemStack[] itemStacks = InventoryUtils.getInventoryItems(contents);
                inventory = InventoryUtils.createInventory(null, size, this.plugin.getIntegrationManager().getPlaceholderManager().parse(offlinePlayer, ConfigManager.fishingBagTitle));
                if (itemStacks != null) {
                    inventory.setContents(itemStacks);
                }
                this.lockData(uuid, "fishingbag");
                return inventory;
            }
            inventory = InventoryUtils.createInventory(null, 9, this.plugin.getIntegrationManager().getPlaceholderManager().parse(offlinePlayer, ConfigManager.fishingBagTitle));
            this.insertBagData(uuid, InventoryUtils.toBase64(inventory.getContents()));
            return inventory;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return inventory;
    }

    @Override
    public void saveBagData(UUID uuid, Inventory inventory, boolean unlock) {
        this.updateBagData(uuid, inventory.getSize(), InventoryUtils.toBase64(inventory.getContents()), unlock);
    }

    @Override
    public void saveBagData(Set<Map.Entry<UUID, Inventory>> set, boolean unlock) {
        String sql = String.format("UPDATE `%s` SET `version` = ?, `size` = ?, `contents` = ? WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_fishingbag");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                for (Map.Entry<UUID, Inventory> entry : set) {
                    statement.setInt(1, unlock ? 0 : 1);
                    statement.setInt(2, entry.getValue().getSize());
                    statement.setString(3, InventoryUtils.toBase64(entry.getValue().getContents()));
                    statement.setString(4, entry.getKey().toString());
                    statement.addBatch();
                }
                statement.executeBatch();
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                AdventureUtils.consoleMessage("[CustomFishing] Failed to update bag data for online players");
            }
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to get connection");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerSellData loadSellData(UUID uuid, boolean force) {
        PlayerSellData playerSellData = null;
        String sql = String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_selldata");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int version = rs.getInt(2);
                if (!force && version != 0) {
                    statement.close();
                    connection.close();
                    PlayerSellData playerSellData2 = null;
                    return playerSellData2;
                }
                int date = rs.getInt(3);
                int money = rs.getInt(4);
                playerSellData = new PlayerSellData(money, date);
                this.lockData(uuid, "selldata");
                return playerSellData;
            }
            Calendar calendar = Calendar.getInstance();
            playerSellData = new PlayerSellData(0.0, (calendar.get(2) + 1) * 100 + calendar.get(5));
            this.insertSellData(uuid, playerSellData.getDate());
            return playerSellData;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return playerSellData;
    }

    @Override
    public void saveSellData(UUID uuid, PlayerSellData playerSellData, boolean unlock) {
        this.updateSellData(uuid, playerSellData.getDate(), (int)playerSellData.getMoney(), unlock);
    }

    @Override
    public void saveSellData(Set<Map.Entry<UUID, PlayerSellData>> set, boolean unlock) {
        String sql = String.format("UPDATE `%s` SET `version` = ?, `date` = ?, `money` = ? WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_selldata");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                for (Map.Entry<UUID, PlayerSellData> entry : set) {
                    statement.setInt(1, unlock ? 0 : 1);
                    statement.setInt(2, entry.getValue().getDate());
                    statement.setInt(3, (int)entry.getValue().getMoney());
                    statement.setString(4, entry.getKey().toString());
                    statement.addBatch();
                }
                statement.executeBatch();
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                AdventureUtils.consoleMessage("[CustomFishing] Failed to update sell data for all the players");
            }
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to get connection");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerStatisticsData loadStatistics(UUID uuid, boolean force) {
        PlayerStatisticsData playerStatisticsData = null;
        String sql = String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_statistics");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int version = rs.getInt(2);
                if (!force && version != 0) {
                    statement.close();
                    connection.close();
                    PlayerStatisticsData playerStatisticsData2 = null;
                    return playerStatisticsData2;
                }
                String longText = rs.getString(3);
                playerStatisticsData = new PlayerStatisticsData(longText);
                this.lockData(uuid, "statistics");
                return playerStatisticsData;
            }
            playerStatisticsData = new PlayerStatisticsData();
            this.insertStatisticsData(uuid);
            return playerStatisticsData;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return playerStatisticsData;
    }

    @Override
    public void saveStatistics(UUID uuid, PlayerStatisticsData statisticsData, boolean unlock) {
        this.updateStatisticsData(uuid, statisticsData.getLongText(), unlock);
    }

    @Override
    public void saveStatistics(Set<Map.Entry<UUID, PlayerStatisticsData>> set, boolean unlock) {
        String sql = String.format("UPDATE `%s` SET `version` = ?, `stats` = ? WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_statistics");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                for (Map.Entry<UUID, PlayerStatisticsData> entry : set) {
                    statement.setInt(1, unlock ? 0 : 1);
                    statement.setString(2, entry.getValue().getLongText());
                    statement.setString(3, entry.getKey().toString());
                    statement.addBatch();
                }
                statement.executeBatch();
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                AdventureUtils.consoleMessage("[CustomFishing] Failed to update statistics data for online players");
            }
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to get connection");
        }
    }

    private void createTableIfNotExist(String table, String sqlStat) {
        String sql = String.format(sqlStat, table);
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to create table");
        }
    }

    private void insertBagData(UUID uuid, String contents) {
        String sql = String.format("INSERT INTO `%s`(`uuid`, `version`, `size`, `contents`) VALUES (?, ?, ?, ?)", this.sqlConnection.getTablePrefix() + "_fishingbag");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            statement.setInt(2, 1);
            statement.setInt(3, 9);
            statement.setString(4, contents);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to insert data for " + uuid);
        }
    }

    private void insertSellData(UUID uuid, int date) {
        String sql = String.format("INSERT INTO `%s`(`uuid`, `version`, `date`, `money`) VALUES (?, ?, ?, ?)", this.sqlConnection.getTablePrefix() + "_selldata");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            statement.setInt(2, 1);
            statement.setInt(3, date);
            statement.setInt(4, 0);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to insert data for " + uuid);
        }
    }

    private void insertStatisticsData(UUID uuid) {
        String sql = String.format("INSERT INTO `%s`(`uuid`, `version`, `stats`) VALUES (?, ?, ?)", this.sqlConnection.getTablePrefix() + "_statistics");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            statement.setInt(2, 1);
            statement.setString(3, "");
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to insert data for " + uuid);
        }
    }

    private void updateBagData(UUID uuid, int size, String contents, boolean unlock) {
        String sql = String.format("UPDATE `%s` SET `version` = ?, `size` = ?, `contents` = ? WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_fishingbag");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, unlock ? 0 : 1);
            statement.setInt(2, size);
            statement.setString(3, contents);
            statement.setString(4, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to update data for " + uuid);
        }
    }

    private void updateSellData(UUID uuid, int date, int money, boolean unlock) {
        String sql = String.format("UPDATE `%s` SET `version` = ?, `date` = ?, `money` = ? WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_selldata");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, unlock ? 0 : 1);
            statement.setInt(2, date);
            statement.setInt(3, money);
            statement.setString(4, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to update data for " + uuid);
        }
    }

    private void updateStatisticsData(UUID uuid, String longText, boolean unlock) {
        String sql = String.format("UPDATE `%s` SET `version` = ?, `stats` = ? WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_statistics");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, unlock ? 0 : 1);
            statement.setString(2, longText);
            statement.setString(3, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("[CustomFishing] Failed to update data for " + uuid);
        }
    }

    public void migrate() {
        String sql_1 = String.format("ALTER TABLE `%s` ADD COLUMN `version` INT NOT NULL AFTER `uuid`", this.sqlConnection.getTablePrefix() + "_fishingbag");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql_1);){
            statement.executeUpdate();
            AdventureUtils.consoleMessage("<green>[CustomFishing] Tables updated");
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage(ex.getSQLState());
            AdventureUtils.consoleMessage("<red>[CustomFishing] Failed to migrate data");
        }
        String sql_2 = String.format("DROP TABLE `%s`", this.sqlConnection.getTablePrefix() + "_sellcache");
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql_2);){
            statement.executeUpdate();
            AdventureUtils.consoleMessage("<green>[CustomFishing] Outdated table deleted");
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage(ex.getSQLState());
            AdventureUtils.consoleMessage("<red>[CustomFishing] Failed to migrate data");
        }
    }

    public void lockData(UUID uuid, String table_suffix) {
        String sql = String.format("UPDATE `%s` SET `version` = 1 WHERE `uuid` = ?", this.sqlConnection.getTablePrefix() + "_" + table_suffix);
        try (Connection connection = this.sqlConnection.getConnectionAndCheck();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            AdventureUtils.consoleMessage("<red>[CustomFishing] Failed to lock data for " + uuid);
        }
    }
}

