/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.momirealms.customfishing.fishing.FishingCondition;
import net.momirealms.customfishing.fishing.requirements.RequirementInterface;
import net.momirealms.customfishing.manager.ConfigManager;

public class Effect {
    private HashMap<String, Double> weightMD;
    private HashMap<String, Integer> weightAS;
    private double timeModifier = 1.0;
    private double sizeMultiplier = 1.0;
    private double scoreMultiplier = 1.0;
    private int difficulty;
    private double doubleLootChance;
    private boolean canLavaFishing;
    private String specialRodID;
    private RequirementInterface[] requirements;

    public void setSizeMultiplier(double sizeMultiplier) {
        this.sizeMultiplier = sizeMultiplier;
    }

    public HashMap<String, Double> getWeightMD() {
        return this.weightMD;
    }

    public void setWeightMD(HashMap<String, Double> weightMD) {
        this.weightMD = weightMD;
    }

    public HashMap<String, Integer> getWeightAS() {
        return this.weightAS;
    }

    public void setWeightAS(HashMap<String, Integer> weightAS) {
        this.weightAS = weightAS;
    }

    public double getTimeModifier() {
        return this.timeModifier;
    }

    public void setTimeModifier(double timeModifier) {
        this.timeModifier = timeModifier;
    }

    public void setScoreMultiplier(double scoreMultiplier) {
        this.scoreMultiplier = scoreMultiplier;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public double getDoubleLootChance() {
        return this.doubleLootChance;
    }

    public void setDoubleLootChance(double doubleLootChance) {
        this.doubleLootChance = doubleLootChance;
    }

    public boolean canLavaFishing() {
        return this.canLavaFishing || ConfigManager.allRodsFishInLava;
    }

    public void setCanLavaFishing(boolean canLavaFishing) {
        this.canLavaFishing = canLavaFishing;
    }

    public RequirementInterface[] getRequirements() {
        return this.requirements;
    }

    public void setRequirements(RequirementInterface[] requirements) {
        this.requirements = requirements;
    }

    public void addEffect(Effect anotherEffect) {
        HashMap<String, Double> weightMD;
        HashMap<String, Integer> weightAS = anotherEffect.getWeightAS();
        if (weightAS != null) {
            for (Map.Entry<String, Integer> en : weightAS.entrySet()) {
                String group = en.getKey();
                this.weightAS.put(group, Optional.ofNullable(this.weightAS.get(group)).orElse(0) + en.getValue());
            }
        }
        if ((weightMD = anotherEffect.getWeightMD()) != null) {
            for (Map.Entry<String, Double> en : weightMD.entrySet()) {
                String group = en.getKey();
                this.weightMD.put(group, Optional.ofNullable(this.weightMD.get(group)).orElse(1.0) + en.getValue());
            }
        }
        this.timeModifier += anotherEffect.getTimeModifier() - 1.0;
        this.scoreMultiplier += anotherEffect.getScoreMultiplier() - 1.0;
        this.sizeMultiplier += anotherEffect.getSizeMultiplier() - 1.0;
        this.doubleLootChance += anotherEffect.getDoubleLootChance();
        this.difficulty += anotherEffect.getDifficulty();
        if (anotherEffect.canLavaFishing()) {
            this.canLavaFishing = true;
        }
    }

    public boolean canAddEffect(Effect anotherEffect, FishingCondition fishingCondition) {
        if (anotherEffect.getRequirements() != null) {
            for (RequirementInterface requirement : anotherEffect.getRequirements()) {
                if (requirement.isConditionMet(fishingCondition)) continue;
                return false;
            }
        }
        return true;
    }

    public double getScoreMultiplier() {
        return this.scoreMultiplier;
    }

    public double getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public boolean hasSpecialRod() {
        return this.specialRodID != null;
    }

    public void setSpecialRodID(String specialRodID) {
        this.specialRodID = specialRodID;
    }

    public String getSpecialRodID() {
        return this.specialRodID;
    }
}

