/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import org.bukkit.Location;
import org.bukkit.Particle;

public class LavaEffect
implements Runnable {
    private final Location startLoc;
    private final Location endLoc;
    private final Location controlLoc;
    private int timer;
    private final ScheduledFuture<?> lavaTask;

    public LavaEffect(Location loc, int delay) {
        this.startLoc = loc.clone().add(0.0, 0.3, 0.0);
        this.endLoc = this.startLoc.clone().add(Math.random() * 16.0 - 8.0, this.startLoc.getY(), Math.random() * 16.0 - 8.0);
        this.controlLoc = new Location(this.startLoc.getWorld(), (this.startLoc.getX() + this.endLoc.getX()) / 2.0 + Math.random() * 12.0 - 6.0, this.startLoc.getY(), (this.startLoc.getZ() + this.endLoc.getZ()) / 2.0 + Math.random() * 12.0 - 6.0);
        this.lavaTask = CustomFishing.getInstance().getScheduler().runTaskTimerAsync(this, (long)delay * 50L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        ++this.timer;
        if (this.timer > 60) {
            this.lavaTask.cancel(false);
        } else {
            double t = (double)this.timer / 60.0;
            Location particleLoc = this.endLoc.clone().multiply(Math.pow(1.0 - t, 2.0)).add(this.controlLoc.clone().multiply(2.0 * t * (1.0 - t))).add(this.startLoc.clone().multiply(Math.pow(t, 2.0)));
            particleLoc.setY(this.startLoc.getY());
            this.startLoc.getWorld().spawnParticle(Particle.FLAME, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void cancel() {
        this.lavaTask.cancel(false);
    }

    public boolean isCancelled() {
        return this.lavaTask.isCancelled();
    }
}

