/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.bar;

import java.util.Random;
import net.momirealms.customfishing.fishing.bar.FishingBar;
import org.bukkit.configuration.ConfigurationSection;

public class ModeTwoBar
extends FishingBar {
    private final int[] time_requirements;
    private final String judgement_area_image;
    private final String fish_image;
    private final int bar_effective_width;
    private final int judgement_area_offset;
    private final int judgement_area_width;
    private final int fish_icon_width;
    private final String[] progress;
    private final double punishment;
    private final double water_resistance;
    private final double pulling_strength;
    private final double loosening_loss;
    private final boolean sneakMode;

    public ModeTwoBar(ConfigurationSection section) {
        super(section);
        this.time_requirements = section.getIntegerList("hold-time-requirements").stream().mapToInt(Integer::intValue).toArray();
        this.judgement_area_image = section.getString("subtitle.judgment-area");
        this.fish_image = section.getString("subtitle.fish");
        this.bar_effective_width = section.getInt("arguments.bar-effective-area-width");
        this.judgement_area_offset = section.getInt("arguments.judgment-area-offset");
        this.judgement_area_width = section.getInt("arguments.judgment-area-width");
        this.fish_icon_width = section.getInt("arguments.fish-icon-width");
        this.punishment = section.getDouble("arguments.punishment");
        this.progress = section.getStringList("progress").toArray(new String[0]);
        this.water_resistance = section.getDouble("arguments.water-resistance", 0.15);
        this.pulling_strength = section.getDouble("arguments.pulling-strength", 0.45);
        this.loosening_loss = section.getDouble("arguments.loosening-strength-loss", 0.3);
        this.sneakMode = section.getString("arguments.pull-method", "sneak").equalsIgnoreCase("sneak");
    }

    public int getRandomTimeRequirement() {
        return this.time_requirements[new Random().nextInt(this.time_requirements.length)] * 20;
    }

    public String getJudgement_area_image() {
        return this.judgement_area_image;
    }

    public String getFish_image() {
        return this.fish_image;
    }

    public int getBar_effective_width() {
        return this.bar_effective_width;
    }

    public int getJudgement_area_offset() {
        return this.judgement_area_offset;
    }

    public int getJudgement_area_width() {
        return this.judgement_area_width;
    }

    public int getFish_icon_width() {
        return this.fish_icon_width;
    }

    public String[] getProgress() {
        return this.progress;
    }

    public double getPunishment() {
        return this.punishment;
    }

    public double getWater_resistance() {
        return this.water_resistance;
    }

    public double getPulling_strength() {
        return this.pulling_strength;
    }

    public double getLoosening_loss() {
        return this.loosening_loss;
    }

    public boolean isSneakMode() {
        return this.sneakMode;
    }
}

