/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.mode;

import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.bar.ModeThreeBar;
import net.momirealms.customfishing.fishing.mode.FishingGame;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;

public class ModeThreeGame
extends FishingGame {
    private final ModeThreeBar modeThreeBar;
    private int fish_position;
    private boolean success;
    private int timer;
    private final int timer_max;
    private double strain;
    private int struggling_time;

    public ModeThreeGame(CustomFishing plugin, FishingManager fishingManager, long deadline, Player player, int difficulty, ModeThreeBar modeThreeBar) {
        super(plugin, fishingManager, deadline, player, difficulty, modeThreeBar);
        this.fish_position = modeThreeBar.getFish_start_position();
        this.success = false;
        this.modeThreeBar = modeThreeBar;
        this.timer_max = modeThreeBar.getStruggling_fish_image().length;
        this.gameTask = plugin.getScheduler().runTaskTimer(this, 50L, 40L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        super.run();
        ++this.timer;
        if (this.timer >= this.timer_max) {
            this.timer = 0;
        }
        if (this.struggling_time <= 0) {
            if (Math.random() < (double)this.difficulty / 200.0) {
                this.struggling_time = (int)(20.0 + Math.random() * (double)this.difficulty * 3.0);
            }
        } else {
            --this.struggling_time;
        }
        if (this.player.isSneaking()) {
            this.pull();
        } else {
            this.loosen();
        }
        if (this.fish_position < this.modeThreeBar.getSuccess_position() - this.modeThreeBar.getFish_icon_width() - 1) {
            this.success = true;
            FishHook fishHook = this.fishingManager.getHook(this.player.getUniqueId());
            if (fishHook != null) {
                this.fishingManager.proceedReelIn(fishHook.getLocation(), this.player, this);
                this.fishingManager.removeHook(this.player.getUniqueId());
            }
            this.fishingManager.removeFishingPlayer(this.player);
            this.cancel();
            return;
        }
        if (this.fish_position + this.modeThreeBar.getFish_icon_width() > this.modeThreeBar.getBar_effective_width() || this.strain >= this.modeThreeBar.getUltimate_strain()) {
            FishHook fishHook = this.fishingManager.getHook(this.player.getUniqueId());
            if (fishHook != null) {
                this.fishingManager.proceedReelIn(fishHook.getLocation(), this.player, this);
                this.fishingManager.removeHook(this.player.getUniqueId());
            }
            this.fishingManager.removeFishingPlayer(this.player);
            this.cancel();
            return;
        }
        this.showBar();
    }

    public void pull() {
        if (this.struggling_time > 0) {
            this.strain += this.modeThreeBar.getStruggling_increase() + (double)this.difficulty / 5.0;
            --this.fish_position;
        } else {
            this.strain += this.modeThreeBar.getNormal_increase();
            this.fish_position -= 2;
        }
    }

    public void loosen() {
        ++this.fish_position;
        this.strain -= this.modeThreeBar.getStrain_loss();
    }

    @Override
    public void showBar() {
        String bar = "<font:" + this.modeThreeBar.getFont() + ">" + this.modeThreeBar.getBarImage() + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars(this.modeThreeBar.getFish_offset() + this.fish_position) + "</font>" + (this.struggling_time > 0 ? this.modeThreeBar.getStruggling_fish_image()[this.timer] : this.modeThreeBar.getFish_image()) + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars(this.modeThreeBar.getBar_effective_width() - this.fish_position - this.modeThreeBar.getFish_icon_width()) + "</font></font>";
        this.strain = Math.max(0.0, Math.min(this.strain, this.modeThreeBar.getUltimate_strain()));
        AdventureUtils.playerTitle(this.player, this.title.replace("{strain}", this.modeThreeBar.getStrain()[(int)(this.strain / this.modeThreeBar.getUltimate_strain() * (double)this.modeThreeBar.getStrain().length)]), bar, 0, 500, 0);
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }
}

