/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.mode;

import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.bar.ModeTwoBar;
import net.momirealms.customfishing.fishing.mode.FishingGame;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.LocationUtils;
import org.bukkit.Location;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;

public class ModeTwoGame
extends FishingGame {
    private boolean success = false;
    private double hold_time;
    private final ModeTwoBar modeTwoBar;
    private double judgement_position;
    private double fish_position;
    private double judgement_velocity;
    private double fish_velocity;
    private int timer;
    private final int time_requirement;
    private final Location hookLoc;
    private double distance;

    public ModeTwoGame(CustomFishing plugin, FishingManager fishingManager, long deadline, Player player, int difficulty, ModeTwoBar modeTwoBar, Location hookLoc) {
        super(plugin, fishingManager, deadline, player, difficulty, modeTwoBar);
        this.judgement_position = (double)(modeTwoBar.getBar_effective_width() - modeTwoBar.getJudgement_area_width()) / 2.0;
        this.fish_position = 0.0;
        this.timer = 0;
        this.modeTwoBar = modeTwoBar;
        this.time_requirement = modeTwoBar.getRandomTimeRequirement();
        this.hookLoc = hookLoc;
        this.distance = LocationUtils.getDistance(player.getLocation(), hookLoc);
        this.gameTask = plugin.getScheduler().runTaskTimer(this, 50L, 33L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        super.run();
        if (this.modeTwoBar.isSneakMode()) {
            if (this.player.isSneaking()) {
                this.addV(true);
            } else {
                this.reduceV();
            }
        } else {
            double newDistance = LocationUtils.getDistance(this.player.getLocation(), this.hookLoc);
            if (this.distance < newDistance) {
                this.addV(true);
            } else if (this.distance > newDistance) {
                this.addV(false);
            }
            this.distance = newDistance;
        }
        if (this.timer < 30) {
            ++this.timer;
        } else {
            this.timer = 0;
            if (Math.random() > 1.0 / (double)(this.difficulty + 1)) {
                this.burst();
            }
        }
        this.judgement_position += this.judgement_velocity;
        this.fish_position += this.fish_velocity;
        this.fraction();
        this.calibrate();
        this.hold_time = this.fish_position >= this.judgement_position - 2.0 && this.fish_position + (double)this.modeTwoBar.getFish_icon_width() <= this.judgement_position + (double)this.modeTwoBar.getJudgement_area_width() + 2.0 ? (this.hold_time += 0.66) : (this.hold_time -= this.modeTwoBar.getPunishment() * 0.66);
        if (this.hold_time >= (double)this.time_requirement) {
            this.success = true;
            FishHook fishHook = this.fishingManager.getHook(this.player.getUniqueId());
            if (fishHook != null) {
                this.fishingManager.proceedReelIn(fishHook.getLocation(), this.player, this);
                this.fishingManager.removeHook(this.player.getUniqueId());
            }
            this.fishingManager.removeFishingPlayer(this.player);
            this.cancel();
            return;
        }
        this.showBar();
    }

    @Override
    public void showBar() {
        String bar = "<font:" + this.modeTwoBar.getFont() + ">" + this.modeTwoBar.getBarImage() + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars((int)((double)this.modeTwoBar.getJudgement_area_offset() + this.judgement_position)) + "</font>" + this.modeTwoBar.getJudgement_area_image() + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars((int)((double)this.modeTwoBar.getBar_effective_width() - this.judgement_position - (double)this.modeTwoBar.getJudgement_area_width())) + "</font><font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars((int)((double)(-this.modeTwoBar.getBar_effective_width() - 1) + this.fish_position)) + "</font>" + this.modeTwoBar.getFish_image() + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars((int)((double)this.modeTwoBar.getBar_effective_width() - this.fish_position - (double)this.modeTwoBar.getFish_icon_width() + 1.0)) + "</font></font>";
        this.hold_time = Math.max(0.0, Math.min(this.hold_time, (double)this.time_requirement));
        AdventureUtils.playerTitle(this.player, this.title.replace("{progress}", this.modeTwoBar.getProgress()[(int)(this.hold_time / (double)this.time_requirement * (double)this.modeTwoBar.getProgress().length)]), bar, 0, 500, 0);
    }

    private void burst() {
        this.judgement_velocity = Math.random() < this.judgement_position / (double)this.modeTwoBar.getBar_effective_width() ? -1.0 - 0.8 * Math.random() * (double)this.difficulty : 1.0 + 0.8 * Math.random() * (double)this.difficulty;
    }

    private void fraction() {
        if (this.judgement_velocity > 0.0) {
            this.judgement_velocity -= this.modeTwoBar.getWater_resistance();
            if (this.judgement_velocity < 0.0) {
                this.judgement_velocity = 0.0;
            }
        } else {
            this.judgement_velocity += this.modeTwoBar.getWater_resistance();
            if (this.judgement_velocity > 0.0) {
                this.judgement_velocity = 0.0;
            }
        }
    }

    private void reduceV() {
        this.fish_velocity -= this.modeTwoBar.getLoosening_loss();
    }

    private void addV(boolean add) {
        this.fish_velocity = add ? (this.fish_velocity += this.modeTwoBar.getPulling_strength()) : (this.fish_velocity -= this.modeTwoBar.getPulling_strength());
    }

    private void calibrate() {
        if (this.fish_position < 0.0) {
            this.fish_position = 0.0;
            this.fish_velocity = 0.0;
        }
        if (this.fish_position + (double)this.modeTwoBar.getFish_icon_width() > (double)this.modeTwoBar.getBar_effective_width()) {
            this.fish_position = this.modeTwoBar.getBar_effective_width() - this.modeTwoBar.getFish_icon_width();
            this.fish_velocity = 0.0;
        }
        if (this.judgement_position < 0.0) {
            this.judgement_position = 0.0;
            this.judgement_velocity = 0.0;
        }
        if (this.judgement_position + (double)this.modeTwoBar.getJudgement_area_width() > (double)this.modeTwoBar.getBar_effective_width()) {
            this.judgement_position = this.modeTwoBar.getBar_effective_width() - this.modeTwoBar.getJudgement_area_width();
            this.judgement_velocity = 0.0;
        }
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }
}

