/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.requirements;

import java.util.List;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.FishingCondition;
import net.momirealms.customfishing.fishing.requirements.Requirement;
import net.momirealms.customfishing.fishing.requirements.RequirementInterface;
import net.momirealms.customfishing.integration.SeasonInterface;
import org.jetbrains.annotations.Nullable;

public class SeasonImpl
extends Requirement
implements RequirementInterface {
    private final List<String> seasons;

    public SeasonImpl(@Nullable String[] msg, List<String> seasons) {
        super(msg);
        this.seasons = seasons;
    }

    @Override
    public boolean isConditionMet(FishingCondition fishingCondition) {
        SeasonInterface seasonInterface = CustomFishing.getInstance().getIntegrationManager().getSeasonInterface();
        if (seasonInterface == null) {
            return true;
        }
        String currentSeason = seasonInterface.getSeason(fishingCondition.getLocation().getWorld());
        for (String season : this.seasons) {
            if (!season.equalsIgnoreCase(currentSeason)) continue;
            return true;
        }
        this.notMetMessage(fishingCondition.getPlayer());
        return false;
    }
}

