/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.totem;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.totem.TotemConfig;
import net.momirealms.customfishing.fishing.totem.TotemParticle;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.util.ArmorStandUtils;
import net.momirealms.customfishing.util.LocationUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public class ActivatedTotem
implements Runnable {
    public static int id = 121616121;
    private int timer;
    private final TotemConfig totem;
    private final Location bottomLoc;
    private final Location coreLoc;
    private final Set<Player> nearbyPlayerSet;
    private final int[] entityID;
    private final boolean hasHolo;
    private final TotemParticle particleTimerTask;
    private final FishingManager fishingManager;
    private final int direction;
    private final String activator;
    private final ScheduledFuture<?> totemTask;

    public ActivatedTotem(Location coreLoc, TotemConfig totem, FishingManager fishingManager, int direction, String activator) {
        this.fishingManager = fishingManager;
        this.totem = totem;
        this.coreLoc = coreLoc;
        this.bottomLoc = coreLoc.clone().subtract(0.0, (double)totem.getOriginalModel().getCorePos().getY(), 0.0);
        this.entityID = new int[totem.getHoloText().length];
        for (int i = 0; i < totem.getHoloText().length; ++i) {
            ++id;
        }
        this.hasHolo = totem.getHoloText() != null;
        this.nearbyPlayerSet = Collections.synchronizedSet(new HashSet());
        this.particleTimerTask = new TotemParticle(this.bottomLoc, totem.getRadius(), totem.getParticle());
        this.direction = direction;
        this.activator = activator;
        this.totemTask = CustomFishing.getInstance().getScheduler().runTaskTimer(this, 1L, 1L, TimeUnit.SECONDS, coreLoc);
    }

    @Override
    public void run() {
        int i;
        ++this.timer;
        if (this.timer > this.totem.getDuration()) {
            this.stop();
            return;
        }
        HashSet<Player> temp = new HashSet<Player>(this.nearbyPlayerSet);
        Collection<Player> nearbyPlayers = LocationUtils.getNearbyPlayers(this.bottomLoc, this.totem.getRadius());
        for (Player player : temp) {
            if (nearbyPlayers.remove(player)) {
                if (!this.hasHolo) continue;
                for (i = 0; i < this.entityID.length; ++i) {
                    CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getMetaPacket(this.entityID[i], this.totem.getHoloText()[this.entityID.length - 1 - i].replace("{time}", String.valueOf(this.totem.getDuration() - this.timer)).replace("{max_time}", String.valueOf(this.totem.getDuration())).replace("{player}", this.activator)));
                }
                this.addPotionEffect(player);
                continue;
            }
            if (this.hasHolo) {
                for (int j : this.entityID) {
                    CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getDestroyPacket(j));
                }
            }
            this.nearbyPlayerSet.remove(player);
        }
        for (Player newComer : nearbyPlayers) {
            if (this.hasHolo) {
                for (i = 0; i < this.entityID.length; ++i) {
                    CustomFishing.getProtocolManager().sendServerPacket(newComer, ArmorStandUtils.getSpawnPacket(this.entityID[i], this.bottomLoc.clone().add(0.5, this.totem.getHoloOffset() + (double)i * 0.4, 0.5)));
                    CustomFishing.getProtocolManager().sendServerPacket(newComer, ArmorStandUtils.getMetaPacket(this.entityID[i], this.totem.getHoloText()[this.entityID.length - 1 - i].replace("{time}", String.valueOf(this.totem.getDuration() - this.timer)).replace("{max_time}", String.valueOf(this.totem.getDuration())).replace("{player}", this.activator)));
                }
                this.addPotionEffect(newComer);
            }
            this.nearbyPlayerSet.add(newComer);
        }
    }

    public Set<Player> getNearbyPlayerSet() {
        return this.nearbyPlayerSet;
    }

    public TotemConfig getTotem() {
        return this.totem;
    }

    public void stop() {
        this.particleTimerTask.cancel();
        this.cancel();
        this.fishingManager.removeTotem(this.coreLoc);
        CustomFishing.getInstance().getTotemManager().clearBreakDetectCache(this.totem.getFinalModel(), this.bottomLoc, this.direction);
        if (this.hasHolo) {
            for (Player player : this.nearbyPlayerSet) {
                for (int j : this.entityID) {
                    CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getDestroyPacket(j));
                }
            }
        }
        this.nearbyPlayerSet.clear();
    }

    private void addPotionEffect(Player player) {
        if (this.totem.getPotionEffects() != null) {
            for (PotionEffect potionEffect : this.totem.getPotionEffects()) {
                player.addPotionEffect(potionEffect);
            }
        }
    }

    public void cancel() {
        this.totemTask.cancel(false);
    }
}

