/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.helper;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import java.util.StringJoiner;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.helper.Log;
import net.momirealms.customfishing.helper.MavenLibrary;
import net.momirealms.customfishing.helper.URLClassLoaderAccess;

public final class LibraryLoader {
    private static final Supplier<URLClassLoaderAccess> URL_INJECTOR = Suppliers.memoize(() -> URLClassLoaderAccess.create((URLClassLoader)((Object)((Object)CustomFishing.getInstance())).getClass().getClassLoader()));

    public static void loadAll(Object object) {
        LibraryLoader.loadAll(object.getClass());
    }

    public static void loadAll(Class<?> clazz) {
        MavenLibrary[] libs = (MavenLibrary[])clazz.getDeclaredAnnotationsByType(MavenLibrary.class);
        if (libs == null) {
            return;
        }
        for (MavenLibrary lib : libs) {
            LibraryLoader.load(lib.groupId(), lib.artifactId(), lib.version(), lib.repo().url());
        }
    }

    public static void load(String groupId, String artifactId, String version, String repoUrl) {
        LibraryLoader.load(new Dependency(groupId, artifactId, version, repoUrl));
    }

    public static void load(Dependency d) {
        String name = d.getArtifactId() + "-" + d.getVersion();
        File saveLocation = new File(LibraryLoader.getLibFolder(d), name + ".jar");
        if (!saveLocation.exists()) {
            try {
                Log.info("Dependency '" + name + "' is not already in the libraries folder. Attempting to download...");
                URL url = d.getUrl();
                try (InputStream is = url.openStream();){
                    Files.copy(is, saveLocation.toPath(), new CopyOption[0]);
                    Log.info("Dependency '" + name + "' successfully downloaded.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!saveLocation.exists()) {
            throw new RuntimeException("Unable to download dependency: " + d);
        }
        try {
            ((URLClassLoaderAccess)URL_INJECTOR.get()).addURL(saveLocation.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load dependency: " + saveLocation, e);
        }
    }

    private static File getLibFolder(Dependency dependency) {
        File pluginDataFolder = CustomFishing.getInstance().getDataFolder();
        File serverDir = pluginDataFolder.getParentFile().getParentFile();
        File helperDir = new File(serverDir, "libraries");
        String[] split = dependency.getGroupId().split("\\.");
        StringJoiner stringJoiner = new StringJoiner(File.separator);
        for (String str : split) {
            stringJoiner.add(str);
        }
        File jarDir = new File(helperDir, stringJoiner + File.separator + dependency.artifactId + File.separator + dependency.version);
        jarDir.mkdirs();
        return jarDir;
    }

    public static final class Dependency {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String repoUrl;

        public Dependency(String groupId, String artifactId, String version, String repoUrl) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.version = Objects.requireNonNull(version, "version");
            this.repoUrl = Objects.requireNonNull(repoUrl, "repoUrl");
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public URL getUrl() throws MalformedURLException {
            Object repo = this.repoUrl;
            if (!((String)repo).endsWith("/")) {
                repo = (String)repo + "/";
            }
            repo = (String)repo + "%s/%s/%s/%s-%s.jar";
            String url = String.format((String)repo, this.groupId.replace(".", "/"), this.artifactId, this.version, this.artifactId, this.version);
            return new URL(url);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            return this.getGroupId().equals(other.getGroupId()) && this.getArtifactId().equals(other.getArtifactId()) && this.getVersion().equals(other.getVersion()) && this.getRepoUrl().equals(other.getRepoUrl());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGroupId().hashCode();
            result = result * 59 + this.getArtifactId().hashCode();
            result = result * 59 + this.getVersion().hashCode();
            result = result * 59 + this.getRepoUrl().hashCode();
            return result;
        }

        public String toString() {
            return "LibraryLoader.Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", repoUrl=" + this.getRepoUrl() + ")";
        }
    }
}

