/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.quest;

import java.util.Collections;
import java.util.HashSet;
import net.momirealms.customfishing.api.event.FishResultEvent;
import net.momirealms.customfishing.fishing.FishResult;
import net.momirealms.customfishing.util.AdventureUtils;
import org.betonquest.betonquest.BetonQuest;
import org.betonquest.betonquest.Instruction;
import org.betonquest.betonquest.VariableNumber;
import org.betonquest.betonquest.api.CountingObjective;
import org.betonquest.betonquest.api.profiles.OnlineProfile;
import org.betonquest.betonquest.api.profiles.Profile;
import org.betonquest.betonquest.exceptions.InstructionParseException;
import org.betonquest.betonquest.exceptions.QuestRuntimeException;
import org.betonquest.betonquest.utils.PlayerConverter;
import org.betonquest.betonquest.utils.location.CompoundLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class NewBetonQuestCFQuest
extends CountingObjective
implements Listener {
    private final CompoundLocation playerLocation;
    private final VariableNumber rangeVar;
    private final HashSet<String> loot_ids = new HashSet();

    public NewBetonQuestCFQuest(Instruction instruction) throws InstructionParseException {
        super(instruction, "loot_to_fish");
        Collections.addAll(this.loot_ids, instruction.getArray());
        this.targetAmount = instruction.getInt();
        String pack = instruction.getPackage().getQuestPath();
        String loc = instruction.getOptional("playerLocation");
        String range = instruction.getOptional("range");
        if (loc != null && range != null) {
            this.playerLocation = new CompoundLocation(pack, loc);
            this.rangeVar = new VariableNumber(pack, range);
        } else {
            this.playerLocation = null;
            this.rangeVar = null;
        }
        if (this.targetAmount <= 0) {
            throw new InstructionParseException("Fish amount cannot be less than 0");
        }
    }

    public static void register() {
        BetonQuest.getInstance().registerObjectives("customfishing", NewBetonQuestCFQuest.class);
    }

    @EventHandler
    public void onFish(FishResultEvent event) {
        if (event.getResult() != FishResult.FAILURE) {
            OnlineProfile onlineProfile = PlayerConverter.getID((Player)event.getPlayer());
            if (!this.containsPlayer((Profile)onlineProfile)) {
                return;
            }
            if (this.isInvalidLocation(event, (Profile)onlineProfile)) {
                return;
            }
            if (this.loot_ids.contains(event.getLoot_id()) && this.checkConditions((Profile)onlineProfile)) {
                this.getCountingData((Profile)onlineProfile).progress(event.isDouble() ? 1 : 2);
                this.completeIfDoneOrNotify((Profile)onlineProfile);
            }
        }
    }

    private boolean isInvalidLocation(FishResultEvent event, Profile profile) {
        Location targetLocation;
        if (this.playerLocation == null || this.rangeVar == null) {
            return false;
        }
        try {
            targetLocation = this.playerLocation.getLocation(profile);
        }
        catch (QuestRuntimeException e) {
            AdventureUtils.consoleMessage(e.getMessage());
            return true;
        }
        int range = this.rangeVar.getInt(profile);
        Location playerLoc = event.getPlayer().getLocation();
        return !playerLoc.getWorld().equals(targetLocation.getWorld()) || targetLocation.distanceSquared(playerLoc) > (double)(range * range);
    }

    public void start() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BetonQuest.getInstance());
    }

    public void stop() {
        HandlerList.unregisterAll((Listener)this);
    }
}

