/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.listener;

import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.FishingManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;

public record PlayerFishListener(FishingManager manager) implements Listener
{
    @EventHandler(priority=EventPriority.MONITOR)
    public void onFishMONITOR(PlayerFishEvent event) {
        if (!ConfigManager.priority.equals("MONITOR")) {
            return;
        }
        this.selectState(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFishHIGHEST(PlayerFishEvent event) {
        if (!ConfigManager.priority.equals("HIGHEST")) {
            return;
        }
        this.selectState(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFishHIGH(PlayerFishEvent event) {
        if (!ConfigManager.priority.equals("HIGH")) {
            return;
        }
        this.selectState(event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onFishNORMAL(PlayerFishEvent event) {
        if (!ConfigManager.priority.equals("NORMAL")) {
            return;
        }
        this.selectState(event);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onFishLOW(PlayerFishEvent event) {
        if (!ConfigManager.priority.equals("LOW")) {
            return;
        }
        this.selectState(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFishLOWEST(PlayerFishEvent event) {
        if (!ConfigManager.priority.equals("LOWEST")) {
            return;
        }
        this.selectState(event);
    }

    public void selectState(PlayerFishEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!ConfigManager.getWorldsList().contains(event.getHook().getLocation().getWorld().getName())) {
            return;
        }
        switch (event.getState()) {
            case FISHING: {
                this.manager.onFishing(event);
                break;
            }
            case REEL_IN: {
                this.manager.onReelIn(event);
                break;
            }
            case CAUGHT_ENTITY: {
                this.manager.onCaughtEntity(event);
                break;
            }
            case CAUGHT_FISH: {
                this.manager.onCaughtFish(event);
                break;
            }
            case BITE: {
                this.manager.onBite(event);
            }
        }
    }
}

