/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import com.comphenix.protocol.events.PacketListener;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTItem;
import net.momirealms.customfishing.listener.InventoryListener;
import net.momirealms.customfishing.listener.JoinQuitListener;
import net.momirealms.customfishing.listener.WindowPacketListener;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.object.InventoryFunction;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.InventoryUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BagDataManager
extends InventoryFunction {
    private final ConcurrentHashMap<UUID, Inventory> dataMap;
    private final HashMap<UUID, Inventory> tempData;
    private final InventoryListener inventoryListener;
    private final WindowPacketListener windowPacketListener;
    private final JoinQuitListener joinQuitListener;
    private final CustomFishing plugin;

    public BagDataManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.dataMap = new ConcurrentHashMap();
        this.tempData = new HashMap();
        this.inventoryListener = new InventoryListener(this);
        this.windowPacketListener = new WindowPacketListener(this);
        this.joinQuitListener = new JoinQuitListener(this);
    }

    public void saveBagDataForOnlinePlayers(boolean unlock) {
        this.plugin.getDataManager().getDataStorageInterface().saveBagData(this.dataMap.entrySet(), unlock);
    }

    @Override
    public void load() {
        if (!ConfigManager.enableFishingBag) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
        CustomFishing.getProtocolManager().addPacketListener((PacketListener)this.windowPacketListener);
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this.inventoryListener);
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
        CustomFishing.getProtocolManager().removePacketListener((PacketListener)this.windowPacketListener);
    }

    @Override
    public void disable() {
        this.unload();
        this.saveBagDataForOnlinePlayers(true);
        this.dataMap.clear();
        this.tempData.clear();
    }

    public Inventory getPlayerBagData(UUID uuid) {
        return this.dataMap.get(uuid);
    }

    public void openFishingBag(Player viewer, OfflinePlayer ownerOffline, boolean force) {
        Player owner = ownerOffline.getPlayer();
        if (owner == null || !owner.isOnline()) {
            Inventory inventory = this.plugin.getDataManager().getDataStorageInterface().loadBagData(ownerOffline.getUniqueId(), force);
            if (inventory == null) {
                AdventureUtils.playerMessage(viewer, "<red>[CustomFishing] Failed to load bag data for player " + ownerOffline.getName());
                AdventureUtils.playerMessage(viewer, "<red>This might be caused by the target player is online but on another server");
                AdventureUtils.playerMessage(viewer, "<red>Use /fishingbag open [Player] --force to ignore this warning");
                return;
            }
            this.tempData.put(ownerOffline.getUniqueId(), inventory);
            viewer.openInventory(inventory);
        } else {
            Inventory inventory = this.dataMap.get(owner.getUniqueId());
            if (inventory == null) {
                AdventureUtils.consoleMessage("<red>[CustomFishing] Bag data is not loaded for player " + owner.getName());
            } else {
                this.openBagGUI(owner, viewer, inventory);
            }
        }
    }

    @Override
    public void onQuit(Player player) {
        UUID uuid = player.getUniqueId();
        Inventory inventory = this.dataMap.remove(uuid);
        this.triedTimes.remove(player.getUniqueId());
        if (inventory != null) {
            this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().getDataStorageInterface().saveBagData(uuid, inventory, true));
        }
    }

    @Override
    public void onJoin(Player player) {
        this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, false), 750L, TimeUnit.MILLISECONDS);
    }

    public void joinReadData(Player player, boolean force) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Inventory inventory = this.plugin.getDataManager().getDataStorageInterface().loadBagData(player.getUniqueId(), force);
        if (inventory != null) {
            this.dataMap.put(player.getUniqueId(), inventory);
        } else if (!force) {
            if (this.checkTriedTimes(player.getUniqueId())) {
                this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, false), 2500L, TimeUnit.MILLISECONDS);
            } else {
                this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, true), 2500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void onClickInventory(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory fishingBagInv = this.dataMap.get(player.getUniqueId());
        if (fishingBagInv == event.getInventory()) {
            ItemStack currentItem = event.getCurrentItem();
            if (currentItem == null || currentItem.getType() == Material.AIR) {
                return;
            }
            NBTItem nbtItem = new NBTItem(currentItem);
            NBTCompound nbtCompound = nbtItem.getCompound("CustomFishing");
            if (nbtCompound == null && !ConfigManager.bagWhiteListItems.contains(currentItem.getType())) {
                event.setCancelled(true);
                return;
            }
            if (nbtCompound != null) {
                String type = nbtCompound.getString("type");
                if (!ConfigManager.canStoreLoot && type.equals("loot")) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @Override
    public void onCloseInventory(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Inventory inventory = event.getInventory();
        Inventory fishingBagInv = this.dataMap.get(player.getUniqueId());
        if (fishingBagInv != null) {
            if (inventory == fishingBagInv) {
                for (ItemStack itemStack : event.getInventory().getContents()) {
                    NBTItem nbtItem;
                    if (itemStack == null || itemStack.getType() == Material.AIR || (nbtItem = new NBTItem(itemStack)).hasTag("CustomFishing") || ConfigManager.bagWhiteListItems.contains(itemStack.getType())) continue;
                    player.getInventory().addItem(new ItemStack[]{itemStack.clone()});
                    itemStack.setAmount(0);
                }
                return;
            }
            for (Map.Entry<UUID, Inventory> entry : this.tempData.entrySet()) {
                if (entry.getValue() != inventory) continue;
                this.tempData.remove(entry.getKey());
                this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().getDataStorageInterface().saveBagData((UUID)entry.getKey(), (Inventory)entry.getValue(), true));
            }
        }
    }

    public void openBagGUI(Player owner, Player viewer, Inventory inventory) {
        int size = 1;
        for (int i = 6; i > 1; --i) {
            if (!owner.hasPermission("fishingbag.rows." + i)) continue;
            size = i;
            break;
        }
        if (size * 9 != inventory.getSize()) {
            ItemStack[] itemStacks = inventory.getContents();
            Inventory newInv = InventoryUtils.createInventory(null, size * 9, this.plugin.getIntegrationManager().getPlaceholderManager().parse((OfflinePlayer)owner, ConfigManager.fishingBagTitle));
            newInv.setContents(itemStacks);
            this.dataMap.put(owner.getUniqueId(), newInv);
            viewer.openInventory(newInv);
        } else {
            viewer.openInventory(inventory);
        }
    }
}

