/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.action.Action;
import net.momirealms.customfishing.fishing.action.CommandActionImpl;
import net.momirealms.customfishing.fishing.action.MessageActionImpl;
import net.momirealms.customfishing.fishing.competition.CompetitionConfig;
import net.momirealms.customfishing.fishing.competition.CompetitionGoal;
import net.momirealms.customfishing.fishing.competition.CompetitionSchedule;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarConfig;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarOverlay;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.boss.BarColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class CompetitionManager
extends Function {
    private final CustomFishing plugin;
    private final HashMap<String, CompetitionConfig> competitionsT;
    private final HashMap<String, CompetitionConfig> competitionsC;
    private CompetitionSchedule competitionSchedule;

    public CompetitionManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.competitionsC = new HashMap();
        this.competitionsT = new HashMap();
    }

    @Override
    public void load() {
        if (ConfigManager.enableCompetition) {
            this.loadCompetitions();
            this.competitionSchedule = new CompetitionSchedule();
            this.competitionSchedule.load();
        }
    }

    @Override
    public void unload() {
        this.competitionsC.clear();
        this.competitionsT.clear();
        if (this.competitionSchedule != null) {
            this.competitionSchedule.unload();
        }
    }

    private void loadCompetitions() {
        File[] files;
        File competition_file = new File(this.plugin.getDataFolder() + File.separator + "competitions");
        if (!competition_file.exists()) {
            if (!competition_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("competitions" + File.separator + "default.yml", false);
        }
        if ((files = competition_file.listFiles()) == null) {
            return;
        }
        int amount = 0;
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            Set keys = config.getKeys(false);
            for (String key : keys) {
                ArrayList<Integer> days;
                ConfigurationSection competitionSection = config.getConfigurationSection(key);
                if (competitionSection == null) continue;
                boolean enableBsb = competitionSection.getBoolean("bossbar.enable", false);
                BossBarConfig bossBarConfig = new BossBarConfig(competitionSection.getStringList("bossbar.text").toArray(new String[0]), BossBarOverlay.valueOf(competitionSection.getString("bossbar.overlay", "SOLID").toUpperCase()), BarColor.valueOf((String)competitionSection.getString("bossbar.color", "WHITE").toUpperCase()), competitionSection.getInt("bossbar.refresh-rate", 10), competitionSection.getInt("bossbar.switch-interval", 200), !competitionSection.getBoolean("bossbar.only-show-to-participants", true));
                HashMap<String, Action[]> rewardsMap = new HashMap<String, Action[]>();
                Objects.requireNonNull(competitionSection.getConfigurationSection("prize")).getKeys(false).forEach(rank -> {
                    ArrayList<Record> rewards = new ArrayList<Record>();
                    if (competitionSection.contains("prize." + rank + ".messages")) {
                        rewards.add(new MessageActionImpl(competitionSection.getStringList("prize." + rank + ".messages").toArray(new String[0]), null));
                    }
                    if (competitionSection.contains("prize." + rank + ".commands")) {
                        rewards.add(new CommandActionImpl(competitionSection.getStringList("prize." + rank + ".commands").toArray(new String[0]), null));
                    }
                    rewardsMap.put((String)rank, rewards.toArray(new Action[0]));
                });
                CompetitionConfig competitionConfig = new CompetitionConfig(competitionSection.getInt("duration", 600), competitionSection.getInt("min-players", 1), competitionSection.getStringList("broadcast.start"), competitionSection.getStringList("broadcast.end"), competitionSection.getStringList("command.start"), competitionSection.getStringList("command.end"), competitionSection.getStringList("command.join"), CompetitionGoal.valueOf(competitionSection.getString("goal", "RANDOM")), bossBarConfig, enableBsb, rewardsMap);
                if (competitionSection.contains("start-weekday")) {
                    days = new ArrayList<Integer>();
                    Iterator<String> iterator = competitionSection.getStringList("start-weekday").stream().map(String::toLowerCase).toList().iterator();
                    block20: while (iterator.hasNext()) {
                        String weekDay;
                        switch (weekDay = iterator.next()) {
                            case "sunday": {
                                days.add(1);
                                continue block20;
                            }
                            case "monday": {
                                days.add(2);
                                continue block20;
                            }
                            case "tuesday": {
                                days.add(3);
                                continue block20;
                            }
                            case "wednesday": {
                                days.add(4);
                                continue block20;
                            }
                            case "thursday": {
                                days.add(5);
                                continue block20;
                            }
                            case "friday": {
                                days.add(6);
                                continue block20;
                            }
                            case "saturday": {
                                days.add(7);
                                continue block20;
                            }
                        }
                        AdventureUtils.consoleMessage("[CustomFishing] Unknown weekday: " + weekDay);
                    }
                    competitionConfig.setWeekday(days);
                }
                if (competitionSection.contains("start-date")) {
                    days = new ArrayList();
                    for (String weekDay : competitionSection.getStringList("start-date")) {
                        days.add(Integer.parseInt(weekDay));
                    }
                    competitionConfig.setDate(days);
                }
                competitionSection.getStringList("start-time").forEach(time -> this.competitionsT.put((String)time, competitionConfig));
                this.competitionsC.put(key, competitionConfig);
                ++amount;
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + amount + " <gray>competition(s)");
    }

    public HashMap<String, CompetitionConfig> getCompetitionsT() {
        return this.competitionsT;
    }

    public HashMap<String, CompetitionConfig> getCompetitionsC() {
        return this.competitionsC;
    }
}

