/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.Effect;
import net.momirealms.customfishing.fishing.loot.Item;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectManager
extends Function {
    private final CustomFishing plugin;
    private final HashMap<String, Item> baitItems;
    private final HashMap<String, Effect> baitEffects;
    private final HashMap<String, Item> rodItems;
    private final HashMap<String, Effect> rodEffects;
    private final HashMap<String, Item> utilItems;
    private final HashMap<String, Effect> utilEffects;
    private final HashMap<String, Effect> enchantEffects;

    public EffectManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.baitEffects = new HashMap();
        this.baitItems = new HashMap();
        this.rodEffects = new HashMap();
        this.rodItems = new HashMap();
        this.utilItems = new HashMap();
        this.enchantEffects = new HashMap();
        this.utilEffects = new HashMap();
    }

    @Override
    public void load() {
        this.loadRod();
        this.loadBait();
        this.loadEnchant();
        this.loadUtil();
    }

    @Override
    public void unload() {
        this.baitEffects.clear();
        this.baitItems.clear();
        this.rodEffects.clear();
        this.rodItems.clear();
        this.utilItems.clear();
        this.enchantEffects.clear();
        this.utilEffects.clear();
    }

    private void loadUtil() {
        File[] files;
        File util_file = new File(this.plugin.getDataFolder() + File.separator + "utils");
        if (!util_file.exists()) {
            if (!util_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("utils" + File.separator + "fish_finder.yml", false);
            this.plugin.saveResource("utils" + File.separator + "totem_items.yml", false);
            this.plugin.saveResource("utils" + File.separator + "splash_items.yml", false);
            this.plugin.saveResource("utils" + File.separator + "fisherman_talismans.yml", false);
        }
        if ((files = util_file.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            Set keys = config.getKeys(false);
            for (String key : keys) {
                ConfigurationSection utilSection = config.getConfigurationSection(key);
                if (utilSection == null) continue;
                Item item = new Item(utilSection, key);
                item.setCfTag(new String[]{"util", key});
                this.utilItems.put(key, item);
                Effect effect = ConfigUtils.getEffect(utilSection.getConfigurationSection("effect"));
                if (utilSection.contains("requirements")) {
                    effect.setRequirements(ConfigUtils.getRequirements(utilSection.getConfigurationSection("requirements")));
                }
                this.utilEffects.put(key, effect);
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + this.utilItems.size() + " <gray>util(s)");
    }

    private void loadEnchant() {
        File[] files;
        File enchant_file = new File(this.plugin.getDataFolder() + File.separator + "enchants");
        if (!enchant_file.exists()) {
            if (!enchant_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("enchants" + File.separator + "default.yml", false);
        }
        if ((files = enchant_file.listFiles()) == null) {
            return;
        }
        int amount = 0;
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String key : config.getKeys(false)) {
                ConfigurationSection levelSection = config.getConfigurationSection(key);
                if (levelSection == null) continue;
                for (String level : levelSection.getKeys(false)) {
                    Effect effect = ConfigUtils.getEffect(levelSection.getConfigurationSection(level + ".effect"));
                    if (levelSection.contains(level + ".requirements")) {
                        effect.setRequirements(ConfigUtils.getRequirements(levelSection.getConfigurationSection(level + ".requirements")));
                    }
                    this.enchantEffects.put((String)(key.startsWith("eco") ? "minecraft" + key.substring(3) : key) + ":" + level, effect);
                }
                ++amount;
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + amount + " <gray>enchantment(s)");
    }

    private void loadBait() {
        File[] files;
        File bait_file = new File(this.plugin.getDataFolder() + File.separator + "baits");
        if (!bait_file.exists()) {
            if (!bait_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("baits" + File.separator + "default.yml", false);
        }
        if ((files = bait_file.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            Set keys = config.getKeys(false);
            for (String key : keys) {
                ConfigurationSection baitSection = config.getConfigurationSection(key);
                if (baitSection == null) continue;
                Item item = new Item(baitSection, key);
                item.setCfTag(new String[]{"bait", key});
                this.baitItems.put(key, item);
                Effect effect = ConfigUtils.getEffect(baitSection.getConfigurationSection("effect"));
                if (baitSection.contains("requirements")) {
                    effect.setRequirements(ConfigUtils.getRequirements(baitSection.getConfigurationSection("requirements")));
                }
                this.baitEffects.put(key, effect);
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + this.baitItems.size() + " <gray>bait(s)");
    }

    private void loadRod() {
        File[] files;
        File rod_file = new File(this.plugin.getDataFolder() + File.separator + "rods");
        if (!rod_file.exists()) {
            if (!rod_file.mkdir()) {
                return;
            }
            this.plugin.saveResource("rods" + File.separator + "default.yml", false);
        }
        if ((files = rod_file.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            Set keys = config.getKeys(false);
            for (String key : keys) {
                ConfigurationSection rodSection = config.getConfigurationSection(key);
                if (rodSection == null) continue;
                rodSection.set("material", (Object)"fishing_rod");
                Item item = new Item(rodSection, key);
                item.setCfTag(new String[]{"rod", key});
                this.rodItems.put(key, item);
                Effect effect = ConfigUtils.getEffect(rodSection.getConfigurationSection("effect"));
                if (rodSection.contains("requirements")) {
                    effect.setRequirements(ConfigUtils.getRequirementsWithMsg(rodSection.getConfigurationSection("requirements")));
                }
                this.rodEffects.put(key, effect);
            }
        }
        AdventureUtils.consoleMessage("[CustomFishing] Loaded <green>" + this.rodItems.size() + " <gray>rod(s)");
    }

    @Nullable
    public Item getBaitItem(String key) {
        return this.baitItems.get(key);
    }

    @NotNull
    public HashMap<String, Item> getBaitItems() {
        return this.baitItems;
    }

    @Nullable
    public Effect getBaitEffect(String key) {
        return this.baitEffects.get(key);
    }

    @NotNull
    public HashMap<String, Effect> getBaitEffects() {
        return this.baitEffects;
    }

    @Nullable
    public Item getRodItem(String key) {
        return this.rodItems.get(key);
    }

    @NotNull
    public HashMap<String, Item> getRodItems() {
        return this.rodItems;
    }

    @Nullable
    public Effect getRodEffect(String key) {
        return this.rodEffects.get(key);
    }

    @NotNull
    public HashMap<String, Effect> getRodEffects() {
        return this.rodEffects;
    }

    @Nullable
    public Effect getEnchantEffect(String key) {
        return this.enchantEffects.get(key);
    }

    @NotNull
    public HashMap<String, Effect> getEnchantEffects() {
        return this.enchantEffects;
    }

    @Nullable
    public Item getUtilItem(String key) {
        return this.utilItems.get(key);
    }

    @NotNull
    public HashMap<String, Item> getUtilItems() {
        return this.utilItems;
    }

    @NotNull
    public HashMap<String, Effect> getUtilEffects() {
        return this.utilEffects;
    }

    @Nullable
    public Effect getUtilEffect(String key) {
        return this.utilEffects.get(key);
    }
}

