/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import java.util.ArrayList;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.helper.Log;
import net.momirealms.customfishing.integration.BlockInterface;
import net.momirealms.customfishing.integration.EnchantmentInterface;
import net.momirealms.customfishing.integration.ItemInterface;
import net.momirealms.customfishing.integration.JobInterface;
import net.momirealms.customfishing.integration.MobInterface;
import net.momirealms.customfishing.integration.SeasonInterface;
import net.momirealms.customfishing.integration.SkillInterface;
import net.momirealms.customfishing.integration.VaultHook;
import net.momirealms.customfishing.integration.block.ItemsAdderBlockImpl;
import net.momirealms.customfishing.integration.block.OraxenBlockImpl;
import net.momirealms.customfishing.integration.block.VanillaBlockImpl;
import net.momirealms.customfishing.integration.enchantment.AEImpl;
import net.momirealms.customfishing.integration.enchantment.VanillaImpl;
import net.momirealms.customfishing.integration.item.CustomFishingItemImpl;
import net.momirealms.customfishing.integration.item.EcoItemRegister;
import net.momirealms.customfishing.integration.item.ItemsAdderItemImpl;
import net.momirealms.customfishing.integration.item.MMOItemsItemImpl;
import net.momirealms.customfishing.integration.item.MythicMobsItemImpl;
import net.momirealms.customfishing.integration.item.OraxenItemImpl;
import net.momirealms.customfishing.integration.job.EcoJobsImpl;
import net.momirealms.customfishing.integration.job.JobsRebornImpl;
import net.momirealms.customfishing.integration.mob.MythicMobsMobImpl;
import net.momirealms.customfishing.integration.papi.PlaceholderManager;
import net.momirealms.customfishing.integration.quest.BattlePassCFQuest;
import net.momirealms.customfishing.integration.quest.ClueScrollCFQuest;
import net.momirealms.customfishing.integration.quest.NewBetonQuestCFQuest;
import net.momirealms.customfishing.integration.quest.OldBetonQuestCFQuest;
import net.momirealms.customfishing.integration.season.CustomCropsSeasonImpl;
import net.momirealms.customfishing.integration.season.RealisticSeasonsImpl;
import net.momirealms.customfishing.integration.skill.AureliumsImpl;
import net.momirealms.customfishing.integration.skill.EcoSkillsImpl;
import net.momirealms.customfishing.integration.skill.MMOCoreImpl;
import net.momirealms.customfishing.integration.skill.mcMMOImpl;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ConfigUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegrationManager
extends Function {
    private SeasonInterface seasonInterface;
    private SkillInterface skillInterface;
    private ItemInterface[] itemInterfaces;
    private MobInterface mobInterface;
    private BlockInterface blockInterface;
    private JobInterface jobInterface;
    private EnchantmentInterface enchantmentInterface;
    private final PlaceholderManager placeholderManager;
    private VaultHook vaultHook;
    private final CustomFishing plugin;
    private final PluginManager pluginManager;

    public IntegrationManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.pluginManager = Bukkit.getPluginManager();
        this.placeholderManager = new PlaceholderManager(plugin);
    }

    @Override
    public void load() {
        this.placeholderManager.load();
        this.hookSeasons();
        this.hookSkills();
        this.hookJobs();
        this.hookItems();
        this.hookVault();
        this.hookMobs();
        this.hookBlocks();
        this.hookEnchants();
    }

    @Override
    public void unload() {
        this.seasonInterface = null;
        this.skillInterface = null;
        this.itemInterfaces = null;
        this.mobInterface = null;
        this.blockInterface = null;
        this.jobInterface = null;
        this.enchantmentInterface = null;
        this.placeholderManager.unload();
    }

    private void hookEnchants() {
        if (this.pluginManager.isPluginEnabled("AdvancedEnchantments")) {
            this.enchantmentInterface = new AEImpl();
            this.hookMessage("AdvancedEnchantments");
        } else if (this.pluginManager.isPluginEnabled("EcoEnchants")) {
            this.enchantmentInterface = new VanillaImpl();
            this.hookMessage("EcoEnchants");
        } else {
            this.enchantmentInterface = new VanillaImpl();
        }
    }

    private void hookMobs() {
        if (this.pluginManager.isPluginEnabled("MythicMobs") && this.pluginManager.getPlugin("MythicMobs").getDescription().getVersion().startsWith("5")) {
            this.mobInterface = new MythicMobsMobImpl();
        }
    }

    private void hookBlocks() {
        this.blockInterface = this.pluginManager.isPluginEnabled("Oraxen") ? new OraxenBlockImpl() : (this.pluginManager.isPluginEnabled("ItemsAdder") ? new ItemsAdderBlockImpl() : new VanillaBlockImpl());
    }

    private void hookSeasons() {
        if (this.pluginManager.isPluginEnabled("RealisticSeasons")) {
            this.seasonInterface = new RealisticSeasonsImpl();
            this.hookMessage("RealisticSeasons");
        } else if (this.pluginManager.isPluginEnabled("CustomCrops")) {
            this.seasonInterface = new CustomCropsSeasonImpl();
            this.hookMessage("CustomCrops");
        }
    }

    private void hookSkills() {
        if (this.pluginManager.isPluginEnabled("mcMMO")) {
            this.skillInterface = new mcMMOImpl();
            this.hookMessage("mcMMO");
        } else if (this.pluginManager.isPluginEnabled("MMOCore")) {
            this.skillInterface = new MMOCoreImpl(ConfigUtils.getConfig("config.yml").getString("other-settings.MMOCore-profession-name", "fishing"));
            this.hookMessage("MMOCore");
        } else if (this.pluginManager.isPluginEnabled("AureliumSkills")) {
            this.skillInterface = new AureliumsImpl();
            this.hookMessage("AureliumSkills");
        } else if (this.pluginManager.isPluginEnabled("EcoSkills")) {
            this.skillInterface = new EcoSkillsImpl();
            this.hookMessage("EcoSkills");
        }
    }

    private void hookJobs() {
        JobInterface jobInterface = this.jobInterface;
        if (jobInterface instanceof JobsRebornImpl) {
            JobsRebornImpl jobsReborn = (JobsRebornImpl)jobInterface;
            HandlerList.unregisterAll((Listener)jobsReborn);
        }
        if (this.pluginManager.isPluginEnabled("Jobs")) {
            this.jobInterface = new JobsRebornImpl();
            Bukkit.getPluginManager().registerEvents((Listener)this.jobInterface, (Plugin)this.plugin);
            this.hookMessage("JobsReborn");
        } else if (this.pluginManager.isPluginEnabled("EcoJobs")) {
            this.jobInterface = new EcoJobsImpl();
            this.hookMessage("EcoJobs");
        }
    }

    private void hookVault() {
        if (this.pluginManager.isPluginEnabled("Vault")) {
            this.vaultHook = new VaultHook();
            if (!this.vaultHook.initialize()) {
                Log.warn("Failed to initialize Vault!");
            } else {
                this.hookMessage("Vault");
            }
        }
    }

    private void hookItems() {
        ArrayList<ItemInterface> itemInterfaceList = new ArrayList<ItemInterface>();
        if (this.pluginManager.isPluginEnabled("ItemsAdder")) {
            itemInterfaceList.add(new ItemsAdderItemImpl());
            this.hookMessage("ItemsAdder");
        }
        if (this.pluginManager.isPluginEnabled("Oraxen")) {
            itemInterfaceList.add(new OraxenItemImpl());
            this.hookMessage("Oraxen");
        }
        if (this.pluginManager.isPluginEnabled("MMOItems")) {
            itemInterfaceList.add(new MMOItemsItemImpl());
            this.hookMessage("MMOItems");
        }
        if (this.pluginManager.isPluginEnabled("MythicMobs") && this.pluginManager.getPlugin("MythicMobs").getDescription().getVersion().startsWith("5")) {
            itemInterfaceList.add(new MythicMobsItemImpl());
            this.hookMessage("MythicMobs");
        }
        itemInterfaceList.add(new CustomFishingItemImpl(this.plugin));
        this.itemInterfaces = itemInterfaceList.toArray(new ItemInterface[0]);
        if (this.pluginManager.isPluginEnabled("eco")) {
            EcoItemRegister.registerItems();
            this.hookMessage("eco");
        }
    }

    public void registerQuests() {
        if (this.pluginManager.isPluginEnabled("ClueScrolls")) {
            ClueScrollCFQuest clueScrollCFQuest = new ClueScrollCFQuest();
            Bukkit.getPluginManager().registerEvents((Listener)clueScrollCFQuest, (Plugin)this.plugin);
            this.hookMessage("ClueScrolls");
        }
        if (this.pluginManager.isPluginEnabled("BetonQuest")) {
            if (Bukkit.getPluginManager().getPlugin("BetonQuest").getDescription().getVersion().startsWith("2")) {
                NewBetonQuestCFQuest.register();
            } else {
                OldBetonQuestCFQuest.register();
            }
            this.hookMessage("BetonQuest");
        }
        if (this.pluginManager.isPluginEnabled("BattlePass")) {
            BattlePassCFQuest.register();
            this.hookMessage("BattlePass");
        }
    }

    @Nullable
    public SeasonInterface getSeasonInterface() {
        return this.seasonInterface;
    }

    @Nullable
    public SkillInterface getSkillInterface() {
        return this.skillInterface;
    }

    @NotNull
    public ItemInterface[] getItemInterfaces() {
        return this.itemInterfaces;
    }

    @Nullable
    public MobInterface getMobInterface() {
        return this.mobInterface;
    }

    @NotNull
    public BlockInterface getBlockInterface() {
        return this.blockInterface;
    }

    @NotNull
    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    @NotNull
    public EnchantmentInterface getEnchantmentInterface() {
        return this.enchantmentInterface;
    }

    @Nullable
    public JobInterface getJobInterface() {
        return this.jobInterface;
    }

    @NotNull
    public ItemStack build(String key) {
        for (ItemInterface itemInterface : this.getItemInterfaces()) {
            ItemStack itemStack = itemInterface.build(key);
            if (itemStack == null) continue;
            return itemStack;
        }
        return new ItemStack(Material.AIR);
    }

    public void loseCustomDurability(ItemStack itemStack, Player player) {
        Damageable damageable = (Damageable)itemStack.getItemMeta();
        if (damageable.isUnbreakable()) {
            return;
        }
        for (ItemInterface itemInterface : this.getItemInterfaces()) {
            if (!itemInterface.loseCustomDurability(itemStack, player)) continue;
            return;
        }
    }

    private void hookMessage(String plugin) {
        AdventureUtils.consoleMessage("[CustomFishing] " + plugin + " hooked!");
    }

    @Nullable
    public VaultHook getVaultHook() {
        return this.vaultHook;
    }
}

