/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.object.Function;
import net.momirealms.customfishing.util.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class OffsetManager
extends Function {
    private CustomFishing plugin;
    private final String[] negative;
    private final String[] positive;
    private String font;

    public OffsetManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.negative = new String[8];
        this.positive = new String[8];
    }

    @Override
    public void load() {
        this.loadConfig();
    }

    public String getFont() {
        return this.font;
    }

    private void loadConfig() {
        YamlConfiguration config = ConfigUtils.getConfig("config.yml");
        ConfigurationSection section = config.getConfigurationSection("other-settings.offset-characters");
        if (section != null) {
            this.font = section.getString("font", "customfishing:offset_chars");
            this.positive[0] = section.getString("1");
            this.positive[1] = section.getString("2");
            this.positive[2] = section.getString("4");
            this.positive[3] = section.getString("8");
            this.positive[4] = section.getString("16");
            this.positive[5] = section.getString("32");
            this.positive[6] = section.getString("64");
            this.positive[7] = section.getString("128");
            this.negative[0] = section.getString("-1");
            this.negative[1] = section.getString("-2");
            this.negative[2] = section.getString("-4");
            this.negative[3] = section.getString("-8");
            this.negative[4] = section.getString("-16");
            this.negative[5] = section.getString("-32");
            this.negative[6] = section.getString("-64");
            this.negative[7] = section.getString("-128");
        }
    }

    public String getShortestNegChars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= 128) {
            stringBuilder.append(this.negative[7]);
            n -= 128;
        }
        if (n - 64 >= 0) {
            stringBuilder.append(this.negative[6]);
            n -= 64;
        }
        if (n - 32 >= 0) {
            stringBuilder.append(this.negative[5]);
            n -= 32;
        }
        if (n - 16 >= 0) {
            stringBuilder.append(this.negative[4]);
            n -= 16;
        }
        if (n - 8 >= 0) {
            stringBuilder.append(this.negative[3]);
            n -= 8;
        }
        if (n - 4 >= 0) {
            stringBuilder.append(this.negative[2]);
            n -= 4;
        }
        if (n - 2 >= 0) {
            stringBuilder.append(this.negative[1]);
            n -= 2;
        }
        if (n - 1 >= 0) {
            stringBuilder.append(this.negative[0]);
        }
        return stringBuilder.toString();
    }

    public String getShortestPosChars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= 128) {
            stringBuilder.append(this.positive[7]);
            n -= 128;
        }
        if (n - 64 >= 0) {
            stringBuilder.append(this.positive[6]);
            n -= 64;
        }
        if (n - 32 >= 0) {
            stringBuilder.append(this.positive[5]);
            n -= 32;
        }
        if (n - 16 >= 0) {
            stringBuilder.append(this.positive[4]);
            n -= 16;
        }
        if (n - 8 >= 0) {
            stringBuilder.append(this.positive[3]);
            n -= 8;
        }
        if (n - 4 >= 0) {
            stringBuilder.append(this.positive[2]);
            n -= 4;
        }
        if (n - 2 >= 0) {
            stringBuilder.append(this.positive[1]);
            n -= 2;
        }
        if (n - 1 >= 0) {
            stringBuilder.append(this.positive[0]);
        }
        return stringBuilder.toString();
    }

    public String getOffsetChars(int n) {
        if (n > 0) {
            return this.getShortestPosChars(n);
        }
        return this.getShortestNegChars(-n);
    }
}

