/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.manager;

import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.api.event.SellFishEvent;
import net.momirealms.customfishing.data.PlayerSellData;
import net.momirealms.customfishing.fishing.loot.Item;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTItem;
import net.momirealms.customfishing.libs.net.kyori.adventure.key.Key;
import net.momirealms.customfishing.libs.net.kyori.adventure.sound.Sound;
import net.momirealms.customfishing.listener.InventoryListener;
import net.momirealms.customfishing.listener.JoinQuitListener;
import net.momirealms.customfishing.listener.WindowPacketListener;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.object.InventoryFunction;
import net.momirealms.customfishing.util.AdventureUtils;
import net.momirealms.customfishing.util.ConfigUtils;
import net.momirealms.customfishing.util.InventoryUtils;
import net.momirealms.customfishing.util.ItemStackUtils;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SellManager
extends InventoryFunction {
    private final WindowPacketListener windowPacketListener;
    private final InventoryListener inventoryListener;
    private final JoinQuitListener joinQuitListener;
    private final CustomFishing plugin;
    public static String formula;
    public static String title;
    public static int guiSize;
    public static String msgNotification;
    public static String actionbarNotification;
    public static String titleNotification;
    public static String subtitleNotification;
    public static int titleIn;
    public static int titleStay;
    public static int titleOut;
    public static String[] commands;
    public static Item sellIcon;
    public static Item denyIcon;
    public static Key closeKey;
    public static Key openKey;
    public static Key successKey;
    public static Key denyKey;
    public static Sound.Source soundSource;
    public static HashMap<Integer, ItemStack> guiItems;
    public static HashSet<Integer> functionIconSlots;
    public static HashMap<Material, Float> vanillaPrices;
    public static boolean sellLimitation;
    public static int upperLimit;
    private final ConcurrentHashMap<UUID, PlayerSellData> sellDataMap;

    public SellManager(CustomFishing plugin) {
        this.plugin = plugin;
        this.windowPacketListener = new WindowPacketListener(this);
        this.inventoryListener = new InventoryListener(this);
        this.joinQuitListener = new JoinQuitListener(this);
        this.sellDataMap = new ConcurrentHashMap();
    }

    @Override
    public void load() {
        functionIconSlots = new HashSet();
        guiItems = new HashMap();
        vanillaPrices = new HashMap();
        this.loadConfig();
        CustomFishing.getProtocolManager().addPacketListener((PacketListener)this.windowPacketListener);
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        CustomFishing.getProtocolManager().removePacketListener((PacketListener)this.windowPacketListener);
        HandlerList.unregisterAll((Listener)this.inventoryListener);
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
        msgNotification = null;
        actionbarNotification = null;
        commands = null;
        titleNotification = null;
    }

    @Override
    public void disable() {
        this.unload();
        this.plugin.getDataManager().getDataStorageInterface().saveSellData(this.sellDataMap.entrySet(), true);
        this.sellDataMap.clear();
    }

    @Override
    public void onQuit(Player player) {
        UUID uuid = player.getUniqueId();
        PlayerSellData sellData = this.sellDataMap.remove(uuid);
        if (sellData == null) {
            return;
        }
        this.plugin.getScheduler().runTaskAsync(() -> this.plugin.getDataManager().getDataStorageInterface().saveSellData(uuid, sellData, true));
    }

    @Override
    public void onJoin(Player player) {
        this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, false), 1L, TimeUnit.SECONDS);
    }

    public void joinReadData(Player player, boolean force) {
        if (player == null || !player.isOnline()) {
            return;
        }
        PlayerSellData sellData = this.plugin.getDataManager().getDataStorageInterface().loadSellData(player.getUniqueId(), force);
        if (sellData != null) {
            this.sellDataMap.put(player.getUniqueId(), sellData);
        } else if (!force) {
            if (this.checkTriedTimes(player.getUniqueId())) {
                this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, false), 2500L, TimeUnit.MILLISECONDS);
            } else {
                this.plugin.getScheduler().runTaskAsyncLater(() -> this.joinReadData(player, true), 2500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void loadConfig() {
        YamlConfiguration config = ConfigUtils.getConfig("sell-fish.yml");
        formula = config.getString("price-formula", "{base} + {bonus} * {size}");
        sellLimitation = config.getBoolean("sell-limitation.enable", false);
        upperLimit = config.getInt("sell-limitation.upper-limit", 10000);
        title = config.getString("container-title");
        guiSize = config.getInt("rows") * 9;
        this.setSounds((ConfigurationSection)config);
        this.setActions((ConfigurationSection)config);
        this.setIcons((ConfigurationSection)config);
        ConfigurationSection configurationSection = config.getConfigurationSection("vanilla-item-price");
        if (configurationSection != null) {
            for (String vanilla : configurationSection.getKeys(false)) {
                vanillaPrices.put(Material.valueOf((String)vanilla.toUpperCase()), Float.valueOf((float)configurationSection.getDouble(vanilla)));
            }
        }
    }

    private void setSounds(ConfigurationSection config) {
        openKey = config.contains("sounds.open") ? Key.key(config.getString("sounds.open")) : null;
        closeKey = config.contains("sounds.close") ? Key.key(config.getString("sounds.close")) : null;
        successKey = config.contains("sounds.success") ? Key.key(config.getString("sounds.success")) : null;
        denyKey = config.contains("sounds.deny") ? Key.key(config.getString("sounds.deny")) : null;
        soundSource = Sound.Source.valueOf(config.getString("sounds.type", "player").toUpperCase());
    }

    private void setActions(ConfigurationSection config) {
        if (config.getBoolean("actions.message.enable", false)) {
            msgNotification = config.getString("actions.message.text");
        }
        if (config.getBoolean("actions.actionbar.enable", false)) {
            actionbarNotification = config.getString("actions.actionbar.text");
        }
        if (config.getBoolean("actions.title.enable", false)) {
            titleNotification = config.getString("actions.title.title");
            subtitleNotification = config.getString("actions.title.subtitle");
            titleIn = config.getInt("actions.title.in");
            titleStay = config.getInt("actions.title.stay");
            titleOut = config.getInt("actions.title.out");
        }
        if (config.getBoolean("actions.commands.enable")) {
            commands = config.getStringList("actions.commands.value").toArray(new String[0]);
        }
    }

    private void setIcons(ConfigurationSection config) {
        ConfigurationSection sellIconSection;
        ConfigurationSection dec_section;
        if (config.contains("decorative-icons") && (dec_section = config.getConfigurationSection("decorative-icons")) != null) {
            for (String key : dec_section.getKeys(false)) {
                ConfigurationSection item_section = dec_section.getConfigurationSection(key);
                if (item_section == null) continue;
                Item item = new Item(item_section, key);
                ItemStack itemStack = ItemStackUtils.getFromItem(item);
                if (!item_section.contains("slots")) continue;
                Iterator iterator = item_section.getIntegerList("slots").iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    guiItems.put(slot - 1, itemStack);
                }
            }
        }
        if ((sellIconSection = config.getConfigurationSection("functional-icons.sell")) != null) {
            sellIcon = new Item(sellIconSection, "sellIcon");
        } else {
            AdventureUtils.consoleMessage("<red>[CustomFishing] Sell icon is missing");
        }
        ConfigurationSection denyIconSection = config.getConfigurationSection("functional-icons.deny");
        if (denyIconSection != null) {
            denyIcon = new Item(denyIconSection, "denyIcon");
        } else {
            AdventureUtils.consoleMessage("<red>[CustomFishing] Deny icon is missing");
        }
        Iterator iterator = config.getIntegerList("functional-icons.slots").iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            guiItems.put(slot - 1, ItemStackUtils.getFromItem(sellIcon));
            functionIconSlots.add(slot - 1);
        }
    }

    public void openGuiForPlayer(Player player) {
        player.closeInventory();
        if (!this.sellDataMap.containsKey(player.getUniqueId())) {
            AdventureUtils.consoleMessage("<red>Sell cache is not loaded for player " + player.getName());
            return;
        }
        SellGUI sellGUI = new SellGUI(player);
        sellGUI.open();
    }

    @Override
    public void onClickInventory(InventoryClickEvent event) {
        Player player = (Player)event.getView().getPlayer();
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof SellGUI)) {
            return;
        }
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        boolean update = true;
        if (clickedInventory == player.getInventory()) {
            if (event.isShiftClick()) {
                event.setCancelled(true);
                int empty_slot = this.getEmptySlot(inventory);
                if (empty_slot == -1) {
                    return;
                }
                ItemStack clicked = event.getCurrentItem();
                if (clicked == null || clicked.getType() == Material.AIR) {
                    return;
                }
                inventory.setItem(empty_slot, clicked.clone());
                clicked.setAmount(0);
            }
        } else {
            int clickedSlot = event.getSlot();
            if (guiItems.containsKey(clickedSlot)) {
                event.setCancelled(true);
            }
            if (functionIconSlots.contains(clickedSlot)) {
                List<ItemStack> playerItems = this.getPlayerItems(inventory);
                float totalPrice = this.getTotalPrice(playerItems);
                if (totalPrice > 0.0f) {
                    PlayerSellData sellData = this.sellDataMap.get(player.getUniqueId());
                    if (sellData == null) {
                        inventory.close();
                        AdventureUtils.playerMessage(player, MessageManager.prefix + "Your data is not loaded! Try to rejoin the server");
                        AdventureUtils.consoleMessage("<red>[CustomFishing] Unexpected issue, " + player.getName() + "'s sell-cache is not loaded!");
                        if (denyKey != null) {
                            AdventureUtils.playerSound(player, soundSource, denyKey, 1.0f, 1.0f);
                        }
                        return;
                    }
                    Calendar calendar = Calendar.getInstance();
                    int currentDate = (calendar.get(2) + 1) * 100 + calendar.get(5);
                    if (currentDate != sellData.getDate()) {
                        sellData.setDate(currentDate);
                        sellData.setMoney(0.0);
                    }
                    double sell = sellData.getMoney();
                    if (sellLimitation && sell + (double)totalPrice > (double)upperLimit) {
                        inventory.close();
                        AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.reachSellLimit);
                        if (denyKey != null) {
                            AdventureUtils.playerSound(player, soundSource, denyKey, 1.0f, 1.0f);
                        }
                        return;
                    }
                    SellFishEvent sellFishEvent = new SellFishEvent(player, totalPrice);
                    Bukkit.getPluginManager().callEvent((Event)sellFishEvent);
                    if (sellFishEvent.isCancelled()) {
                        return;
                    }
                    for (ItemStack playerItem : playerItems) {
                        if (playerItem == null || playerItem.getType() == Material.AIR || this.getSingleItemPrice(playerItem) == 0.0f) continue;
                        playerItem.setAmount(0);
                    }
                    sellData.setMoney((double)sellFishEvent.getMoney() + sell);
                    this.doActions(player, sellFishEvent.getMoney(), (double)upperLimit - sell - (double)sellFishEvent.getMoney());
                    inventory.close();
                } else {
                    for (int slot : functionIconSlots) {
                        inventory.setItem(slot, ItemStackUtils.getFromItem(denyIcon));
                    }
                    update = false;
                    if (denyKey != null) {
                        AdventureUtils.playerSound(player, soundSource, denyKey, 1.0f, 1.0f);
                    }
                }
            }
        }
        if (update) {
            this.plugin.getScheduler().runTaskAsync(() -> {
                ItemStack icon = ItemStackUtils.getFromItem(sellIcon.cloneWithPrice(this.getTotalPrice(this.getPlayerItems(inventory))));
                for (int slot : functionIconSlots) {
                    inventory.setItem(slot, icon);
                }
            });
        }
    }

    @Override
    public void onDragInventory(InventoryDragEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof SellGUI)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!guiItems.containsKey(i)) continue;
            event.setCancelled(true);
            return;
        }
        this.plugin.getScheduler().runTaskAsync(() -> {
            ItemStack icon = ItemStackUtils.getFromItem(sellIcon.cloneWithPrice(this.getTotalPrice(this.getPlayerItems(inventory))));
            for (int slot : functionIconSlots) {
                inventory.setItem(slot, icon);
            }
        });
    }

    @Override
    public void onCloseInventory(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof SellGUI)) {
            return;
        }
        this.returnItems(this.getPlayerItems(inventory), player);
        if (closeKey != null) {
            AdventureUtils.playerSound(player, soundSource, closeKey, 1.0f, 1.0f);
        }
    }

    private List<ItemStack> getPlayerItems(Inventory inventory) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < guiSize; ++i) {
            if (guiItems.containsKey(i)) continue;
            items.add(inventory.getItem(i));
        }
        return items;
    }

    private int getEmptySlot(Inventory inventory) {
        for (int i = 0; i < guiSize; ++i) {
            ItemStack item;
            if (guiItems.containsKey(i) || (item = inventory.getItem(i)) != null && item.getType() != Material.AIR) continue;
            return i;
        }
        return -1;
    }

    private void returnItems(List<ItemStack> itemStacks, Player player) {
        PlayerInventory inventory = player.getInventory();
        for (ItemStack stack : itemStacks) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            if (this.hasEmptySlot(inventory)) {
                inventory.addItem(new ItemStack[]{stack});
                continue;
            }
            player.getLocation().getWorld().dropItemNaturally(player.getLocation(), stack);
        }
    }

    private boolean hasEmptySlot(PlayerInventory inventory) {
        for (ItemStack itemStack : inventory.getStorageContents()) {
            if (itemStack != null && itemStack.getType() != Material.AIR) continue;
            return true;
        }
        return false;
    }

    private float getTotalPrice(List<ItemStack> itemStacks) {
        float totalPrice = 0.0f;
        for (ItemStack stack : itemStacks) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            float price = this.getSingleItemPrice(stack);
            totalPrice += (price *= (float)stack.getAmount());
        }
        return totalPrice;
    }

    public float getSingleItemPrice(ItemStack itemStack) {
        Double money;
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTCompound fishMeta = nbtItem.getCompound("FishMeta");
        float price = 0.0f;
        if (fishMeta != null) {
            float base = fishMeta.getFloat("base").floatValue();
            float bonus = fishMeta.getFloat("bonus").floatValue();
            float size = fishMeta.getFloat("size").floatValue();
            Expression expression = new ExpressionBuilder(formula).variables(new String[]{"base", "bonus", "size"}).build().setVariable("base", (double)base).setVariable("bonus", (double)bonus).setVariable("size", (double)size);
            price = (float)expression.evaluate();
        }
        if ((price = (float)((double)price + (money = Optional.ofNullable(nbtItem.getDouble("Price")).orElse(0.0)))) == 0.0f) {
            price = Optional.ofNullable(vanillaPrices.get(itemStack.getType())).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return price;
    }

    private void doActions(Player player, float earnings, double remains) {
        if (titleNotification != null) {
            AdventureUtils.playerTitle(player, titleNotification.replace("{money}", String.format("%.2f", Float.valueOf(earnings))).replace("{remains}", sellLimitation ? String.format("%.2f", remains) : "unlimited"), subtitleNotification.replace("{money}", String.format("%.2f", Float.valueOf(earnings))).replace("{remains}", sellLimitation ? String.format("%.2f", remains) : "unlimited"), titleIn * 50, titleStay * 50, titleOut * 50);
        }
        if (msgNotification != null) {
            AdventureUtils.playerMessage(player, msgNotification.replace("{money}", String.format("%.2f", Float.valueOf(earnings))).replace("{remains}", sellLimitation ? String.format("%.2f", remains) : "unlimited"));
        }
        if (actionbarNotification != null) {
            AdventureUtils.playerActionbar(player, actionbarNotification.replace("{money}", String.format("%.2f", Float.valueOf(earnings))).replace("{remains}", sellLimitation ? String.format("%.2f", remains) : "unlimited"));
        }
        if (ConfigManager.logEarning) {
            AdventureUtils.consoleMessage("[CustomFishing] Log: " + player.getName() + " earns " + String.format("%.2f", Float.valueOf(earnings)) + " from selling fish");
        }
        if (successKey != null) {
            AdventureUtils.playerSound(player, soundSource, successKey, 1.0f, 1.0f);
        }
        if (this.plugin.getIntegrationManager().getVaultHook() != null) {
            this.plugin.getIntegrationManager().getVaultHook().getEconomy().depositPlayer((OfflinePlayer)player, (double)earnings);
        }
        if (commands != null) {
            for (String cmd : commands) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd.replace("{player}", player.getName()).replace("{money}", String.format("%.2f", Float.valueOf(earnings))).replace("{remains}", sellLimitation ? String.format("%.2f", remains) : "unlimited"));
            }
        }
    }

    public double getTodayEarning(Player player) {
        PlayerSellData playerSellData = this.sellDataMap.get(player.getUniqueId());
        if (playerSellData == null) {
            return 0.0;
        }
        Calendar calendar = Calendar.getInstance();
        int currentDate = (calendar.get(2) + 1) * 100 + calendar.get(5);
        if (currentDate != playerSellData.getDate()) {
            playerSellData.setDate(currentDate);
            playerSellData.setMoney(0.0);
        }
        return playerSellData.getMoney();
    }

    static {
        vanillaPrices = new HashMap();
    }

    public class SellGUI
    implements InventoryHolder {
        private final Inventory inventory;
        private final Player player;

        @NotNull
        public Inventory getInventory() {
            return this.inventory;
        }

        public SellGUI(Player player) {
            this.player = player;
            this.inventory = InventoryUtils.createInventory((InventoryHolder)this, guiSize, SellManager.this.plugin.getIntegrationManager().getPlaceholderManager().parse((OfflinePlayer)player, title));
        }

        public void open() {
            for (Map.Entry<Integer, ItemStack> entry : guiItems.entrySet()) {
                this.inventory.setItem(entry.getKey().intValue(), entry.getValue());
            }
            Iterator<Object> iterator = functionIconSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                this.inventory.setItem(slot, ItemStackUtils.getFromItem(sellIcon.cloneWithPrice(SellManager.this.getTotalPrice(SellManager.this.getPlayerItems(this.inventory)))));
            }
            if (openKey != null) {
                AdventureUtils.playerSound(this.player, soundSource, openKey, 1.0f, 1.0f);
            }
            this.player.openInventory(this.inventory);
        }
    }
}

