/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.libs.net.kyori.adventure.audience.Audience;
import net.momirealms.customfishing.libs.net.kyori.adventure.key.Key;
import net.momirealms.customfishing.libs.net.kyori.adventure.sound.Sound;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.Component;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.TextComponent;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.format.TextColor;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.format.TextDecoration;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import net.momirealms.customfishing.libs.net.kyori.adventure.title.Title;
import net.momirealms.customfishing.object.Reflection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdventureUtils {
    public static Component getComponentFromMiniMessage(String text) {
        return MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(text));
    }

    public static void sendMessage(CommandSender sender, String s) {
        if (s == null) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            AdventureUtils.playerMessage(player, s);
        } else {
            AdventureUtils.consoleMessage(s);
        }
    }

    public static void consoleMessage(String s) {
        if (s == null) {
            return;
        }
        Audience au = CustomFishing.getAdventure().sender((CommandSender)Bukkit.getConsoleSender());
        au.sendMessage(AdventureUtils.getComponentFromMiniMessage(s));
    }

    public static void playerMessage(Player player, String s) {
        if (s == null) {
            return;
        }
        Audience au = CustomFishing.getAdventure().player(player);
        au.sendMessage(AdventureUtils.getComponentFromMiniMessage(s));
    }

    public static void playerTitle(Player player, String s1, String s2, int in, int duration, int out) {
        Audience au = CustomFishing.getAdventure().player(player);
        Title.Times times = Title.Times.times(Duration.ofMillis(in), Duration.ofMillis(duration), Duration.ofMillis(out));
        Title title = Title.title(AdventureUtils.getComponentFromMiniMessage(s1), AdventureUtils.getComponentFromMiniMessage(s2), times);
        au.showTitle(title);
    }

    public static void playerTitle(Player player, Component s1, Component s2, int in, int duration, int out) {
        Audience au = CustomFishing.getAdventure().player(player);
        Title.Times times = Title.Times.times(Duration.ofMillis(in), Duration.ofMillis(duration), Duration.ofMillis(out));
        Title title = Title.title(s1, s2, times);
        au.showTitle(title);
    }

    public static void playerActionbar(Player player, String s) {
        Audience au = CustomFishing.getAdventure().player(player);
        au.sendActionBar(AdventureUtils.getComponentFromMiniMessage(s));
    }

    public static void playerSound(Player player, Sound.Source source, Key key, float volume, float pitch) {
        Sound sound = Sound.sound(key, source, volume, pitch);
        Audience au = CustomFishing.getAdventure().player(player);
        au.playSound(sound);
    }

    public static String replaceLegacy(String legacy) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = legacy.toCharArray();
        block25: for (int i = 0; i < chars.length; ++i) {
            if (AdventureUtils.isColorCode(chars[i])) {
                if (i + 1 < chars.length) {
                    switch (chars[i + 1]) {
                        case '0': {
                            stringBuilder.append("<black>");
                            break;
                        }
                        case '1': {
                            stringBuilder.append("<dark_blue>");
                            break;
                        }
                        case '2': {
                            stringBuilder.append("<dark_green>");
                            break;
                        }
                        case '3': {
                            stringBuilder.append("<dark_aqua>");
                            break;
                        }
                        case '4': {
                            stringBuilder.append("<dark_red>");
                            break;
                        }
                        case '5': {
                            stringBuilder.append("<dark_purple>");
                            break;
                        }
                        case '6': {
                            stringBuilder.append("<gold>");
                            break;
                        }
                        case '7': {
                            stringBuilder.append("<gray>");
                            break;
                        }
                        case '8': {
                            stringBuilder.append("<dark_gray>");
                            break;
                        }
                        case '9': {
                            stringBuilder.append("<blue>");
                            break;
                        }
                        case 'a': {
                            stringBuilder.append("<green>");
                            break;
                        }
                        case 'b': {
                            stringBuilder.append("<aqua>");
                            break;
                        }
                        case 'c': {
                            stringBuilder.append("<red>");
                            break;
                        }
                        case 'd': {
                            stringBuilder.append("<light_purple>");
                            break;
                        }
                        case 'e': {
                            stringBuilder.append("<yellow>");
                            break;
                        }
                        case 'f': {
                            stringBuilder.append("<white>");
                            break;
                        }
                        case 'r': {
                            stringBuilder.append("<reset><!italic>");
                            break;
                        }
                        case 'l': {
                            stringBuilder.append("<bold>");
                            break;
                        }
                        case 'm': {
                            stringBuilder.append("<strikethrough>");
                            break;
                        }
                        case 'o': {
                            stringBuilder.append("<italic>");
                            break;
                        }
                        case 'n': {
                            stringBuilder.append("<underlined>");
                            break;
                        }
                        case 'k': {
                            stringBuilder.append("<obfuscated>");
                            break;
                        }
                        case 'x': {
                            if (!(i + 13 < chars.length && AdventureUtils.isColorCode(chars[i + 2]) && AdventureUtils.isColorCode(chars[i + 4]) && AdventureUtils.isColorCode(chars[i + 6]) && AdventureUtils.isColorCode(chars[i + 8]) && AdventureUtils.isColorCode(chars[i + 10]) && AdventureUtils.isColorCode(chars[i + 12]))) {
                                stringBuilder.append(chars[i]);
                                continue block25;
                            }
                            stringBuilder.append("<#").append(chars[i + 3]).append(chars[i + 5]).append(chars[i + 7]).append(chars[i + 9]).append(chars[i + 11]).append(chars[i + 13]).append(">");
                            i += 13;
                            break;
                        }
                        default: {
                            stringBuilder.append(chars[i]);
                            continue block25;
                        }
                    }
                    ++i;
                    continue;
                }
                stringBuilder.append(chars[i]);
                continue;
            }
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    private static boolean isColorCode(char c) {
        return c == '\u00a7' || c == '&';
    }

    public static String replaceMiniMessage(String str) {
        String result = str.replace("&", "\u00a7");
        ArrayList<String> miniFormat = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<.*?>");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            miniFormat.add(matcher.group());
        }
        for (String mini : miniFormat) {
            StringBuilder replacer = new StringBuilder();
            switch (mini) {
                case "<black>": {
                    replacer = new StringBuilder("\u00a70");
                    break;
                }
                case "<dark_blue>": {
                    replacer = new StringBuilder("\u00a71");
                    break;
                }
                case "<dark_green>": {
                    replacer = new StringBuilder("\u00a72");
                    break;
                }
                case "<dark_aqua>": {
                    replacer = new StringBuilder("\u00a73");
                    break;
                }
                case "<dark_red>": {
                    replacer = new StringBuilder("\u00a74");
                    break;
                }
                case "<dark_purple>": {
                    replacer = new StringBuilder("\u00a75");
                    break;
                }
                case "<gold>": {
                    replacer = new StringBuilder("\u00a76");
                    break;
                }
                case "<gray>": {
                    replacer = new StringBuilder("\u00a77");
                    break;
                }
                case "<dark_gray>": {
                    replacer = new StringBuilder("\u00a78");
                    break;
                }
                case "<blue>": {
                    replacer = new StringBuilder("\u00a79");
                    break;
                }
                case "<green>": {
                    replacer = new StringBuilder("\u00a7a");
                    break;
                }
                case "<aqua>": {
                    replacer = new StringBuilder("\u00a7b");
                    break;
                }
                case "<red>": {
                    replacer = new StringBuilder("\u00a7c");
                    break;
                }
                case "<light_purple>": {
                    replacer = new StringBuilder("\u00a7d");
                    break;
                }
                case "<yellow>": {
                    replacer = new StringBuilder("\u00a7e");
                    break;
                }
                case "<white>": {
                    replacer = new StringBuilder("\u00a7f");
                    break;
                }
                case "<reset>": {
                    replacer = new StringBuilder("\u00a7r");
                    break;
                }
                case "<bold>": {
                    replacer = new StringBuilder("\u00a7l");
                    break;
                }
                case "<strikethrough>": {
                    replacer = new StringBuilder("\u00a7m");
                    break;
                }
                case "<italic>": {
                    replacer = new StringBuilder("\u00a7o");
                    break;
                }
                case "<underlined>": {
                    replacer = new StringBuilder("\u00a7n");
                    break;
                }
                case "<obfuscated>": {
                    replacer = new StringBuilder("\u00a7k");
                    break;
                }
                default: {
                    if (mini.length() != 9 || mini.charAt(1) != '#') break;
                    replacer = new StringBuilder("\u00a7x");
                    for (int i = 2; i < 8; ++i) {
                        replacer.append("\u00a7").append(mini.charAt(i));
                    }
                }
            }
            result = result.replace(mini, replacer.toString());
        }
        return result;
    }

    public static Object getPaperComponent(Component component) {
        try {
            Object newComponent;
            if (component instanceof TextComponent) {
                Key fontKey;
                TextComponent textComponent = (TextComponent)component;
                Method textComponentMethod = Reflection.componentClass.getMethod("text", String.class);
                newComponent = textComponentMethod.invoke(null, textComponent.content());
                TextColor textColor = textComponent.color();
                if (textColor != null) {
                    String hex = textColor.asHexString();
                    Method setColorMethod = Reflection.textComponentClass.getMethod("color", Reflection.textColorClass);
                    Method getColorFromHex = Reflection.textColorClass.getMethod("fromHexString", String.class);
                    Object hexColor = getColorFromHex.invoke(null, hex);
                    newComponent = setColorMethod.invoke(newComponent, hexColor);
                }
                if ((fontKey = textComponent.font()) != null) {
                    String namespacedKey = fontKey.asString();
                    Method setKeyMethod = Reflection.textComponentClass.getMethod("font", Reflection.keyClass);
                    Method keyMethod = Reflection.keyClass.getMethod("key", String.class);
                    Object key = keyMethod.invoke(null, namespacedKey);
                    newComponent = setKeyMethod.invoke(newComponent, key);
                }
                for (Map.Entry<TextDecoration, TextDecoration.State> entry : textComponent.decorations().entrySet()) {
                    String dec = entry.getKey().name();
                    Method getTextDecoration = Reflection.textDecorationClass.getDeclaredMethod("valueOf", String.class);
                    Object textDecoration = getTextDecoration.invoke(null, dec);
                    String stat = entry.getValue().name();
                    Method getState = Reflection.textDecorationStateClass.getDeclaredMethod("valueOf", String.class);
                    Object state = getState.invoke(null, stat);
                    Method applyDecorationMethod = Reflection.textComponentClass.getMethod("decoration", Reflection.textDecorationClass, Reflection.textDecorationStateClass);
                    newComponent = applyDecorationMethod.invoke(newComponent, textDecoration, state);
                }
                newComponent = AdventureUtils.setChildrenComponents(textComponent, newComponent);
            } else {
                Method textComponentMethod = Reflection.componentClass.getMethod("text", String.class);
                newComponent = textComponentMethod.invoke(null, "");
                newComponent = AdventureUtils.setChildrenComponents(component, newComponent);
            }
            return newComponent;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object setChildrenComponents(Component component, Object newComponent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> children = new ArrayList<Object>();
        for (Component child : component.children()) {
            children.add(AdventureUtils.getPaperComponent(child));
        }
        if (children.size() != 0) {
            Method childrenMethod = Reflection.componentClass.getMethod("children", List.class);
            newComponent = childrenMethod.invoke(newComponent, children);
        }
        return newComponent;
    }
}

