/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.loot.Item;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import net.momirealms.customfishing.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customfishing.util.ItemStackUtils;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ArmorStandUtils {
    public static PacketContainer getDestroyPacket(int id) {
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(id)));
        return destroyPacket;
    }

    public static PacketContainer getSpawnPacket(int id, Location location) {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        entityPacket.getModifier().write(0, (Object)id);
        entityPacket.getModifier().write(1, (Object)UUID.randomUUID());
        entityPacket.getEntityTypeModifier().write(0, (Object)EntityType.ARMOR_STAND);
        entityPacket.getDoubles().write(0, (Object)location.getX());
        entityPacket.getDoubles().write(1, (Object)location.getY());
        entityPacket.getDoubles().write(2, (Object)location.getZ());
        return entityPacket;
    }

    public static PacketContainer getMetaPacket(int id) {
        PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        metaPacket.getIntegers().write(0, (Object)id);
        if (CustomFishing.getInstance().getVersionHelper().isVersionNewerThan1_19_R2()) {
            WrappedDataWatcher wrappedDataWatcher = ArmorStandUtils.createDataWatcher();
            ArmorStandUtils.setValueList(metaPacket, wrappedDataWatcher);
        } else {
            metaPacket.getWatchableCollectionModifier().write(0, (Object)ArmorStandUtils.createDataWatcher().getWatchableObjects());
        }
        return metaPacket;
    }

    static void setValueList(PacketContainer metaPacket, WrappedDataWatcher wrappedDataWatcher) {
        ArrayList wrappedDataValueList = Lists.newArrayList();
        wrappedDataWatcher.getWatchableObjects().stream().filter(Objects::nonNull).forEach(entry -> {
            WrappedDataWatcher.WrappedDataWatcherObject dataWatcherObject = entry.getWatcherObject();
            wrappedDataValueList.add(new WrappedDataValue(dataWatcherObject.getIndex(), dataWatcherObject.getSerializer(), entry.getRawValue()));
        });
        metaPacket.getDataValueCollectionModifier().write(0, (Object)wrappedDataValueList);
    }

    public static PacketContainer getMetaPacket(int id, String text) {
        PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        metaPacket.getIntegers().write(0, (Object)id);
        if (CustomFishing.getInstance().getVersionHelper().isVersionNewerThan1_19_R2()) {
            WrappedDataWatcher wrappedDataWatcher = ArmorStandUtils.createDataWatcher(text);
            ArmorStandUtils.setValueList(metaPacket, wrappedDataWatcher);
        } else {
            metaPacket.getWatchableCollectionModifier().write(0, (Object)ArmorStandUtils.createDataWatcher(text).getWatchableObjects());
        }
        return metaPacket;
    }

    public static WrappedDataWatcher createDataWatcher() {
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer1 = WrappedDataWatcher.Registry.get(Boolean.class);
        WrappedDataWatcher.Serializer serializer2 = WrappedDataWatcher.Registry.get(Byte.class);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, serializer1), (Object)false);
        byte flag = 32;
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, serializer2), (Object)flag);
        return wrappedDataWatcher;
    }

    public static WrappedDataWatcher createDataWatcher(String text) {
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer1 = WrappedDataWatcher.Registry.get(Boolean.class);
        WrappedDataWatcher.Serializer serializer2 = WrappedDataWatcher.Registry.get(Byte.class);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true)), Optional.of(WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(text)))).getHandle()));
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, serializer1), (Object)true);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(15, serializer2), (Object)1);
        byte flag = 32;
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, serializer2), (Object)flag);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, serializer1), (Object)true);
        return wrappedDataWatcher;
    }

    public static PacketContainer getEquipPacket(int id, ItemStack itemStack) {
        PacketContainer equipPacket = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        equipPacket.getIntegers().write(0, (Object)id);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)itemStack));
        equipPacket.getSlotStackPairLists().write(0, pairs);
        return equipPacket;
    }

    public static void sendAnimationToPlayer(Location location, Player player, String key, int time) {
        int id = new Random().nextInt(Integer.MAX_VALUE);
        Item item = CustomFishing.getInstance().getEffectManager().getUtilItem(key);
        if (item == null) {
            return;
        }
        CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getSpawnPacket(id, location.clone().subtract(0.0, 1.0, 0.0)));
        CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getMetaPacket(id));
        CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getEquipPacket(id, ItemStackUtils.getFromItem(item)));
        CustomFishing.getInstance().getScheduler().runTaskAsyncLater(() -> CustomFishing.getProtocolManager().sendServerPacket(player, ArmorStandUtils.getDestroyPacket(id)), (long)time * 50L, TimeUnit.MILLISECONDS);
    }
}

