/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import java.util.ArrayList;
import net.momirealms.customfishing.helper.Log;
import net.momirealms.customfishing.util.AdventureUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.configuration.file.YamlConfiguration;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisUtils {
    private static JedisPool jedisPool;

    public static Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static void initializeRedis(YamlConfiguration configuration) {
        Jedis jedis;
        int i;
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setTestWhileIdle(true);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(30000L);
        jedisPoolConfig.setNumTestsPerEvictionRun(-1);
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)configuration.getInt("Redis.MinEvictableIdleTimeMillis", 1800000));
        jedisPoolConfig.setMaxTotal(configuration.getInt("Redis.MaxTotal", 8));
        jedisPoolConfig.setMaxIdle(configuration.getInt("Redis.MaxIdle", 8));
        jedisPoolConfig.setMinIdle(configuration.getInt("Redis.MinIdle", 1));
        jedisPoolConfig.setMaxWaitMillis((long)configuration.getInt("redis.MaxWaitMillis"));
        jedisPool = configuration.getString("Redis.password") != null ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, configuration.getString("Redis.host", "localhost"), configuration.getInt("Redis.port", 6379), 2000, configuration.getString("Redis.password")) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, configuration.getString("Redis.host", "localhost"), configuration.getInt("Redis.port", 6379));
        AdventureUtils.consoleMessage("[CustomFishing] <white>Redis Server Connected!");
        ArrayList<Jedis> minIdleJedisList = new ArrayList<Jedis>(jedisPoolConfig.getMinIdle());
        for (i = 0; i < jedisPoolConfig.getMinIdle(); ++i) {
            try {
                jedis = jedisPool.getResource();
                minIdleJedisList.add(jedis);
                jedis.ping();
                continue;
            }
            catch (Exception e) {
                Log.warn(e.getMessage());
            }
        }
        for (i = 0; i < jedisPoolConfig.getMinIdle(); ++i) {
            try {
                jedis = (Jedis)minIdleJedisList.get(i);
                jedis.close();
                continue;
            }
            catch (Exception e) {
                Log.warn(e.getMessage());
            }
        }
    }

    public static void closePool() {
        if (jedisPool != null) {
            jedisPool.close();
            jedisPool = null;
        }
    }

    public static boolean isPoolEnabled() {
        return jedisPool != null && !jedisPool.isClosed();
    }
}

