/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTItem;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTList;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.NBTListCompound;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.iface.ReadWriteNBT;
import org.bukkit.configuration.MemorySection;
import org.bukkit.inventory.ItemStack;

public class NBTUtils {
    public static NBTItem setNBTToItemStack(Map<String, Object> nbt, ItemStack itemStack) {
        NBTItem nbtItem = new NBTItem(itemStack);
        NBTUtils.setTags(nbt, nbtItem);
        return nbtItem;
    }

    public static void setTags(Map<String, Object> map, NBTCompound nbtCompound) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof MemorySection) {
                MemorySection memorySection = (MemorySection)value;
                NBTUtils.setTags(memorySection.getValues(false), nbtCompound.addCompound(key));
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object o : list) {
                    if (o instanceof String) {
                        String stringValue = (String)o;
                        NBTUtils.setListValue(key, stringValue, nbtCompound);
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    Map mapValue = (Map)o;
                    NBTListCompound nbtListCompound = nbtCompound.getCompoundList(key).addCompound();
                    NBTUtils.setTags(mapValue, nbtListCompound);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            String stringValue = (String)value;
            NBTUtils.setSingleValue(key, stringValue, nbtCompound);
        }
    }

    private static void setListValue(String key, String value, NBTCompound nbtCompound) {
        String[] parts = NBTUtils.getTypeAndData(value);
        String type = parts[0];
        String data = parts[1];
        switch (type) {
            case "String": {
                ((NBTList)nbtCompound.getStringList(key)).add(data);
                break;
            }
            case "UUID": {
                ((NBTList)nbtCompound.getUUIDList(key)).add(UUID.fromString(data));
                break;
            }
            case "Double": {
                ((NBTList)nbtCompound.getDoubleList(key)).add(Double.valueOf(data));
                break;
            }
            case "Long": {
                ((NBTList)nbtCompound.getLongList(key)).add(Long.valueOf(data));
                break;
            }
            case "Float": {
                ((NBTList)nbtCompound.getFloatList(key)).add(Float.valueOf(data));
                break;
            }
            case "Int": {
                ((NBTList)nbtCompound.getIntegerList(key)).add(Integer.valueOf(data));
                break;
            }
            case "IntArray": {
                String[] split = data.replace("[", "").replace("]", "").replaceAll("\\s", "").split(",");
                int[] array = Arrays.stream(split).mapToInt(Integer::parseInt).toArray();
                ((NBTList)nbtCompound.getIntArrayList(key)).add(array);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value type: " + type);
            }
        }
    }

    private static void setSingleValue(String key, String value, NBTCompound nbtCompound) {
        String[] parts = NBTUtils.getTypeAndData(value);
        String type = parts[0];
        String data = parts[1];
        switch (type) {
            case "Int": {
                nbtCompound.setInteger(key, Integer.valueOf(data));
                break;
            }
            case "String": {
                nbtCompound.setString(key, data);
                break;
            }
            case "Long": {
                nbtCompound.setLong(key, Long.valueOf(data));
                break;
            }
            case "Float": {
                nbtCompound.setFloat(key, Float.valueOf(data));
                break;
            }
            case "Double": {
                nbtCompound.setDouble(key, Double.valueOf(data));
                break;
            }
            case "Short": {
                nbtCompound.setShort(key, Short.valueOf(data));
                break;
            }
            case "Boolean": {
                nbtCompound.setBoolean(key, Boolean.valueOf(data));
                break;
            }
            case "UUID": {
                nbtCompound.setUUID(key, UUID.nameUUIDFromBytes(data.getBytes()));
                break;
            }
            case "Byte": {
                nbtCompound.setByte(key, Byte.valueOf(data));
                break;
            }
            case "ByteArray": {
                String[] split = NBTUtils.splitValue(value);
                byte[] bytes = new byte[split.length];
                for (int i = 0; i < split.length; ++i) {
                    bytes[i] = Byte.parseByte(split[i]);
                }
                nbtCompound.setByteArray(key, bytes);
                break;
            }
            case "IntArray": {
                String[] split = NBTUtils.splitValue(value);
                int[] array = Arrays.stream(split).mapToInt(Integer::parseInt).toArray();
                nbtCompound.setIntArray(key, array);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value type: " + type);
            }
        }
    }

    public static Map<String, Object> compoundToMap(ReadWriteNBT nbtCompound) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        block22: for (String key : nbtCompound.getKeys()) {
            switch (nbtCompound.getType(key)) {
                case NBTTagByte: {
                    map.put(key, "(Byte) " + nbtCompound.getByte(key));
                    break;
                }
                case NBTTagInt: {
                    map.put(key, "(Int) " + nbtCompound.getInteger(key));
                    break;
                }
                case NBTTagDouble: {
                    map.put(key, "(Double) " + nbtCompound.getDouble(key));
                    break;
                }
                case NBTTagLong: {
                    map.put(key, "(Long) " + nbtCompound.getLong(key));
                    break;
                }
                case NBTTagFloat: {
                    map.put(key, "(Float) " + nbtCompound.getFloat(key));
                    break;
                }
                case NBTTagShort: {
                    map.put(key, "(Short) " + nbtCompound.getShort(key));
                    break;
                }
                case NBTTagString: {
                    map.put(key, "(String) " + nbtCompound.getString(key));
                    break;
                }
                case NBTTagByteArray: {
                    map.put(key, "(ByteArray) " + Arrays.toString(nbtCompound.getByteArray(key)));
                    break;
                }
                case NBTTagIntArray: {
                    map.put(key, "(IntArray) " + Arrays.toString(nbtCompound.getIntArray(key)));
                    break;
                }
                case NBTTagCompound: {
                    Map<String, Object> map1 = NBTUtils.compoundToMap(nbtCompound.getCompound(key));
                    if (map1.size() == 0) continue block22;
                    map.put(key, map1);
                    break;
                }
                case NBTTagList: {
                    ArrayList list = new ArrayList();
                    switch (nbtCompound.getListType(key)) {
                        case NBTTagCompound: {
                            nbtCompound.getCompoundList(key).forEach(a -> list.add(NBTUtils.compoundToMap(a)));
                            break;
                        }
                        case NBTTagInt: {
                            nbtCompound.getIntegerList(key).forEach(a -> list.add("(Int) " + a));
                            break;
                        }
                        case NBTTagDouble: {
                            nbtCompound.getDoubleList(key).forEach(a -> list.add("(Double) " + a));
                            break;
                        }
                        case NBTTagString: {
                            nbtCompound.getStringList(key).forEach(a -> list.add("(String) " + a));
                            break;
                        }
                        case NBTTagFloat: {
                            nbtCompound.getFloatList(key).forEach(a -> list.add("(Float) " + a));
                            break;
                        }
                        case NBTTagLong: {
                            nbtCompound.getLongList(key).forEach(a -> list.add("(Long) " + a));
                            break;
                        }
                        case NBTTagIntArray: {
                            nbtCompound.getIntArrayList(key).forEach(a -> list.add("(IntArray) " + Arrays.toString(a)));
                        }
                    }
                    if (list.size() == 0) break;
                    map.put(key, list);
                }
            }
        }
        return map;
    }

    private static String[] getTypeAndData(String str) {
        String[] parts = str.split("\\s+", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid value format: " + str);
        }
        String type = parts[0].substring(1, parts[0].length() - 1);
        String data = parts[1];
        return new String[]{type, data};
    }

    private static String[] splitValue(String value) {
        return value.substring(value.indexOf(91) + 1, value.lastIndexOf(93)).replaceAll("\\s", "").split(",");
    }
}

