/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.entity;

import com.plotsquared.bukkit.entity.AgeableStats;
import com.plotsquared.bukkit.entity.ArmorStandStats;
import com.plotsquared.bukkit.entity.EntityBaseStats;
import com.plotsquared.bukkit.entity.EntityWrapper;
import com.plotsquared.bukkit.entity.HorseStats;
import com.plotsquared.bukkit.entity.LivingEntityStats;
import com.plotsquared.bukkit.entity.TameableStats;
import com.plotsquared.core.configuration.Settings;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Art;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public final class ReplicatingEntityWrapper
extends EntityWrapper {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ReplicatingEntityWrapper.class.getSimpleName()));
    private final short depth;
    private final int hash;
    private final EntityBaseStats base = new EntityBaseStats();
    private ItemStack[] inventory;
    private ItemStack stack;
    private byte dataByte;
    private byte dataByte2;
    private String dataString;
    private LivingEntityStats lived;
    private AgeableStats aged;
    private TameableStats tamed;
    private ArmorStandStats stand;
    private HorseStats horse;
    private boolean noGravity;

    public ReplicatingEntityWrapper(Entity entity, short s) {
        super(entity);
        this.hash = entity.getEntityId();
        this.depth = s;
        if (s == 0) {
            return;
        }
        List list = entity.getPassengers();
        if (list.size() > 0) {
            this.base.passenger = new ReplicatingEntityWrapper((Entity)list.get(0), s);
        }
        this.base.fall = entity.getFallDistance();
        this.base.fire = (short)entity.getFireTicks();
        this.base.age = entity.getTicksLived();
        Vector vector = entity.getVelocity();
        this.base.vX = vector.getX();
        this.base.vY = vector.getY();
        this.base.vZ = vector.getZ();
        if (s == 1) {
            return;
        }
        if (!entity.hasGravity()) {
            this.noGravity = true;
        }
        switch (entity.getType().toString()) {
            case "BOAT": {
                Boat boat = (Boat)entity;
                this.dataByte = this.getOrdinal(TreeSpecies.values(), boat.getWoodType());
                return;
            }
            case "ARROW": 
            case "EGG": 
            case "ENDER_CRYSTAL": 
            case "ENDER_PEARL": 
            case "ENDER_SIGNAL": 
            case "EXPERIENCE_ORB": 
            case "FALLING_BLOCK": 
            case "FIREBALL": 
            case "FIREWORK": 
            case "FISHING_HOOK": 
            case "LEASH_HITCH": 
            case "LIGHTNING": 
            case "MINECART": 
            case "MINECART_COMMAND": 
            case "MINECART_MOB_SPAWNER": 
            case "MINECART_TNT": 
            case "PLAYER": 
            case "PRIMED_TNT": 
            case "SLIME": 
            case "SMALL_FIREBALL": 
            case "SNOWBALL": 
            case "MINECART_FURNACE": 
            case "SPLASH_POTION": 
            case "THROWN_EXP_BOTTLE": 
            case "WITHER_SKULL": 
            case "UNKNOWN": 
            case "SPECTRAL_ARROW": 
            case "SHULKER_BULLET": 
            case "DRAGON_FIREBALL": 
            case "AREA_EFFECT_CLOUD": 
            case "TRIDENT": 
            case "LLAMA_SPIT": {
                return;
            }
            case "DROPPED_ITEM": {
                Item item = (Item)entity;
                this.stack = item.getItemStack();
                return;
            }
            case "ITEM_FRAME": {
                this.x = Math.floor(this.getX());
                this.y = Math.floor(this.getY());
                this.z = Math.floor(this.getZ());
                ItemFrame itemFrame = (ItemFrame)entity;
                this.dataByte = this.getOrdinal(Rotation.values(), itemFrame.getRotation());
                this.stack = itemFrame.getItem().clone();
                return;
            }
            case "PAINTING": {
                this.x = Math.floor(this.getX());
                this.y = Math.floor(this.getY());
                this.z = Math.floor(this.getZ());
                Painting painting = (Painting)entity;
                Art art = painting.getArt();
                this.dataByte = this.getOrdinal(BlockFace.values(), painting.getFacing());
                int n = art.getBlockHeight();
                if (n % 2 == 0) {
                    this.y -= 1.0;
                }
                this.dataString = art.name();
                return;
            }
            case "MINECART_CHEST": 
            case "MINECART_HOPPER": {
                this.storeInventory((InventoryHolder)entity);
                return;
            }
            case "HORSE": 
            case "DONKEY": 
            case "LLAMA": 
            case "MULE": 
            case "SKELETON_HORSE": {
                AbstractHorse abstractHorse = (AbstractHorse)entity;
                this.horse = new HorseStats();
                this.horse.jump = abstractHorse.getJumpStrength();
                if (abstractHorse instanceof ChestedHorse) {
                    ChestedHorse chestedHorse = (ChestedHorse)abstractHorse;
                    this.horse.chest = chestedHorse.isCarryingChest();
                }
                this.storeTameable((Tameable)abstractHorse);
                this.storeBreedable((Breedable)abstractHorse);
                this.storeLiving((LivingEntity)abstractHorse);
                this.storeInventory((InventoryHolder)abstractHorse);
                return;
            }
            case "WOLF": 
            case "OCELOT": {
                this.storeTameable((Tameable)entity);
                this.storeBreedable((Breedable)entity);
                this.storeLiving((LivingEntity)entity);
                return;
            }
            case "SHEEP": {
                Sheep sheep = (Sheep)entity;
                this.dataByte = sheep.isSheared() ? (byte)1 : 0;
                this.dataByte2 = sheep.getColor().getDyeData();
                this.storeBreedable((Breedable)sheep);
                this.storeLiving((LivingEntity)sheep);
                return;
            }
            case "VILLAGER": 
            case "CHICKEN": 
            case "COW": 
            case "MUSHROOM_COW": 
            case "PIG": 
            case "TURTLE": 
            case "POLAR_BEAR": {
                this.storeBreedable((Breedable)entity);
                this.storeLiving((LivingEntity)entity);
                return;
            }
            case "RABBIT": {
                this.dataByte = this.getOrdinal(Rabbit.Type.values(), ((Rabbit)entity).getRabbitType());
                this.storeBreedable((Breedable)entity);
                this.storeLiving((LivingEntity)entity);
                return;
            }
            case "ARMOR_STAND": {
                ArmorStand armorStand = (ArmorStand)entity;
                this.inventory = new ItemStack[]{armorStand.getItemInHand().clone(), armorStand.getHelmet().clone(), armorStand.getChestplate().clone(), armorStand.getLeggings().clone(), armorStand.getBoots().clone()};
                this.storeLiving((LivingEntity)armorStand);
                this.stand = new ArmorStandStats();
                EulerAngle eulerAngle = armorStand.getHeadPose();
                this.stand.head[0] = (float)eulerAngle.getX();
                this.stand.head[1] = (float)eulerAngle.getY();
                this.stand.head[2] = (float)eulerAngle.getZ();
                EulerAngle eulerAngle2 = armorStand.getBodyPose();
                this.stand.body[0] = (float)eulerAngle2.getX();
                this.stand.body[1] = (float)eulerAngle2.getY();
                this.stand.body[2] = (float)eulerAngle2.getZ();
                EulerAngle eulerAngle3 = armorStand.getLeftLegPose();
                this.stand.leftLeg[0] = (float)eulerAngle3.getX();
                this.stand.leftLeg[1] = (float)eulerAngle3.getY();
                this.stand.leftLeg[2] = (float)eulerAngle3.getZ();
                EulerAngle eulerAngle4 = armorStand.getRightLegPose();
                this.stand.rightLeg[0] = (float)eulerAngle4.getX();
                this.stand.rightLeg[1] = (float)eulerAngle4.getY();
                this.stand.rightLeg[2] = (float)eulerAngle4.getZ();
                EulerAngle eulerAngle5 = armorStand.getLeftArmPose();
                this.stand.leftArm[0] = (float)eulerAngle5.getX();
                this.stand.leftArm[1] = (float)eulerAngle5.getY();
                this.stand.leftArm[2] = (float)eulerAngle5.getZ();
                EulerAngle eulerAngle6 = armorStand.getRightArmPose();
                this.stand.rightArm[0] = (float)eulerAngle6.getX();
                this.stand.rightArm[1] = (float)eulerAngle6.getY();
                this.stand.rightArm[2] = (float)eulerAngle6.getZ();
                if (armorStand.hasArms()) {
                    this.stand.arms = true;
                }
                if (!armorStand.hasBasePlate()) {
                    this.stand.noPlate = true;
                }
                if (!armorStand.isVisible()) {
                    this.stand.invisible = true;
                }
                if (armorStand.isSmall()) {
                    this.stand.small = true;
                }
                return;
            }
            case "ENDERMITE": {
                return;
            }
            case "BAT": {
                this.dataByte = ((Bat)entity).isAwake() ? (byte)1 : 0;
                return;
            }
            case "ENDER_DRAGON": {
                EnderDragon enderDragon = (EnderDragon)entity;
                this.dataByte = (byte)enderDragon.getPhase().ordinal();
                return;
            }
            case "SKELETON": 
            case "WITHER_SKELETON": 
            case "GUARDIAN": 
            case "ELDER_GUARDIAN": 
            case "GHAST": 
            case "MAGMA_CUBE": 
            case "SQUID": 
            case "PIG_ZOMBIE": 
            case "HOGLIN": 
            case "ZOMBIFIED_PIGLIN": 
            case "PIGLIN": 
            case "PIGLIN_BRUTE": 
            case "ZOMBIE": 
            case "WITHER": 
            case "WITCH": 
            case "SPIDER": 
            case "CAVE_SPIDER": 
            case "SILVERFISH": 
            case "GIANT": 
            case "ENDERMAN": 
            case "CREEPER": 
            case "BLAZE": 
            case "SHULKER": 
            case "SNOWMAN": {
                this.storeLiving((LivingEntity)entity);
                return;
            }
            case "IRON_GOLEM": {
                this.dataByte = ((IronGolem)entity).isPlayerCreated() ? (byte)1 : 0;
                this.storeLiving((LivingEntity)entity);
            }
        }
    }

    public boolean equals(Object object) {
        return this.hash == object.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public void storeInventory(InventoryHolder inventoryHolder) {
        this.inventory = (ItemStack[])inventoryHolder.getInventory().getContents().clone();
    }

    void restoreLiving(LivingEntity livingEntity) {
        livingEntity.setCanPickupItems(this.lived.loot);
        if (this.lived.name != null) {
            livingEntity.setCustomName(this.lived.name);
            livingEntity.setCustomNameVisible(this.lived.visible);
        }
        if (this.lived.potions != null && !this.lived.potions.isEmpty()) {
            livingEntity.addPotionEffects(this.lived.potions);
        }
        livingEntity.setRemainingAir((int)this.lived.air);
        livingEntity.setRemoveWhenFarAway(this.lived.persistent);
        if (this.lived.equipped) {
            this.restoreEquipment(livingEntity);
        }
        if (this.lived.leashed) {
            // empty if block
        }
    }

    void restoreEquipment(LivingEntity livingEntity) {
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        if (entityEquipment != null) {
            entityEquipment.setItemInMainHand(this.lived.mainHand);
            entityEquipment.setItemInOffHand(this.lived.offHand);
            entityEquipment.setHelmet(this.lived.helmet);
            entityEquipment.setChestplate(this.lived.chestplate);
            entityEquipment.setLeggings(this.lived.leggings);
            entityEquipment.setBoots(this.lived.boots);
        }
    }

    private void restoreInventory(InventoryHolder inventoryHolder) {
        try {
            inventoryHolder.getInventory().setContents(this.inventory);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Failed to restore inventory", (Throwable)illegalArgumentException);
        }
    }

    private void storeLiving(LivingEntity livingEntity) {
        EntityEquipment entityEquipment;
        this.lived = new LivingEntityStats();
        this.lived.potions = livingEntity.getActivePotionEffects();
        this.lived.loot = livingEntity.getCanPickupItems();
        this.lived.name = livingEntity.getCustomName();
        this.lived.visible = livingEntity.isCustomNameVisible();
        this.lived.health = (float)livingEntity.getHealth();
        this.lived.air = (short)livingEntity.getRemainingAir();
        this.lived.persistent = livingEntity.getRemoveWhenFarAway();
        this.lived.leashed = livingEntity.isLeashed();
        if (this.lived.leashed) {
            entityEquipment = livingEntity.getLeashHolder().getLocation();
            this.lived.leashX = (short)(this.getX() - (double)entityEquipment.getBlockX());
            this.lived.leashY = (short)(this.getY() - (double)entityEquipment.getBlockY());
            this.lived.leashZ = (short)(this.getZ() - (double)entityEquipment.getBlockZ());
        }
        boolean bl = this.lived.equipped = (entityEquipment = livingEntity.getEquipment()) != null;
        if (this.lived.equipped) {
            this.storeEquipment(entityEquipment);
        }
    }

    void storeEquipment(EntityEquipment entityEquipment) {
        this.lived.mainHand = entityEquipment.getItemInMainHand().clone();
        this.lived.offHand = entityEquipment.getItemInOffHand().clone();
        this.lived.boots = entityEquipment.getBoots().clone();
        this.lived.leggings = entityEquipment.getLeggings().clone();
        this.lived.chestplate = entityEquipment.getChestplate().clone();
        this.lived.helmet = entityEquipment.getHelmet().clone();
    }

    private void restoreTameable(Tameable tameable) {
        if (this.tamed.tamed && this.tamed.owner != null) {
            tameable.setTamed(true);
            tameable.setOwner(this.tamed.owner);
        }
    }

    @Deprecated(forRemoval=true, since="7.1.0")
    private void restoreAgeable(Ageable ageable) {
        if (!this.aged.adult) {
            ageable.setBaby();
        }
        ageable.setAgeLock(this.aged.locked);
        if (this.aged.age > 0) {
            ageable.setAge(this.aged.age);
        }
    }

    @Deprecated(forRemoval=true, since="7.1.0")
    public void storeAgeable(Ageable ageable) {
        this.aged = new AgeableStats();
        this.aged.age = ageable.getAge();
        this.aged.locked = ageable.getAgeLock();
        this.aged.adult = ageable.isAdult();
    }

    private void restoreBreedable(Breedable breedable) {
        if (!this.aged.adult) {
            breedable.setBaby();
        }
        breedable.setAgeLock(this.aged.locked);
        if (this.aged.age > 0) {
            breedable.setAge(this.aged.age);
        }
    }

    private void storeBreedable(Breedable breedable) {
        this.aged = new AgeableStats();
        this.aged.age = breedable.getAge();
        this.aged.locked = breedable.getAgeLock();
        this.aged.adult = breedable.isAdult();
    }

    public void storeTameable(Tameable tameable) {
        this.tamed = new TameableStats();
        this.tamed.owner = tameable.getOwner();
        this.tamed.tamed = tameable.isTamed();
    }

    @Override
    public Entity spawn(World world, int n, int n2) {
        Entity entity;
        Location location = new Location(world, this.getX() + (double)n, this.getY(), this.z + (double)n2);
        location.setYaw(this.yaw);
        location.setPitch(this.pitch);
        if (!this.getType().isSpawnable()) {
            return null;
        }
        switch (this.getType().toString()) {
            case "DROPPED_ITEM": {
                return world.dropItem(location, this.stack);
            }
            case "PLAYER": 
            case "LEASH_HITCH": {
                return null;
            }
            case "ITEM_FRAME": {
                entity = world.spawn(location, ItemFrame.class);
                break;
            }
            case "PAINTING": {
                entity = world.spawn(location, Painting.class);
                break;
            }
            default: {
                entity = world.spawnEntity(location, this.getType());
            }
        }
        if (this.depth == 0) {
            return entity;
        }
        if (this.base.passenger != null) {
            try {
                entity.addPassenger(this.base.passenger.spawn(world, n, n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.base.fall != 0.0f) {
            entity.setFallDistance(this.base.fall);
        }
        if (this.base.fire != 0) {
            entity.setFireTicks((int)this.base.fire);
        }
        if (this.base.age != 0) {
            entity.setTicksLived(this.base.age);
        }
        entity.setVelocity(new Vector(this.base.vX, this.base.vY, this.base.vZ));
        if (this.depth == 1) {
            return entity;
        }
        if (this.noGravity) {
            entity.setGravity(false);
        }
        switch (entity.getType().toString()) {
            case "BOAT": {
                Boat boat = (Boat)entity;
                boat.setWoodType(TreeSpecies.values()[this.dataByte]);
                return entity;
            }
            case "SLIME": {
                ((Slime)entity).setSize((int)this.dataByte);
                return entity;
            }
            case "ARROW": 
            case "EGG": 
            case "ENDER_CRYSTAL": 
            case "ENDER_PEARL": 
            case "ENDER_SIGNAL": 
            case "DROPPED_ITEM": 
            case "EXPERIENCE_ORB": 
            case "FALLING_BLOCK": 
            case "FIREBALL": 
            case "FIREWORK": 
            case "FISHING_HOOK": 
            case "LEASH_HITCH": 
            case "LIGHTNING": 
            case "MINECART": 
            case "MINECART_COMMAND": 
            case "MINECART_MOB_SPAWNER": 
            case "MINECART_TNT": 
            case "PLAYER": 
            case "PRIMED_TNT": 
            case "SMALL_FIREBALL": 
            case "SNOWBALL": 
            case "SPLASH_POTION": 
            case "THROWN_EXP_BOTTLE": 
            case "SPECTRAL_ARROW": 
            case "SHULKER_BULLET": 
            case "AREA_EFFECT_CLOUD": 
            case "DRAGON_FIREBALL": 
            case "WITHER_SKULL": 
            case "MINECART_FURNACE": 
            case "LLAMA_SPIT": 
            case "TRIDENT": 
            case "UNKNOWN": {
                return entity;
            }
            case "ITEM_FRAME": {
                ItemFrame itemFrame = (ItemFrame)entity;
                itemFrame.setRotation(Rotation.values()[this.dataByte]);
                itemFrame.setItem(this.stack);
                return entity;
            }
            case "PAINTING": {
                Painting painting = (Painting)entity;
                painting.setFacingDirection(BlockFace.values()[this.dataByte], true);
                painting.setArt(Art.getByName((String)this.dataString), true);
                return entity;
            }
            case "MINECART_CHEST": 
            case "MINECART_HOPPER": {
                this.restoreInventory((InventoryHolder)entity);
                return entity;
            }
            case "HORSE": 
            case "LLAMA": 
            case "SKELETON_HORSE": 
            case "DONKEY": 
            case "MULE": {
                AbstractHorse abstractHorse = (AbstractHorse)entity;
                abstractHorse.setJumpStrength(this.horse.jump);
                if (abstractHorse instanceof ChestedHorse) {
                    ((ChestedHorse)abstractHorse).setCarryingChest(this.horse.chest);
                }
                this.restoreTameable((Tameable)abstractHorse);
                this.restoreBreedable((Breedable)abstractHorse);
                this.restoreLiving((LivingEntity)abstractHorse);
                this.restoreInventory((InventoryHolder)abstractHorse);
                return entity;
            }
            case "WOLF": 
            case "OCELOT": {
                this.restoreTameable((Tameable)entity);
                this.restoreBreedable((Breedable)entity);
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
            case "SHEEP": {
                Sheep sheep = (Sheep)entity;
                if (this.dataByte == 1) {
                    sheep.setSheared(true);
                }
                if (this.dataByte2 != 0) {
                    sheep.setColor(DyeColor.getByDyeData((byte)this.dataByte2));
                }
                this.restoreBreedable((Breedable)sheep);
                this.restoreLiving((LivingEntity)sheep);
                return sheep;
            }
            case "VILLAGER": 
            case "CHICKEN": 
            case "COW": 
            case "TURTLE": 
            case "POLAR_BEAR": 
            case "MUSHROOM_COW": 
            case "PIG": {
                this.restoreBreedable((Breedable)entity);
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
            case "RABBIT": {
                if (this.dataByte != 0) {
                    ((Rabbit)entity).setRabbitType(Rabbit.Type.values()[this.dataByte]);
                }
                this.restoreBreedable((Breedable)entity);
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
            case "ARMOR_STAND": {
                EulerAngle eulerAngle;
                ArmorStand armorStand = (ArmorStand)entity;
                if (this.inventory[0] != null) {
                    armorStand.setItemInHand(this.inventory[0]);
                }
                if (this.inventory[1] != null) {
                    armorStand.setHelmet(this.inventory[1]);
                }
                if (this.inventory[2] != null) {
                    armorStand.setChestplate(this.inventory[2]);
                }
                if (this.inventory[3] != null) {
                    armorStand.setLeggings(this.inventory[3]);
                }
                if (this.inventory[4] != null) {
                    armorStand.setBoots(this.inventory[4]);
                }
                if (this.stand.head[0] != 0.0f || this.stand.head[1] != 0.0f || this.stand.head[2] != 0.0f) {
                    eulerAngle = new EulerAngle((double)this.stand.head[0], (double)this.stand.head[1], (double)this.stand.head[2]);
                    armorStand.setHeadPose(eulerAngle);
                }
                if (this.stand.body[0] != 0.0f || this.stand.body[1] != 0.0f || this.stand.body[2] != 0.0f) {
                    eulerAngle = new EulerAngle((double)this.stand.body[0], (double)this.stand.body[1], (double)this.stand.body[2]);
                    armorStand.setBodyPose(eulerAngle);
                }
                if (this.stand.leftLeg[0] != 0.0f || this.stand.leftLeg[1] != 0.0f || this.stand.leftLeg[2] != 0.0f) {
                    eulerAngle = new EulerAngle((double)this.stand.leftLeg[0], (double)this.stand.leftLeg[1], (double)this.stand.leftLeg[2]);
                    armorStand.setLeftLegPose(eulerAngle);
                }
                if (this.stand.rightLeg[0] != 0.0f || this.stand.rightLeg[1] != 0.0f || this.stand.rightLeg[2] != 0.0f) {
                    eulerAngle = new EulerAngle((double)this.stand.rightLeg[0], (double)this.stand.rightLeg[1], (double)this.stand.rightLeg[2]);
                    armorStand.setRightLegPose(eulerAngle);
                }
                if (this.stand.leftArm[0] != 0.0f || this.stand.leftArm[1] != 0.0f || this.stand.leftArm[2] != 0.0f) {
                    eulerAngle = new EulerAngle((double)this.stand.leftArm[0], (double)this.stand.leftArm[1], (double)this.stand.leftArm[2]);
                    armorStand.setLeftArmPose(eulerAngle);
                }
                if (this.stand.rightArm[0] != 0.0f || this.stand.rightArm[1] != 0.0f || this.stand.rightArm[2] != 0.0f) {
                    eulerAngle = new EulerAngle((double)this.stand.rightArm[0], (double)this.stand.rightArm[1], (double)this.stand.rightArm[2]);
                    armorStand.setRightArmPose(eulerAngle);
                }
                if (this.stand.invisible) {
                    armorStand.setVisible(false);
                }
                if (this.stand.arms) {
                    armorStand.setArms(true);
                }
                if (this.stand.noPlate) {
                    armorStand.setBasePlate(false);
                }
                if (this.stand.small) {
                    armorStand.setSmall(true);
                }
                this.restoreLiving((LivingEntity)armorStand);
                return armorStand;
            }
            case "BAT": {
                if (this.dataByte != 0) {
                    ((Bat)entity).setAwake(true);
                }
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
            case "ENDER_DRAGON": {
                if (this.dataByte != 0) {
                    ((EnderDragon)entity).setPhase(EnderDragon.Phase.values()[this.dataByte]);
                }
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
            case "ENDERMITE": 
            case "GHAST": 
            case "MAGMA_CUBE": 
            case "SQUID": 
            case "PIG_ZOMBIE": 
            case "HOGLIN": 
            case "PIGLIN": 
            case "ZOMBIFIED_PIGLIN": 
            case "PIGLIN_BRUTE": 
            case "ZOMBIE": 
            case "WITHER": 
            case "WITCH": 
            case "SPIDER": 
            case "CAVE_SPIDER": 
            case "SILVERFISH": 
            case "GIANT": 
            case "ENDERMAN": 
            case "CREEPER": 
            case "BLAZE": 
            case "SNOWMAN": 
            case "SHULKER": 
            case "GUARDIAN": 
            case "ELDER_GUARDIAN": 
            case "SKELETON": 
            case "WITHER_SKELETON": {
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
            case "IRON_GOLEM": {
                if (this.dataByte != 0) {
                    ((IronGolem)entity).setPlayerCreated(true);
                }
                this.restoreLiving((LivingEntity)entity);
                return entity;
            }
        }
        if (Settings.DEBUG) {
            LOGGER.info("Could not identify entity: {}", (Object)entity.getType());
        }
        return entity;
    }

    @Override
    public void saveEntity() {
    }

    private byte getOrdinal(Object[] objectArray, Object object) {
        for (byte by = 0; by < objectArray.length; by = (byte)(by + 1)) {
            if (!objectArray[by].equals(object)) continue;
            return by;
        }
        return 0;
    }
}

