/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.entity;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.entity.EntityWrapper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class TeleportEntityWrapper
extends EntityWrapper {
    private Location oldLocation;
    private boolean gravityOld;
    private boolean invulnerableOld;
    private int fireTicksOld;
    private int livingTicksOld;

    public TeleportEntityWrapper(Entity entity) {
        super(entity);
    }

    @Override
    public Entity spawn(World world, int n, int n2) {
        if (!this.getEntity().getLocation().getChunk().equals(this.oldLocation.getChunk())) {
            Location location = this.oldLocation.clone();
            location.add((double)n, 0.0, (double)n);
            this.getEntity().teleport(location);
            this.getEntity().setGravity(this.gravityOld);
            this.getEntity().setInvulnerable(this.invulnerableOld);
            this.getEntity().setFireTicks(this.fireTicksOld);
            this.getEntity().setTicksLived(this.livingTicksOld);
            this.getEntity().removeMetadata("ps-tmp-teleport", (Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class));
        }
        return this.getEntity();
    }

    @Override
    public void saveEntity() {
        this.oldLocation = this.getEntity().hasMetadata("ps-tmp-teleport") ? (Location)this.getEntity().getMetadata("ps-tmp-teleport").get(0) : this.getEntity().getLocation();
        this.oldLocation = this.oldLocation.clone();
        this.oldLocation.setX(this.getX());
        this.oldLocation.setY(this.getY());
        this.oldLocation.setZ(this.getZ());
        this.gravityOld = this.getEntity().hasGravity();
        this.getEntity().setGravity(false);
        this.invulnerableOld = this.getEntity().isInvulnerable();
        this.getEntity().setInvulnerable(true);
        this.fireTicksOld = this.getEntity().getFireTicks();
        this.livingTicksOld = this.getEntity().getTicksLived();
        this.getEntity().setMetadata("ps-tmp-teleport", (MetadataValue)new FixedMetadataValue((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class), (Object)this.oldLocation));
        Chunk chunk = this.getNewChunk();
        this.getEntity().teleport(new Location(chunk.getWorld(), (double)(chunk.getX() << 4), 5000.0, (double)(chunk.getZ() << 4)));
    }

    private Chunk getNewChunk() {
        Chunk chunk = this.oldLocation.getChunk();
        Chunk chunk2 = null;
        Chunk[] chunkArray = chunk.getWorld().getLoadedChunks();
        int n = chunkArray.length;
        for (int i = 0; i < n; ++i) {
            Chunk chunk3 = chunkArray[i];
            if (chunk3.equals(chunk) || !chunk3.isLoaded()) continue;
            chunk2 = chunk3;
            break;
        }
        if (chunk2 == null) {
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                for (n = 0; !(n >= Integer.MAX_VALUE || (chunk2 = this.getChunkRelative(chunk, i, n)).isLoaded() || (chunk2 = this.getChunkRelative(chunk, -i, n)).isLoaded() || (chunk2 = this.getChunkRelative(chunk, i, -n)).isLoaded() || (chunk2 = this.getChunkRelative(chunk, -i, -n)).isLoaded()); ++n) {
                }
            }
        }
        return chunk2;
    }

    private Chunk getChunkRelative(Chunk chunk, int n, int n2) {
        return chunk.getWorld().getChunkAt(chunk.getX() + n, chunk.getZ() + n2);
    }
}

