/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.BlockBurnFlag;
import com.plotsquared.core.plot.flag.implementations.BlockIgnitionFlag;
import com.plotsquared.core.plot.flag.implementations.BreakFlag;
import com.plotsquared.core.plot.flag.implementations.ConcreteHardenFlag;
import com.plotsquared.core.plot.flag.implementations.CoralDryFlag;
import com.plotsquared.core.plot.flag.implementations.CropGrowFlag;
import com.plotsquared.core.plot.flag.implementations.DisablePhysicsFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.ExplosionFlag;
import com.plotsquared.core.plot.flag.implementations.GrassGrowFlag;
import com.plotsquared.core.plot.flag.implementations.IceFormFlag;
import com.plotsquared.core.plot.flag.implementations.IceMeltFlag;
import com.plotsquared.core.plot.flag.implementations.InstabreakFlag;
import com.plotsquared.core.plot.flag.implementations.KelpGrowFlag;
import com.plotsquared.core.plot.flag.implementations.LeafDecayFlag;
import com.plotsquared.core.plot.flag.implementations.LiquidFlowFlag;
import com.plotsquared.core.plot.flag.implementations.MycelGrowFlag;
import com.plotsquared.core.plot.flag.implementations.PlaceFlag;
import com.plotsquared.core.plot.flag.implementations.RedstoneFlag;
import com.plotsquared.core.plot.flag.implementations.SnowFormFlag;
import com.plotsquared.core.plot.flag.implementations.SnowMeltFlag;
import com.plotsquared.core.plot.flag.implementations.SoilDryFlag;
import com.plotsquared.core.plot.flag.implementations.VineGrowFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BlockEventListener
implements Listener {
    private static final Set<Material> PISTONS = Set.of(Material.PISTON, Material.STICKY_PISTON);
    private static final Set<Material> PHYSICS_BLOCKS = Set.of(Material.TURTLE_EGG, Material.TURTLE_SPAWN_EGG);
    private static final Set<Material> SNOW = Stream.of(Material.values()).filter(material -> material.name().contains("SNOW")).filter(Material::isBlock).collect(Collectors.toUnmodifiableSet());
    private final PlotAreaManager plotAreaManager;
    private final WorldEdit worldEdit;

    @Inject
    public BlockEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldEdit worldEdit) {
        this.plotAreaManager = plotAreaManager;
        this.worldEdit = worldEdit;
    }

    public static void sendBlockChange(org.bukkit.Location location, BlockData blockData) {
        TaskManager.runTaskLater(() -> {
            String string = location.getWorld().getName();
            int n = location.getBlockX();
            int n2 = location.getBlockZ();
            int n3 = Bukkit.getViewDistance() * 16;
            for (PlotPlayer<?> plotPlayer : PlotSquared.platform().playerManager().getPlayers()) {
                Location location2 = plotPlayer.getLocation();
                if (!location2.getWorldName().equals(string) || 16 * Math.abs(location2.getX() - n) / 16 > n3 || 16 * Math.abs(location2.getZ() - n2) / 16 > n3) continue;
                ((BukkitPlayer)plotPlayer).player.sendBlockChange(location, blockData);
            }
        }, TaskTime.ticks(3L));
    }

    @EventHandler
    public void onRedstoneEvent(BlockRedstoneEvent blockRedstoneEvent) {
        Block block = blockRedstoneEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, RedstoneFlag.class, false)) {
                blockRedstoneEvent.setNewCurrent(0);
            }
            return;
        }
        if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
            blockRedstoneEvent.setNewCurrent(0);
            plot.debug("Redstone event was cancelled because redstone = false");
            return;
        }
        if (Settings.Redstone.DISABLE_OFFLINE) {
            boolean bl = false;
            if (!DBFunc.SERVER.equals(plot.getOwner())) {
                if (plot.isMerged()) {
                    bl = true;
                    for (UUID uUID : plot.getOwners()) {
                        if (PlotSquared.platform().playerManager().getPlayerIfExists(uUID) == null) continue;
                        bl = false;
                        break;
                    }
                } else {
                    boolean bl2 = bl = PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwnerAbs()) == null;
                }
            }
            if (bl) {
                for (UUID uUID : plot.getTrusted()) {
                    if (PlotSquared.platform().playerManager().getPlayerIfExists(uUID) == null) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    blockRedstoneEvent.setNewCurrent(0);
                    plot.debug("Redstone event was cancelled because no trusted player was in the plot");
                    return;
                }
            }
        }
        if (Settings.Redstone.DISABLE_UNOCCUPIED) {
            for (PlotPlayer<?> plotPlayer : PlotSquared.platform().playerManager().getPlayers()) {
                if (!plot.equals(plotPlayer.getCurrentPlot())) continue;
                return;
            }
            blockRedstoneEvent.setNewCurrent(0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPhysicsEvent(BlockPhysicsEvent blockPhysicsEvent) {
        Directional directional;
        BlockFace blockFace;
        Plot plot;
        Block block = blockPhysicsEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot2 = plotArea.getOwnedPlotAbs(location);
        if (plot2 == null) {
            return;
        }
        if (blockPhysicsEvent.getChangedType().hasGravity() && ((Boolean)plot2.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
            blockPhysicsEvent.setCancelled(true);
            BlockEventListener.sendBlockChange(blockPhysicsEvent.getBlock().getLocation(), blockPhysicsEvent.getBlock().getBlockData());
            plot2.debug("Prevented block physics and resent block change because disable-physics = true");
            return;
        }
        if (blockPhysicsEvent.getChangedType() == Material.COMPARATOR) {
            if (!((Boolean)plot2.getFlag(RedstoneFlag.class)).booleanValue()) {
                blockPhysicsEvent.setCancelled(true);
                plot2.debug("Prevented comparator update because redstone = false");
            }
            return;
        }
        if (PHYSICS_BLOCKS.contains(blockPhysicsEvent.getChangedType())) {
            if (((Boolean)plot2.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                blockPhysicsEvent.setCancelled(true);
                plot2.debug("Prevented block physics because disable-physics = true");
            }
            return;
        }
        if (Settings.Redstone.DETECT_INVALID_EDGE_PISTONS && PISTONS.contains(block.getType()) && !plot2.equals(plot = plotArea.getOwnedPlotAbs(location = location.add((blockFace = (directional = (Directional)block.getBlockData()).getFacing()).getModX(), blockFace.getModY(), blockFace.getModZ())))) {
            blockPhysicsEvent.setCancelled(true);
            plot2.debug("Prevented piston update because of invalid edge piston detection");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockCreate(BlockPlaceEvent blockPlaceEvent) {
        Location location = BukkitUtil.adapt(blockPlaceEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Plot plot = plotArea.getPlot(location);
        if (plot != null) {
            List list;
            if (plotArea.notifyIfOutsideBuildArea(bukkitPlayer, location.getY())) {
                blockPlaceEvent.setCancelled(true);
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("height.height_limit"), TagResolver.builder().tag("minheight", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plotArea.getMinBuildHeight()))).tag("maxheight", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plotArea.getMaxBuildHeight()))).build());
                return;
            }
            if (!plot.hasOwner()) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)));
                    blockPlaceEvent.setCancelled(true);
                    return;
                }
            } else if (!plot.isAdded(bukkitPlayer.getUUID())) {
                Block block;
                list = (List)plot.getFlag(PlaceFlag.class);
                if (list != null && list.contains(BlockTypeWrapper.get(BukkitAdapter.asBlockType((Material)(block = blockPlaceEvent.getBlock()).getType())))) {
                    return;
                }
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_OTHER)));
                    blockPlaceEvent.setCancelled(true);
                    plot.debug(player.getName() + " could not place " + blockPlaceEvent.getBlock().getType() + " because of the place = false");
                    return;
                }
            } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("done.building_restricted"), new TagResolver[0]);
                blockPlaceEvent.setCancelled(true);
                return;
            }
            if (((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue() && (list = blockPlaceEvent.getBlockPlaced()).getType().hasGravity()) {
                BlockEventListener.sendBlockChange(list.getLocation(), list.getBlockData());
                plot.debug(blockPlaceEvent.getBlock().getType() + " did not fall because of disable-physics = true");
            }
        } else if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_ROAD)));
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockDestroy(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        Location location = BukkitUtil.adapt(blockBreakEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getPlot(location);
        if (plot != null) {
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            if (blockBreakEvent.getBlock().getY() == plotArea.getMinGenHeight()) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL)));
                    blockBreakEvent.setCancelled(true);
                    return;
                }
            } else if (plotArea.notifyIfOutsideBuildArea(bukkitPlayer, location.getY())) {
                blockBreakEvent.setCancelled(true);
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("height.height_limit"), TagResolver.builder().tag("minheight", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plotArea.getMinBuildHeight()))).tag("maxheight", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plotArea.getMaxBuildHeight()))).build());
                return;
            }
            if (!plot.hasOwner()) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED, true)) {
                    blockBreakEvent.setCancelled(true);
                }
                return;
            }
            if (!plot.isAdded(bukkitPlayer.getUUID())) {
                List list = (List)plot.getFlag(BreakFlag.class);
                Block block = blockBreakEvent.getBlock();
                BlockType blockType = BukkitAdapter.asBlockType((Material)block.getType());
                for (BlockTypeWrapper blockTypeWrapper : list) {
                    if (!blockTypeWrapper.accepts(blockType)) continue;
                    return;
                }
                if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    return;
                }
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_OTHER)));
                blockBreakEvent.setCancelled(true);
            } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("done.building_restricted"), new TagResolver[0]);
                blockBreakEvent.setCancelled(true);
                return;
            }
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
            return;
        }
        if (this.worldEdit != null && bukkitPlayer.getAttribute("worldedit") && player.getInventory().getItemInMainHand().getType() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
            return;
        }
        bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_DESTROY_ROAD)));
        blockBreakEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent blockSpreadEvent) {
        Block block = blockSpreadEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            blockSpreadEvent.setCancelled(true);
            return;
        }
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        switch (blockSpreadEvent.getSource().getType().toString()) {
            case "GRASS_BLOCK": {
                if (((Boolean)plot.getFlag(GrassGrowFlag.class)).booleanValue()) break;
                plot.debug("Grass could not grow because grass-grow = false");
                blockSpreadEvent.setCancelled(true);
                break;
            }
            case "MYCELIUM": {
                if (((Boolean)plot.getFlag(MycelGrowFlag.class)).booleanValue()) break;
                plot.debug("Mycelium could not grow because mycel-grow = false");
                blockSpreadEvent.setCancelled(true);
                break;
            }
            case "WEEPING_VINES": 
            case "TWISTING_VINES": 
            case "CAVE_VINES": 
            case "VINE": 
            case "GLOW_BERRIES": {
                if (((Boolean)plot.getFlag(VineGrowFlag.class)).booleanValue()) break;
                plot.debug("Vine could not grow because vine-grow = false");
                blockSpreadEvent.setCancelled(true);
                break;
            }
            case "KELP": {
                if (!((Boolean)plot.getFlag(KelpGrowFlag.class)).booleanValue()) {
                    plot.debug("Kelp could not grow because kelp-grow = false");
                    blockSpreadEvent.setCancelled(true);
                }
            }
            case "BUDDING_AMETHYST": {
                if (((Boolean)plot.getFlag(CropGrowFlag.class)).booleanValue()) break;
                plot.debug("Amethyst clusters could not grow because crop-grow = false");
                blockSpreadEvent.setCancelled(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCauldronEmpty(CauldronLevelChangeEvent cauldronLevelChangeEvent) {
        Entity entity = cauldronLevelChangeEvent.getEntity();
        Location location = BukkitUtil.adapt(cauldronLevelChangeEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getPlot(location);
        switch (cauldronLevelChangeEvent.getReason()) {
            case BANNER_WASH: 
            case ARMOR_WASH: 
            case EXTINGUISH: {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
                    if (plot != null) {
                        if (!plot.hasOwner()) {
                            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                                return;
                            }
                        } else {
                            if (plot.isAdded(bukkitPlayer.getUUID())) return;
                            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                                return;
                            }
                        }
                    } else {
                        if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                            return;
                        }
                        if (this.worldEdit != null && bukkitPlayer.getAttribute("worldedit") && player.getInventory().getItemInMainHand().getType() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
                            return;
                        }
                    }
                }
                if (cauldronLevelChangeEvent.getReason() == CauldronLevelChangeEvent.ChangeReason.EXTINGUISH && cauldronLevelChangeEvent.getEntity() != null) {
                    cauldronLevelChangeEvent.getEntity().setFireTicks(0);
                }
                cauldronLevelChangeEvent.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent blockFormEvent) {
        if (blockFormEvent instanceof EntityBlockFormEvent) {
            return;
        }
        Block block = blockFormEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            blockFormEvent.setCancelled(true);
            return;
        }
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        if (!plotArea.buildRangeContainsY(location.getY())) {
            blockFormEvent.setCancelled(true);
            return;
        }
        if (Tag.SNOW.isTagged((Keyed)blockFormEvent.getNewState().getType())) {
            if (!((Boolean)plot.getFlag(SnowFormFlag.class)).booleanValue()) {
                plot.debug("Snow could not form because snow-form = false");
                blockFormEvent.setCancelled(true);
            }
            return;
        }
        if (Tag.ICE.isTagged((Keyed)blockFormEvent.getNewState().getType()) && !((Boolean)plot.getFlag(IceFormFlag.class)).booleanValue()) {
            plot.debug("Ice could not form because ice-form = false");
            blockFormEvent.setCancelled(true);
        }
        if (blockFormEvent.getNewState().getType().toString().endsWith("CONCRETE") && !((Boolean)plot.getFlag(ConcreteHardenFlag.class)).booleanValue()) {
            plot.debug("Concrete powder could not harden because concrete-harden = false");
            blockFormEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBlockForm(EntityBlockFormEvent entityBlockFormEvent) {
        Class clazz;
        String string = entityBlockFormEvent.getBlock().getWorld().getName();
        if (!this.plotAreaManager.hasPlotArea(string)) {
            return;
        }
        Location location = BukkitUtil.adapt(entityBlockFormEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            entityBlockFormEvent.setCancelled(true);
            return;
        }
        if (Tag.SNOW.isTagged((Keyed)entityBlockFormEvent.getNewState().getType())) {
            clazz = SnowFormFlag.class;
        } else if (Tag.ICE.isTagged((Keyed)entityBlockFormEvent.getNewState().getType())) {
            clazz = IceFormFlag.class;
        } else {
            return;
        }
        boolean bl = (Boolean)plot.getFlag(clazz);
        Entity entity = entityBlockFormEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            if (!plot.isAdded(bukkitPlayer.getUUID())) {
                if (bl) {
                    return;
                }
                plot.debug(String.format("%s could not be formed because %s = false (entity is player)", entityBlockFormEvent.getNewState().getType(), clazz == SnowFormFlag.class ? "snow-form" : "ice-form"));
                entityBlockFormEvent.setCancelled(true);
            }
            return;
        }
        if (plot.hasOwner()) {
            if (bl) {
                return;
            }
            plot.debug(String.format("%s could not be formed because %s = false (entity is not player)", entityBlockFormEvent.getNewState().getType(), clazz == SnowFormFlag.class ? "snow-form" : "ice-form"));
            entityBlockFormEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent blockDamageEvent) {
        Player player = blockDamageEvent.getPlayer();
        Location location = BukkitUtil.adapt(blockDamageEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        Plot plot = plotArea.getPlot(location);
        if (plot != null) {
            Object object;
            Object object2;
            if (((Boolean)plot.getFlag(InstabreakFlag.class)).booleanValue()) {
                object2 = blockDamageEvent.getBlock();
                object = new BlockBreakEvent((Block)object2, player);
                Bukkit.getServer().getPluginManager().callEvent((Event)object);
                if (!object.isCancelled()) {
                    blockDamageEvent.getBlock().breakNaturally();
                }
            }
            if (location.getY() == plotArea.getMinGenHeight()) {
                blockDamageEvent.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                object2 = BukkitUtil.adapt(player);
                if (object2.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                    return;
                }
                blockDamageEvent.setCancelled(true);
                return;
            }
            object2 = BukkitUtil.adapt(player);
            if (!plot.isAdded(((BukkitPlayer)object2).getUUID())) {
                Block block;
                object = (List)plot.getFlag(BreakFlag.class);
                if (object.contains(BlockTypeWrapper.get(BukkitAdapter.asBlockType((Material)(block = blockDamageEvent.getBlock()).getType()))) || object2.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    return;
                }
                plot.debug(player.getName() + " could not break " + block.getType() + " because it was not in the break flag");
                blockDamageEvent.setCancelled(true);
                return;
            }
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
            return;
        }
        blockDamageEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFade(BlockFadeEvent blockFadeEvent) {
        Block block = blockFadeEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            blockFadeEvent.setCancelled(true);
            return;
        }
        Material material = block.getType();
        if (Tag.ICE.isTagged((Keyed)material)) {
            if (!((Boolean)plot.getFlag(IceMeltFlag.class)).booleanValue()) {
                plot.debug("Ice could not melt because ice-melt = false");
                blockFadeEvent.setCancelled(true);
            }
            return;
        }
        if (Tag.SNOW.isTagged((Keyed)material)) {
            if (!((Boolean)plot.getFlag(SnowMeltFlag.class)).booleanValue()) {
                plot.debug("Snow could not melt because snow-melt = false");
                blockFadeEvent.setCancelled(true);
            }
            return;
        }
        if (material == Material.FARMLAND) {
            if (!((Boolean)plot.getFlag(SoilDryFlag.class)).booleanValue()) {
                plot.debug("Soil could not dry because soil-dry = false");
                blockFadeEvent.setCancelled(true);
            }
            return;
        }
        if ((Tag.CORAL_BLOCKS.isTagged((Keyed)material) || Tag.CORALS.isTagged((Keyed)material) || Tag.WALL_CORALS.isTagged((Keyed)material)) && !((Boolean)plot.getFlag(CoralDryFlag.class)).booleanValue()) {
            plot.debug("Coral could not dry because coral-dry = false");
            blockFadeEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMoistureChange(MoistureChangeEvent moistureChangeEvent) {
        Block block = moistureChangeEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            moistureChangeEvent.setCancelled(true);
            return;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Farmland) {
            Farmland farmland = (Farmland)blockData;
            blockData = moistureChangeEvent.getNewState().getBlockData();
            if (blockData instanceof Farmland) {
                Farmland farmland2 = (Farmland)blockData;
                int n = farmland.getMoisture();
                int n2 = farmland2.getMoisture();
                if (n2 > n) {
                    return;
                }
                if (((Boolean)plot.getFlag(SoilDryFlag.class)).booleanValue()) {
                    return;
                }
                plot.debug("Soil could not dry because soil-dry = false");
                moistureChangeEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChange(BlockFromToEvent blockFromToEvent) {
        Plot plot;
        Object object;
        Block block = blockFromToEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea != null && (object = plotArea.getOwnedPlot(location)) != null && ((Plot)object).getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.DISABLED && blockFromToEvent.getBlock().isLiquid()) {
            ((Plot)object).debug("Liquid could not flow because liquid-flow = disabled");
            blockFromToEvent.setCancelled(true);
            return;
        }
        object = blockFromToEvent.getToBlock();
        Location location2 = BukkitUtil.adapt(object.getLocation());
        PlotArea plotArea2 = location2.getPlotArea();
        if (plotArea2 == null) {
            if (block.getType() == Material.DRAGON_EGG && plotArea != null) {
                blockFromToEvent.setCancelled(true);
            }
            return;
        }
        if (!plotArea2.buildRangeContainsY(location2.getY())) {
            blockFromToEvent.setCancelled(true);
            return;
        }
        Plot plot2 = plotArea2.getOwnedPlot(location2);
        if (!(block.getType() != Material.DRAGON_EGG || plotArea == null || (plot = plotArea.getOwnedPlot(location)) == null && plot2 == null || plot != null && plot.equals(plot2) || plot2 != null && plot2.equals(plot))) {
            blockFromToEvent.setCancelled(true);
            return;
        }
        if (plot2 != null) {
            if (!plotArea2.contains(location.getX(), location.getZ()) || !Objects.equals(plot2, plotArea2.getOwnedPlot(location))) {
                blockFromToEvent.setCancelled(true);
                return;
            }
            if (plot2.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.ENABLED && blockFromToEvent.getBlock().isLiquid()) {
                return;
            }
            if (((Boolean)plot2.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                plot2.debug(blockFromToEvent.getBlock().getType() + " could not update because disable-physics = true");
                blockFromToEvent.setCancelled(true);
                return;
            }
            if (plot2.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.DISABLED && blockFromToEvent.getBlock().isLiquid()) {
                plot2.debug("Liquid could not flow because liquid-flow = disabled");
                blockFromToEvent.setCancelled(true);
            }
        } else if (!plotArea2.contains(location.getX(), location.getZ()) || !Objects.equals(null, plotArea2.getOwnedPlot(location))) {
            blockFromToEvent.setCancelled(true);
        } else if (blockFromToEvent.getBlock().isLiquid() && (BukkitUtil.adapt((plot = blockFromToEvent.getBlock().getLocation()).clone().add(-1.0, 0.0, 1.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(1.0, 0.0, 1.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(-1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(-1.0, 0.0, -1.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(0.0, 0.0, -1.0)).getPlot() != null || BukkitUtil.adapt(plot.clone().add(1.0, 0.0, 1.0)).getPlot() != null)) {
            blockFromToEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGrow(BlockGrowEvent blockGrowEvent) {
        Block block = blockGrowEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        if (!plotArea.buildRangeContainsY(location.getY())) {
            blockGrowEvent.setCancelled(true);
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(CropGrowFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Crop grow event was cancelled because crop-grow = false");
            }
            blockGrowEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        Block block = blockPistonExtendEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        BlockFace blockFace = blockPistonExtendEvent.getDirection();
        Vector vector = new Vector(blockFace.getModX(), blockFace.getModY(), blockFace.getModZ());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            for (Block block2 : blockPistonExtendEvent.getBlocks()) {
                Location location2 = BukkitUtil.adapt(block2.getLocation());
                if (!location2.isPlotArea() && !location2.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()).isPlotArea()) continue;
                blockPistonExtendEvent.setCancelled(true);
                return;
            }
            if (location.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()).isPlotArea()) {
                blockPistonExtendEvent.setCancelled(true);
            }
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            blockPistonExtendEvent.setCancelled(true);
            return;
        }
        for (Block block3 : blockPistonExtendEvent.getBlocks()) {
            Location location3 = BukkitUtil.adapt(block3.getLocation());
            Location location4 = location3.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
            if (!plotArea.contains(location3.getX(), location3.getZ()) || !plotArea.contains(location4)) {
                blockPistonExtendEvent.setCancelled(true);
                return;
            }
            if (!plot.equals(plotArea.getOwnedPlot(location3)) || !plot.equals(plotArea.getOwnedPlot(location4))) {
                blockPistonExtendEvent.setCancelled(true);
                return;
            }
            if (plotArea.buildRangeContainsY(location3.getY()) && plotArea.buildRangeContainsY(location4.getY())) continue;
            blockPistonExtendEvent.setCancelled(true);
            return;
        }
        if (!plot.equals(plotArea.getOwnedPlot(location.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ())))) {
            blockPistonExtendEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        Block block = blockPistonRetractEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        BlockFace blockFace = blockPistonRetractEvent.getDirection();
        Vector vector = new Vector(blockFace.getModX(), blockFace.getModY(), blockFace.getModZ());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            for (Block block2 : blockPistonRetractEvent.getBlocks()) {
                Location location2 = BukkitUtil.adapt(block2.getLocation());
                Location location3 = location2.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
                if (!location2.isPlotArea() && !location3.isPlotArea()) continue;
                blockPistonRetractEvent.setCancelled(true);
                return;
            }
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null) {
            blockPistonRetractEvent.setCancelled(true);
            return;
        }
        for (Block block3 : blockPistonRetractEvent.getBlocks()) {
            Location location4 = BukkitUtil.adapt(block3.getLocation());
            Location location5 = location4.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
            if (!plotArea.contains(location4.getX(), location4.getZ()) || !plotArea.contains(location5)) {
                blockPistonRetractEvent.setCancelled(true);
                return;
            }
            if (!plot.equals(plotArea.getOwnedPlot(location4)) || !plot.equals(plotArea.getOwnedPlot(location5))) {
                blockPistonRetractEvent.setCancelled(true);
                return;
            }
            if (plotArea.buildRangeContainsY(location4.getY()) && plotArea.buildRangeContainsY(location5.getY())) continue;
            blockPistonRetractEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent blockDispenseEvent) {
        if (!this.plotAreaManager.hasPlotArea(blockDispenseEvent.getBlock().getWorld().getName())) {
            return;
        }
        Material material = blockDispenseEvent.getItem().getType();
        switch (material.toString()) {
            case "SHULKER_BOX": 
            case "WHITE_SHULKER_BOX": 
            case "ORANGE_SHULKER_BOX": 
            case "MAGENTA_SHULKER_BOX": 
            case "LIGHT_BLUE_SHULKER_BOX": 
            case "YELLOW_SHULKER_BOX": 
            case "LIME_SHULKER_BOX": 
            case "PINK_SHULKER_BOX": 
            case "GRAY_SHULKER_BOX": 
            case "LIGHT_GRAY_SHULKER_BOX": 
            case "CYAN_SHULKER_BOX": 
            case "PURPLE_SHULKER_BOX": 
            case "BLUE_SHULKER_BOX": 
            case "BROWN_SHULKER_BOX": 
            case "GREEN_SHULKER_BOX": 
            case "RED_SHULKER_BOX": 
            case "BLACK_SHULKER_BOX": 
            case "CARVED_PUMPKIN": 
            case "WITHER_SKELETON_SKULL": 
            case "FLINT_AND_STEEL": 
            case "BONE_MEAL": 
            case "SHEARS": 
            case "GLASS_BOTTLE": 
            case "GLOWSTONE": 
            case "COD_BUCKET": 
            case "PUFFERFISH_BUCKET": 
            case "SALMON_BUCKET": 
            case "TROPICAL_FISH_BUCKET": 
            case "AXOLOTL_BUCKET": 
            case "BUCKET": 
            case "WATER_BUCKET": 
            case "LAVA_BUCKET": 
            case "TADPOLE_BUCKET": {
                if (blockDispenseEvent.getBlock().getType() == Material.DROPPER) {
                    return;
                }
                BlockFace blockFace = ((Dispenser)blockDispenseEvent.getBlock().getBlockData()).getFacing();
                Location location = BukkitUtil.adapt(blockDispenseEvent.getBlock().getRelative(blockFace).getLocation());
                if (location.isPlotRoad()) {
                    blockDispenseEvent.setCancelled(true);
                    return;
                }
                PlotArea plotArea = location.getPlotArea();
                if (plotArea == null || plotArea.buildRangeContainsY(location.getY())) break;
                blockDispenseEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent structureGrowEvent) {
        Plot plot;
        int n;
        if (!this.plotAreaManager.hasPlotArea(structureGrowEvent.getWorld().getName())) {
            return;
        }
        List list = structureGrowEvent.getBlocks();
        if (list.isEmpty()) {
            return;
        }
        Location location = BukkitUtil.adapt(((BlockState)list.get(0)).getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                location = BukkitUtil.adapt(((BlockState)list.get(i)).getLocation());
                if (!location.isPlotArea()) continue;
                list.remove(i);
            }
            return;
        }
        Plot plot2 = plotArea.getOwnedPlot(location);
        if (plot2 == null) {
            structureGrowEvent.setCancelled(true);
            return;
        }
        for (n = list.size() - 1; n >= 0; --n) {
            location = BukkitUtil.adapt(((BlockState)list.get(n)).getLocation());
            if (!plotArea.contains(location.getX(), location.getZ())) {
                list.remove(n);
                continue;
            }
            plot = plotArea.getOwnedPlot(location);
            if (!Objects.equals(plot, plot2)) {
                structureGrowEvent.getBlocks().remove(n);
                continue;
            }
            if (plotArea.buildRangeContainsY(location.getY())) continue;
            structureGrowEvent.getBlocks().remove(n);
        }
        plot2 = plotArea.getPlot(location);
        if (plot2 == null) {
            structureGrowEvent.setCancelled(true);
            return;
        }
        for (n = list.size() - 1; n >= 0; --n) {
            location = BukkitUtil.adapt(((BlockState)list.get(n)).getLocation());
            plot = plotArea.getOwnedPlot(location);
            if (Objects.equals(plot, plot2) || plot.isMerged() || plot2.isMerged()) continue;
            structureGrowEvent.getBlocks().remove(n);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBigBoom(BlockExplodeEvent blockExplodeEvent) {
        Block block2 = blockExplodeEvent.getBlock();
        Location location = BukkitUtil.adapt(block2.getLocation());
        String string = location.getWorldName();
        if (!this.plotAreaManager.hasPlotArea(string)) {
            return;
        }
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            Iterator iterator = blockExplodeEvent.blockList().iterator();
            while (iterator.hasNext()) {
                location = BukkitUtil.adapt(((Block)iterator.next()).getLocation());
                if (!location.isPlotArea()) continue;
                iterator.remove();
            }
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (plot == null || !((Boolean)plot.getFlag(ExplosionFlag.class)).booleanValue()) {
            blockExplodeEvent.setCancelled(true);
            if (plot != null) {
                plot.debug("Explosion was cancelled because explosion = false");
            }
            return;
        }
        blockExplodeEvent.blockList().removeIf(block -> !plot.equals(plotArea.getOwnedPlot(BukkitUtil.adapt(block.getLocation()))));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent blockBurnEvent) {
        Block block = blockBurnEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(BlockBurnFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Block burning was cancelled because block-burn = false");
            }
            blockBurnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent blockIgniteEvent) {
        Player player = blockIgniteEvent.getPlayer();
        Entity entity = blockIgniteEvent.getIgnitingEntity();
        Block block = blockIgniteEvent.getBlock();
        BlockIgniteEvent.IgniteCause igniteCause = blockIgniteEvent.getCause();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        if (igniteCause == BlockIgniteEvent.IgniteCause.LIGHTNING) {
            blockIgniteEvent.setCancelled(true);
            return;
        }
        Plot plot = plotArea.getOwnedPlot(location);
        if (player != null) {
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
            if (plotArea.notifyIfOutsideBuildArea(bukkitPlayer, location.getY())) {
                blockIgniteEvent.setCancelled(true);
                return;
            }
            if (plot == null) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, BlockIgnitionFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_ROAD)));
                    blockIgniteEvent.setCancelled(true);
                }
            } else if (!plot.hasOwner()) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, BlockIgnitionFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_UNOWNED)));
                    blockIgniteEvent.setCancelled(true);
                }
            } else if (!plot.isAdded(bukkitPlayer.getUUID())) {
                if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_OTHER)));
                    blockIgniteEvent.setCancelled(true);
                }
            } else if (!((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue()) {
                blockIgniteEvent.setCancelled(true);
                plot.debug("Block ignition was cancelled because block-ignition = false");
            }
        } else {
            if (plot == null) {
                blockIgniteEvent.setCancelled(true);
                return;
            }
            if (entity != null) {
                if (!((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue()) {
                    blockIgniteEvent.setCancelled(true);
                    plot.debug("Block ignition was cancelled because block-ignition = false");
                    return;
                }
                if (igniteCause == BlockIgniteEvent.IgniteCause.FIREBALL && entity instanceof Fireball) {
                    Projectile projectile = (Projectile)entity;
                    Location location2 = null;
                    ProjectileSource projectileSource = projectile.getShooter();
                    if (projectileSource instanceof Entity) {
                        Entity entity2 = (Entity)projectileSource;
                        location2 = BukkitUtil.adapt(entity2.getLocation());
                    } else if (projectile.getShooter() instanceof BlockProjectileSource) {
                        projectileSource = ((BlockProjectileSource)projectile.getShooter()).getBlock();
                        location2 = BukkitUtil.adapt(projectileSource.getLocation());
                    }
                    if (location2 != null && !plot.equals(location2.getPlot())) {
                        blockIgniteEvent.setCancelled(true);
                    }
                }
            } else if (blockIgniteEvent.getIgnitingBlock() != null) {
                Block block2 = blockIgniteEvent.getIgnitingBlock();
                Plot plot2 = BukkitUtil.adapt(block2.getLocation()).getPlot();
                if (!((igniteCause != BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || ((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue() && plot2 != null && plot2.equals(plot)) && (igniteCause != BlockIgniteEvent.IgniteCause.SPREAD && igniteCause != BlockIgniteEvent.IgniteCause.LAVA || ((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue() && plot2 != null && plot2.equals(plot)))) {
                    blockIgniteEvent.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent leavesDecayEvent) {
        Block block = leavesDecayEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(LeafDecayFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Leaf decaying was cancelled because leaf-decay = false");
            }
            leavesDecayEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpongeAbsorb(SpongeAbsorbEvent spongeAbsorbEvent) {
        Block block = spongeAbsorbEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea plotArea = location.getPlotArea();
        List list = spongeAbsorbEvent.getBlocks();
        if (plotArea == null) {
            list.removeIf(blockState -> BukkitUtil.adapt(blockState.getLocation()).isPlotArea());
        } else {
            Plot plot = plotArea.getOwnedPlot(location);
            list.removeIf(blockState -> {
                Location location2 = BukkitUtil.adapt(blockState.getLocation());
                if (!plotArea.contains(location2.getX(), location2.getZ())) {
                    return true;
                }
                Plot plot2 = plotArea.getOwnedPlot(location2);
                if (!Objects.equals(plot2, plot)) {
                    return true;
                }
                return !plotArea.buildRangeContainsY(location.getY());
            });
        }
        if (list.isEmpty()) {
            spongeAbsorbEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockMultiPlace(BlockMultiPlaceEvent blockMultiPlaceEvent) {
        this.blockCreate((BlockPlaceEvent)blockMultiPlaceEvent);
        if (blockMultiPlaceEvent.isCancelled()) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(blockMultiPlaceEvent.getPlayer());
        Location location = BukkitUtil.adapt(blockMultiPlaceEvent.getBlockReplacedState().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Plot plot = location.getPlot();
        for (BlockState blockState : blockMultiPlaceEvent.getReplacedBlockStates()) {
            Location location2 = BukkitUtil.adapt(blockState.getLocation());
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD) && !Objects.equals(location2.getPlot(), plot)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Permission.PERMISSION_ADMIN_BUILD_ROAD)));
                blockMultiPlaceEvent.setCancelled(true);
                break;
            }
            if (bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT) || location2.getY() < plotArea.getMaxBuildHeight() && location2.getY() >= plotArea.getMinBuildHeight()) continue;
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("height.height_limit"), TagResolver.builder().tag("minheight", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plotArea.getMinBuildHeight()))).tag("maxheight", com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag.inserting(Component.text(plotArea.getMaxBuildHeight()))).build());
            if (!plotArea.notifyIfOutsideBuildArea(bukkitPlayer, location2.getY())) continue;
            blockMultiPlaceEvent.setCancelled(true);
            break;
        }
    }
}

