/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.ReflectionUtils;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ChunkListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private final int version;
    private ReflectionUtils.RefMethod methodSetUnsaved;
    private ReflectionUtils.RefMethod methodGetHandleChunk;
    private ReflectionUtils.RefMethod methodGetHandleWorld;
    private ReflectionUtils.RefField mustNotSave;
    private Object objChunkStatusFull;
    private Chunk lastChunk;
    private boolean ignoreUnload;

    @Inject
    public ChunkListener(@NonNull PlotAreaManager plotAreaManager) {
        block12: {
            this.objChunkStatusFull = null;
            this.ignoreUnload = false;
            this.plotAreaManager = plotAreaManager;
            this.version = PlotSquared.platform().serverVersion()[1];
            if (!Settings.Chunk_Processor.AUTO_TRIM) {
                return;
            }
            try {
                ReflectionUtils.RefClass refClass = ReflectionUtils.getRefClass("{cb}.CraftWorld");
                ReflectionUtils.RefClass refClass2 = ReflectionUtils.getRefClass("{cb}.CraftChunk");
                ReflectionUtils.RefClass refClass3 = ReflectionUtils.getRefClass("net.minecraft.world.level.chunk.IChunkAccess");
                this.methodSetUnsaved = refClass3.getMethod("a", Boolean.TYPE);
                try {
                    this.methodGetHandleChunk = refClass2.getMethod("getHandle", new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        ReflectionUtils.RefClass refClass4 = ReflectionUtils.getRefClass("net.minecraft.world.level.chunk.ChunkStatus");
                        this.objChunkStatusFull = refClass4.getRealClass().getField("n").get(null);
                        this.methodGetHandleChunk = refClass2.getMethod("getHandle", refClass4.getRealClass());
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw new RuntimeException(noSuchMethodException2);
                    }
                }
                try {
                    ReflectionUtils.RefClass refClass5;
                    if (this.version < 17) {
                        refClass5 = ReflectionUtils.getRefClass("{nms}.Chunk");
                        this.mustNotSave = refClass5.getField("mustNotSave");
                        break block12;
                    }
                    refClass5 = ReflectionUtils.getRefClass("net.minecraft.world.level.chunk.Chunk");
                    this.mustNotSave = refClass5.getField("mustNotSave");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    noSuchFieldException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Settings.Chunk_Processor.AUTO_TRIM = false;
            }
        }
        for (ReflectionUtils.RefClass refClass2 : Bukkit.getWorlds()) {
            refClass2.setAutoSave(false);
        }
        if (this.version > 13) {
            return;
        }
        TaskManager.runTaskRepeat(() -> {
            try {
                HashSet<Chunk> hashSet = new HashSet<Chunk>();
                for (World world : Bukkit.getWorlds()) {
                    Chunk[] chunkArray;
                    String string = world.getName();
                    if (!this.plotAreaManager.hasPlotArea(string)) continue;
                    Object object = this.methodGetHandleWorld.of(world).call(new Object[0]);
                    if (this.version != 13) continue;
                    Object object2 = object.getClass().getDeclaredMethod("getPlayerChunkMap", new Class[0]).invoke(object, new Object[0]);
                    Method method = object2.getClass().getDeclaredMethod("isChunkInUse", Integer.TYPE, Integer.TYPE);
                    for (Chunk chunk : chunkArray = world.getLoadedChunks()) {
                        int n;
                        if (((Boolean)method.invoke(object2, chunk.getX(), chunk.getZ())).booleanValue()) continue;
                        int n2 = chunk.getX();
                        if (!this.shouldSave(string, n2, n = chunk.getZ())) {
                            this.unloadChunk(string, chunk, false);
                            continue;
                        }
                        hashSet.add(chunk);
                    }
                }
                if (hashSet.isEmpty()) {
                    return;
                }
                long l = System.currentTimeMillis();
                for (Chunk chunk : hashSet) {
                    if (System.currentTimeMillis() - l > 5L) {
                        return;
                    }
                    chunk.unload(true);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }, TaskTime.ticks(1L));
    }

    public boolean unloadChunk(String string, Chunk chunk, boolean bl) {
        if (bl && this.shouldSave(string, chunk.getX(), chunk.getZ())) {
            return false;
        }
        Object object = this.objChunkStatusFull != null ? this.methodGetHandleChunk.of(chunk).call(this.objChunkStatusFull) : this.methodGetHandleChunk.of(chunk).call(new Object[0]);
        ReflectionUtils.RefField.RefExecutor refExecutor = this.mustNotSave.of(object);
        this.methodSetUnsaved.of(object).call(false);
        if (!((Boolean)refExecutor.get()).booleanValue()) {
            refExecutor.set(true);
            if (chunk.isLoaded()) {
                this.ignoreUnload = true;
                chunk.unload(false);
                this.ignoreUnload = false;
            }
        }
        return true;
    }

    public boolean shouldSave(String string, int n, int n2) {
        Plot plot;
        int n3 = n << 4;
        int n4 = n2 << 4;
        int n5 = n3 + 15;
        int n6 = n4 + 15;
        Location location = Location.at(string, n3, 1, n4);
        PlotArea plotArea = this.plotAreaManager.getPlotArea(location);
        if (plotArea != null && (plot = plotArea.getPlot(location)) != null && plot.hasOwner()) {
            return true;
        }
        location = Location.at(string, n5, 1, n6);
        plotArea = this.plotAreaManager.getPlotArea(location);
        if (plotArea != null && (plot = plotArea.getPlot(location)) != null && plot.hasOwner()) {
            return true;
        }
        location = Location.at(string, n5, 1, n4);
        plotArea = this.plotAreaManager.getPlotArea(location);
        if (plotArea != null && (plot = plotArea.getPlot(location)) != null && plot.hasOwner()) {
            return true;
        }
        location = Location.at(string, n3, 1, n6);
        plotArea = this.plotAreaManager.getPlotArea(location);
        if (plotArea != null && (plot = plotArea.getPlot(location)) != null && plot.hasOwner()) {
            return true;
        }
        location = Location.at(string, n3 + 7, 1, n4 + 7);
        plotArea = this.plotAreaManager.getPlotArea(location);
        if (plotArea == null) {
            return false;
        }
        plot = plotArea.getPlot(location);
        return plot != null && plot.hasOwner();
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (this.ignoreUnload) {
            return;
        }
        Chunk chunk = chunkUnloadEvent.getChunk();
        if (Settings.Chunk_Processor.AUTO_TRIM) {
            String string = chunk.getWorld().getName();
            if ((!Settings.Enabled_Components.WORLDS || !SinglePlotArea.isSinglePlotWorld(string)) && this.plotAreaManager.hasPlotArea(string) && this.unloadChunk(string, chunk, true)) {
                return;
            }
        }
        if (this.processChunk(chunkUnloadEvent.getChunk(), true)) {
            chunk.setForceLoaded(true);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent chunkLoadEvent) {
        this.processChunk(chunkLoadEvent.getChunk(), false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent itemSpawnEvent) {
        Item item = itemSpawnEvent.getEntity();
        PaperLib.getChunkAtAsync(itemSpawnEvent.getLocation()).thenAccept(chunk -> {
            if (chunk == this.lastChunk) {
                itemSpawnEvent.getEntity().remove();
                itemSpawnEvent.setCancelled(true);
                return;
            }
            if (!this.plotAreaManager.hasPlotArea(chunk.getWorld().getName())) {
                return;
            }
            Entity[] entityArray = chunk.getEntities();
            if (entityArray.length > Settings.Chunk_Processor.MAX_ENTITIES) {
                itemSpawnEvent.getEntity().remove();
                itemSpawnEvent.setCancelled(true);
                this.lastChunk = chunk;
            } else {
                this.lastChunk = null;
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent blockPhysicsEvent) {
        if (Settings.Chunk_Processor.DISABLE_PHYSICS) {
            blockPhysicsEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntitySpawn(CreatureSpawnEvent creatureSpawnEvent) {
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        PaperLib.getChunkAtAsync(creatureSpawnEvent.getLocation()).thenAccept(chunk -> {
            if (chunk == this.lastChunk) {
                creatureSpawnEvent.getEntity().remove();
                creatureSpawnEvent.setCancelled(true);
                return;
            }
            if (!this.plotAreaManager.hasPlotArea(chunk.getWorld().getName())) {
                return;
            }
            Entity[] entityArray = chunk.getEntities();
            if (entityArray.length > Settings.Chunk_Processor.MAX_ENTITIES) {
                creatureSpawnEvent.getEntity().remove();
                creatureSpawnEvent.setCancelled(true);
                this.lastChunk = chunk;
            } else {
                this.lastChunk = null;
            }
        });
    }

    private void cleanChunk(Chunk chunk) {
        int n = TaskManager.index.incrementAndGet();
        PlotSquaredTask plotSquaredTask = TaskManager.runTaskRepeat(() -> {
            if (!chunk.isLoaded()) {
                Objects.requireNonNull(TaskManager.removeTask(n)).cancel();
                chunk.unload(true);
                return;
            }
            BlockState[] blockStateArray = chunk.getTileEntities();
            if (blockStateArray.length == 0) {
                Objects.requireNonNull(TaskManager.removeTask(n)).cancel();
                chunk.unload(true);
                return;
            }
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (System.currentTimeMillis() - l < 250L) {
                if (n2 >= blockStateArray.length - Settings.Chunk_Processor.MAX_TILES) {
                    Objects.requireNonNull(TaskManager.removeTask(n)).cancel();
                    chunk.unload(true);
                    return;
                }
                blockStateArray[n2].getBlock().setType(Material.AIR, false);
                ++n2;
            }
        }, TaskTime.ticks(5L));
        TaskManager.addTask(plotSquaredTask, n);
    }

    public boolean processChunk(Chunk chunk, boolean bl) {
        int n;
        if (!this.plotAreaManager.hasPlotArea(chunk.getWorld().getName())) {
            return false;
        }
        Entity[] entityArray = chunk.getEntities();
        BlockState[] blockStateArray = chunk.getTileEntities();
        if (entityArray.length > Settings.Chunk_Processor.MAX_ENTITIES) {
            n = entityArray.length - Settings.Chunk_Processor.MAX_ENTITIES;
            int n2 = 0;
            while (n > 0 && n2 < entityArray.length) {
                Entity entity;
                if ((entity = entityArray[n2++]) instanceof Player) continue;
                entity.remove();
                --n;
            }
        }
        if (blockStateArray.length > Settings.Chunk_Processor.MAX_TILES) {
            if (bl) {
                this.cleanChunk(chunk);
                return true;
            }
            for (n = 0; n < blockStateArray.length - Settings.Chunk_Processor.MAX_TILES; ++n) {
                blockStateArray[n].getBlock().setType(Material.AIR, false);
            }
        }
        return false;
    }
}

