/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.destroystokyo.paper.event.entity.SlimePathfindEvent;
import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.implementations.BeaconEffectsFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.ProjectilesFlag;
import com.plotsquared.core.plot.flag.types.BooleanFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PaperListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private Chunk lastChunk;

    @Inject
    public PaperListener(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler
    public void onEntityPathfind(EntityPathfindEvent entityPathfindEvent) {
        Plot plot;
        if (!Settings.Paper_Components.ENTITY_PATHING) {
            return;
        }
        Location location = BukkitUtil.adapt(entityPathfindEvent.getLoc());
        Location location2 = BukkitUtil.adapt(entityPathfindEvent.getEntity().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        PlotArea plotArea2 = location2.getPlotArea();
        if (plotArea2 == null) {
            return;
        }
        if (plotArea != plotArea2) {
            entityPathfindEvent.setCancelled(true);
            return;
        }
        Plot plot2 = location.getPlot();
        if (plot2 == null ^ (plot = location2.getPlot()) == null) {
            entityPathfindEvent.setCancelled(true);
            return;
        }
        if (plot2 == null || plot2.getId().hashCode() == plot.getId().hashCode()) {
            return;
        }
        if (plot.isMerged() && plot.getConnectedPlots().contains(plot)) {
            return;
        }
        entityPathfindEvent.setCancelled(true);
    }

    @EventHandler
    public void onEntityPathfind(SlimePathfindEvent slimePathfindEvent) {
        Plot plot;
        if (!Settings.Paper_Components.ENTITY_PATHING) {
            return;
        }
        Slime slime = slimePathfindEvent.getEntity();
        Block block = slime.getTargetBlock(4);
        if (block == null) {
            return;
        }
        Location location = BukkitUtil.adapt(block.getLocation());
        Location location2 = BukkitUtil.adapt(slimePathfindEvent.getEntity().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        PlotArea plotArea2 = location2.getPlotArea();
        if (plotArea2 == null) {
            return;
        }
        if (plotArea != plotArea2) {
            slimePathfindEvent.setCancelled(true);
            return;
        }
        Plot plot2 = location.getPlot();
        if (plot2 == null ^ (plot = location2.getPlot()) == null) {
            slimePathfindEvent.setCancelled(true);
            return;
        }
        if (plot2 == null || plot2.getId().hashCode() == plot.getId().hashCode()) {
            return;
        }
        if (plot.isMerged() && plot.getConnectedPlots().contains(plot)) {
            return;
        }
        slimePathfindEvent.setCancelled(true);
    }

    @EventHandler
    public void onPreCreatureSpawnEvent(PreCreatureSpawnEvent preCreatureSpawnEvent) {
        if (!Settings.Paper_Components.CREATURE_SPAWN) {
            return;
        }
        Location location = BukkitUtil.adapt(preCreatureSpawnEvent.getSpawnLocation());
        PlotArea plotArea = location.getPlotArea();
        if (!location.isPlotArea()) {
            return;
        }
        Entity[] entityArray = preCreatureSpawnEvent.getSpawnLocation().getChunk().getEntities();
        if (entityArray.length > Settings.Chunk_Processor.MAX_ENTITIES) {
            preCreatureSpawnEvent.setShouldAbortSpawn(true);
            preCreatureSpawnEvent.setCancelled(true);
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = preCreatureSpawnEvent.getReason();
        switch (spawnReason.toString()) {
            case "DISPENSE_EGG": 
            case "EGG": 
            case "OCELOT_BABY": 
            case "SPAWNER_EGG": {
                if (plotArea.isSpawnEggs()) break;
                preCreatureSpawnEvent.setShouldAbortSpawn(true);
                preCreatureSpawnEvent.setCancelled(true);
                return;
            }
            case "REINFORCEMENTS": 
            case "NATURAL": 
            case "MOUNT": 
            case "PATROL": 
            case "RAID": 
            case "SHEARED": 
            case "SILVERFISH_BLOCK": 
            case "ENDER_PEARL": 
            case "TRAP": 
            case "VILLAGE_DEFENSE": 
            case "VILLAGE_INVASION": 
            case "BEEHIVE": 
            case "CHUNK_GEN": {
                if (plotArea.isMobSpawning()) break;
                preCreatureSpawnEvent.setShouldAbortSpawn(true);
                preCreatureSpawnEvent.setCancelled(true);
                return;
            }
            case "BREEDING": {
                if (plotArea.isSpawnBreeding()) break;
                preCreatureSpawnEvent.setShouldAbortSpawn(true);
                preCreatureSpawnEvent.setCancelled(true);
                return;
            }
            case "BUILD_IRONGOLEM": 
            case "BUILD_SNOWMAN": 
            case "BUILD_WITHER": 
            case "CUSTOM": {
                if (plotArea.isSpawnCustom() || preCreatureSpawnEvent.getType() == EntityType.ARMOR_STAND) break;
                preCreatureSpawnEvent.setShouldAbortSpawn(true);
                preCreatureSpawnEvent.setCancelled(true);
                return;
            }
            case "SPAWNER": {
                if (plotArea.isMobSpawnerSpawning()) break;
                preCreatureSpawnEvent.setShouldAbortSpawn(true);
                preCreatureSpawnEvent.setCancelled(true);
                return;
            }
        }
        Object object = location.getOwnedPlotAbs();
        if (object == null) {
            EntityType entityType = preCreatureSpawnEvent.getType();
            if (entityType == EntityType.DROPPED_ITEM) {
                if (Settings.Enabled_Components.KILL_ROAD_ITEMS) {
                    preCreatureSpawnEvent.setCancelled(true);
                }
                return;
            }
            if (!plotArea.isMobSpawning()) {
                if (entityType == EntityType.PLAYER) {
                    return;
                }
                if (entityType.isAlive()) {
                    preCreatureSpawnEvent.setShouldAbortSpawn(true);
                    preCreatureSpawnEvent.setCancelled(true);
                }
            }
            if (!plotArea.isMiscSpawnUnowned() && !entityType.isAlive()) {
                preCreatureSpawnEvent.setShouldAbortSpawn(true);
                preCreatureSpawnEvent.setCancelled(true);
            }
            return;
        }
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)object)) {
            preCreatureSpawnEvent.setShouldAbortSpawn(true);
            preCreatureSpawnEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerNaturallySpawnCreaturesEvent(PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnCreaturesEvent) {
        Location location;
        PlotArea plotArea;
        if (Settings.Paper_Components.CANCEL_CHUNK_SPAWN && (plotArea = (location = BukkitUtil.adapt(playerNaturallySpawnCreaturesEvent.getPlayer().getLocation())).getPlotArea()) != null && !plotArea.isMobSpawning()) {
            playerNaturallySpawnCreaturesEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPreSpawnerSpawnEvent(PreSpawnerSpawnEvent preSpawnerSpawnEvent) {
        Location location;
        PlotArea plotArea;
        if (Settings.Paper_Components.SPAWNER_SPAWN && (plotArea = (location = BukkitUtil.adapt(preSpawnerSpawnEvent.getSpawnerLocation())).getPlotArea()) != null && !plotArea.isMobSpawnerSpawning()) {
            preSpawnerSpawnEvent.setCancelled(true);
            preSpawnerSpawnEvent.setShouldAbortSpawn(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (!Settings.Paper_Components.TILE_ENTITY_CHECK || !Settings.Enabled_Components.CHUNK_PROCESSOR) {
            return;
        }
        if (!(blockPlaceEvent.getBlock().getState(false) instanceof TileState)) {
            return;
        }
        Location location = BukkitUtil.adapt(blockPlaceEvent.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        int n = blockPlaceEvent.getBlock().getChunk().getTileEntities(false).length;
        if (n >= Settings.Chunk_Processor.MAX_TILES) {
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(blockPlaceEvent.getPlayer());
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("errors.tile_entity_cap_reached"), TagResolver.resolver("amount", Tag.inserting(Component.text(Settings.Chunk_Processor.MAX_TILES))));
            blockPlaceEvent.setCancelled(true);
            blockPlaceEvent.setBuild(false);
        }
    }

    @EventHandler
    public void onProjectileLaunch(PlayerLaunchProjectileEvent playerLaunchProjectileEvent) {
        if (!Settings.Paper_Components.PLAYER_PROJECTILE) {
            return;
        }
        Projectile projectile = playerLaunchProjectileEvent.getProjectile();
        ProjectileSource projectileSource = projectile.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Location location = BukkitUtil.adapt(projectile.getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt((Player)projectileSource);
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals(plotArea, ProjectilesFlag.class, true) && !bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_ROAD)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_PROJECTILE_ROAD)));
                projectile.remove();
                playerLaunchProjectileEvent.setCancelled(true);
            }
        } else if (!plot.hasOwner()) {
            if (!bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)));
                projectile.remove();
                playerLaunchProjectileEvent.setCancelled(true);
            }
        } else if (!(plot.isAdded(((PlotPlayer)bukkitPlayer).getUUID()) || ((Boolean)plot.getFlag(ProjectilesFlag.class)).booleanValue() || bukkitPlayer.hasPermission(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER))) {
            bukkitPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER)));
            projectile.remove();
            playerLaunchProjectileEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onAsyncTabCompletion(AsyncTabCompleteEvent asyncTabCompleteEvent) {
        String[] stringArray;
        if (!Settings.Paper_Components.ASYNC_TAB_COMPLETION) {
            return;
        }
        String string = asyncTabCompleteEvent.getBuffer();
        if (!(asyncTabCompleteEvent.getSender() instanceof Player)) {
            return;
        }
        if (!asyncTabCompleteEvent.isCommand() && !string.startsWith("/") || string.indexOf(32) == -1) {
            return;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((stringArray = string.split(Pattern.quote(" "))).length == 1) {
            return;
        }
        if (!Settings.Enabled_Components.TAB_COMPLETED_ALIASES.contains(stringArray[0].toLowerCase(Locale.ENGLISH))) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        try {
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt((Player)asyncTabCompleteEvent.getSender());
            Collection<Command> collection = MainCommand.getInstance().tab(bukkitPlayer, stringArray2, string.endsWith(" "));
            if (collection == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Command command : collection) {
                arrayList.add(command.toString());
            }
            asyncTabCompleteEvent.setCompletions(arrayList);
            asyncTabCompleteEvent.setHandled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBeaconEffect(BeaconEffectEvent beaconEffectEvent) {
        Block block = beaconEffectEvent.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        Plot plot = location.getPlot();
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        Player player = beaconEffectEvent.getPlayer();
        Location location2 = BukkitUtil.adapt(player.getLocation());
        BukkitPlayer bukkitPlayer = BukkitUtil.adapt(player);
        Plot plot2 = location2.getPlot();
        if (plot2 == null) {
            FlagContainer flagContainer = plotArea.getRoadFlagContainer();
            if (!this.getBooleanFlagValue(flagContainer, BeaconEffectsFlag.class, true) || plot != null && Settings.Enabled_Components.DISABLE_BEACON_EFFECT_OVERFLOW) {
                beaconEffectEvent.setCancelled(true);
            }
            return;
        }
        FlagContainer flagContainer = plot2.getFlagContainer();
        boolean bl = this.getBooleanFlagValue(flagContainer, BeaconEffectsFlag.class, true);
        if (plot2.equals(plot)) {
            if (!bl) {
                beaconEffectEvent.setCancelled(true);
            }
            return;
        }
        if (!bl || Settings.Enabled_Components.DISABLE_BEACON_EFFECT_OVERFLOW) {
            beaconEffectEvent.setCancelled(true);
        }
    }

    private boolean getBooleanFlagValue(@NonNull FlagContainer flagContainer, @NonNull Class<? extends BooleanFlag<?>> clazz, boolean bl) {
        BooleanFlag<?> booleanFlag = flagContainer.getFlag(clazz);
        return booleanFlag == null ? bl : (Boolean)booleanFlag.getValue();
    }
}

