/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.placeholder.MVdWPlaceholders;
import com.plotsquared.bukkit.util.BukkitEconHandler;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.google.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ServerListener
implements Listener {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ServerListener.class.getSimpleName()));
    private final BukkitPlatform plugin;

    @Inject
    public ServerListener(@NonNull BukkitPlatform bukkitPlatform) {
        this.plugin = bukkitPlatform;
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent serverLoadEvent) {
        if (Bukkit.getPluginManager().getPlugin("MVdWPlaceholderAPI") != null && Settings.Enabled_Components.USE_MVDWAPI) {
            new MVdWPlaceholders((Plugin)this.plugin, this.plugin.placeholderRegistry());
            ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("placeholder.hooked"), new TagResolver[0]);
        }
        if (Settings.Enabled_Components.ECONOMY && Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            EconHandler econHandler = new BukkitEconHandler();
            try {
                if (!((EconHandler)econHandler).init()) {
                    LOGGER.warn("Economy is enabled but no plugin is providing an economy service. Falling back...");
                    econHandler = EconHandler.nullEconHandler();
                }
            }
            catch (Exception exception) {
                econHandler = EconHandler.nullEconHandler();
            }
            EconHandler econHandler2 = PlotSquared.platform().econHandler();
            if (econHandler2 instanceof MutableEconHandler) {
                MutableEconHandler mutableEconHandler = (MutableEconHandler)((Object)econHandler2);
                mutableEconHandler.setImplementation(econHandler);
            }
        }
    }

    public static interface MutableEconHandler {
        public void setImplementation(EconHandler var1);
    }
}

