/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.ReflectionUtils;
import java.lang.reflect.Method;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;

public class SingleWorldListener
implements Listener {
    private final Method methodSetUnsaved;
    private Method methodGetHandleChunk;
    private Object objChunkStatusFull = null;

    public SingleWorldListener() {
        ReflectionUtils.RefClass refClass = ReflectionUtils.getRefClass("{cb}.CraftChunk");
        ReflectionUtils.RefClass refClass2 = ReflectionUtils.getRefClass("net.minecraft.world.level.chunk.IChunkAccess");
        this.methodSetUnsaved = refClass2.getMethod("a", Boolean.TYPE).getRealMethod();
        try {
            this.methodGetHandleChunk = refClass.getMethod("getHandle", new Object[0]).getRealMethod();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                ReflectionUtils.RefClass refClass3 = ReflectionUtils.getRefClass("net.minecraft.world.level.chunk.ChunkStatus");
                this.objChunkStatusFull = refClass3.getRealClass().getField("n").get(null);
                this.methodGetHandleChunk = refClass.getMethod("getHandle", refClass3.getRealClass()).getRealMethod();
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException(noSuchMethodException2);
            }
        }
    }

    public void markChunkAsClean(Chunk chunk) {
        try {
            Object object = this.objChunkStatusFull != null ? this.methodGetHandleChunk.invoke((Object)chunk, this.objChunkStatusFull) : this.methodGetHandleChunk.invoke((Object)chunk, new Object[0]);
            this.methodSetUnsaved.invoke(object, false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void handle(ChunkEvent chunkEvent) {
        World world = chunkEvent.getWorld();
        String string = world.getName();
        PlotAreaManager plotAreaManager = PlotSquared.get().getPlotAreaManager();
        if (!(plotAreaManager instanceof SinglePlotAreaManager)) {
            return;
        }
        if (!SinglePlotArea.isSinglePlotWorld(string)) {
            return;
        }
        int n = chunkEvent.getChunk().getX();
        int n2 = chunkEvent.getChunk().getZ();
        if (n < 16 && n > -16 && n2 < 16 && n2 > -16) {
            return;
        }
        this.markChunkAsClean(chunkEvent.getChunk());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChunkLoad(ChunkLoadEvent chunkLoadEvent) {
        this.handle((ChunkEvent)chunkLoadEvent);
    }
}

